#ifndef __MSGPARSER_H__
#define __MSGPARSER_H__

#include <qobject.h>
#include <qstring.h>
#include "numeric.h"

class IrcClient;
class MsgParser;

typedef int (MsgParser::*msgFunc)(const char* from, const char* txt);
typedef struct MsgCmdTabTag {
  const char* name;
  msgFunc     func;
} MsgCmdTab;



class MsgParser : public QObject
{
  Q_OBJECT
protected:
  static MsgCmdTab  msgStrTab[];
  static MsgCmdTab  ctcpCmd  [];
  static MsgCmdTab  dccCmd   [];
  IrcClient* client;
public:
  // Konstructor
  MsgParser(QObject* Parent, const char* Name=0);
  // Member Funktionen
  int parseLine (const char* txt);
signals:
  void updateStatusListBox(const char*, int);
protected:
  int msgTopic  (const char* from, const char* txt);
  int msgPrivMsg(const char* from, const char* txt);
  int msgNotice (const char* from, const char* txt);
  int msgInvite (const char* from, const char* txt);
  int msgJoin   (const char* from, const char* txt);
  int msgPart   (const char* from, const char* txt);
  int msgMode   (const char* from, const char* txt);
  int msgNick   (const char* from, const char* txt);
  int msgPing   (const char* from, const char* txt);
  int msgPong   (const char* from, const char* txt);
  int msgKick   (const char* from, const char* txt);
  int msgKill   (const char* from, const char* txt);
  int msgQuit   (const char* from, const char* txt);
  int msgError  (const char* from, const char* txt);

  int onNameReply (const char* txt);
  int onWhoisReply(const char* txt);
  int onWhoisServer(const char* txt);
  int onTopic     (const char* txt);
  int onTopicSetBy(const char* txt);
  int onBanList   (const char* txt);
  int onChannelMode(const char* txt);
  int onIson      (const char* txt);
  int onRequestDialog(const char* txt, const char* caption, const char* kom);
  int onNickNameInUse(const char* txt);
  int onListReply(const char* txt, int);
  int onWriteMsg(const char* Event, const char* txt, 
		 int Type, const char* def="Active");

  int sendCtcpReply (const char*);
  int onCtcp        (const char* from, const char* txt);
  int ctcpFinger    (const char* from, const char* txt);
  int ctcpVersion   (const char* from, const char* txt);
  int ctcpClientInfo(const char* from, const char* txt);
  int ctcpPing      (const char* from, const char* txt);
  int ctcpSource    (const char* from, const char* txt);
  int ctcpAction    (const char* from, const char* txt);
  int ctcpDCC       (const char* from, const char* txt);
  int ctcpSound     (const char* from, const char* txt);
  int onCtcpReply   (const char* from, const char* txt);

  int dccChat       (const char* from, const char* txt);
  int dccFile       (const char* from, const char* txt);
  
};

#endif







