#include <iostream.h>
#include <sys/time.h>
#include <qmsgbox.h> 
#include "kmsgbox.h"
#include "lineDialog.h"
#include "ircClient.h"
#include "IrcSocket.h"
#include "ircDialog.h"
#include "StringToken.h"
#include "MsgParser.h"
#include "MsgParser.moc"
#include "ircDefine.h"
#include "ircBell.h"
#include "ircApp.h"

MsgCmdTab MsgParser::msgStrTab[]={
    {"TOPIC",     MsgParser::msgTopic     },
    {"PRIVMSG",   MsgParser::msgPrivMsg   },
    {"NOTICE",    MsgParser::msgNotice },
    {"INVITE",    MsgParser::msgInvite },
    {"JOIN",      MsgParser::msgJoin },
    {"PART",      MsgParser::msgPart },
    {"MODE",      MsgParser::msgMode },
    {"NICK",      MsgParser::msgNick },
    {"PING",      MsgParser::msgPing },
    {"PONG",      MsgParser::msgPong },
    {"KICK",      MsgParser::msgKick },
    {"KILL",      MsgParser::msgKill },
    {"QUIT",      MsgParser::msgQuit },
    {"ERROR",     MsgParser::msgError },
    {NULL,        NULL}
};

MsgParser::MsgParser(QObject* Parent, const char* Name):
  QObject(Parent, Name)
{
  client = (IrcClient*)Parent;
}

int MsgParser::parseLine(const char* txt)
{
  QString entry, value;
  entry = "ShowRawInput";
  value = ircapp->readEntry(entry, "No");
  if (!stricmp(value, "yes"))
     client->slotWritePage("kEirc Raw", TYPE_INFO|TYPE_IMG, 
			   QString("[INP] ")+txt, false);

  StringToken token(txt," ");
  QString from, cmd, rest; 

  // :from cmd
  // cmd
#ifdef EDEBUG
  cout << txt << endl;
#endif

  from=token.nextToken();
  if (!from)
     return 0;
  
  if (from[0]==':'){
     from = from.remove(0,1);
     cmd = token.nextToken();
  }
  else{
     cmd  = from;
     from = client->curServer->Host();
  }
  rest = token.toEnd();
  if (rest.isNull())
     return 0;
  if (rest[0]==':')
     rest = rest.remove(0, 1);

  bool status;
  int  cmdNum = cmd.toInt(&status);
  if (!status){
     for (int i=0;msgStrTab[i].name!=NULL;i++){
        if (!stricmp(cmd,msgStrTab[i].name)){
	   return (this->*(msgStrTab[i].func))(from, rest);
	}
     }
     QString to=token.nextToken(" :");
     client->slotWriteMsg(TYPE_MSG|TYPE_IMG, token.toEnd());
     return 0;
  }
  QString n=token.nextToken();
  rest = token.toEnd(" :");
  // Numeric
  switch (cmdNum){
  case ERR_BANNEDFROMCHAN:
    return onRequestDialog(rest,"Banned From Channel", "(+b)");
    break;
  case ERR_INVITEONLYCHAN:
    return onRequestDialog(rest,"Invite Only Channel", "(+i)");
    break;
  case ERR_BADCHANNELKEY:
    return onRequestDialog(rest,"Bad Channel Key", "(+k)");
    break;
  case ERR_CHANNELISFULL:
    return onRequestDialog(rest, "Channel Full", "(+l)");
  case ERR_ERRONEUSNICKNAME:
  case ERR_NICKNAMEINUSE:
    return onNickNameInUse(rest);
    break;
  case ERR_NOSUCHNICK:
  case ERR_NOSUCHCHANNEL:
  case ERR_CANNOTSENDTOCHAN:
  case ERR_WASNOSUCHNICK:
  case ERR_NOTEXTTOSEND:
  case ERR_UNKNOWNCOMMAND:
    return onWriteMsg("OnEventOutputERROR", rest, TYPE_ERROR|TYPE_IMG, "Status");
    break;
  case RPL_WELCOME :
    return client->onStarting(n+" "+rest);
  case RPL_NAMREPLY:
    return onNameReply(rest);
    break;
  case RPL_ISON:
    return onIson(rest);
    break;
  case RPL_TOPICSETBY:
    return onTopicSetBy(rest);
    break;
  case RPL_TOPIC:
    return onTopic(rest);
    break;
  case RPL_INVITING:
    break;
  case RPL_WHOISUSER:
    return onWhoisReply(rest);
    break;
  case RPL_WHOISSERVER:
    return onWhoisServer(rest);
    break;
  case RPL_WHOISOPERATOR:
  case RPL_WHOISIDLE:
  case RPL_WHOISCHANNELS:
  case RPL_AWAY:
    return onWriteMsg("OnEventOutputWHOIS", rest, TYPE_INFO|TYPE_IMG);
    return 1;
    break;
  case RPL_LISTSTART:
  case RPL_LIST:
  case RPL_LISTEND:
    return onListReply(rest, cmdNum-RPL_LISTSTART);
    break;
  case RPL_ENDOFWHOIS:
  case RPL_ENDOFWHOWAS:
  case RPL_ENDOFNAMES:
  case RPL_ENDOFBANLIST:
    return 1;
    break;
  case RPL_BANLIST:
    return onBanList(rest);
    break;
  case RPL_CHANNELMODEIS:
    return onChannelMode(rest);
    break;
  }

  rest=rest.stripWhiteSpace();
  if (rest.isEmpty())
     return 0;
  // Error
  if (cmdNum > 399){
     return onWriteMsg("OnEventOutputERROR", rest, TYPE_ERROR|TYPE_IMG, "Status");
     return 1;
  }

  client->slotWriteMsg(TYPE_MSG|TYPE_IMG, rest);
  return 1;
}

int MsgParser::msgTopic(const char* from, const char* txt)
{
  StringToken tokFrom(from);
  StringToken tokTxt (txt);
  QString nick=tokFrom.nextToken(" !");
  QString chan=tokTxt.nextToken();
  QString top =tokTxt.toEnd(" :");
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  ic->setTopic(top, from);

#ifdef TCL
  QString entry="BIND_TOPIC";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);
    
    int nTcl=client->tclCmd->getBindProc("TOPIC", top, funcName);
    if (nTcl){
      QString argv = nick+" "+chan+" "+QString(from)+" "+top;
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif

  return 1;
}

int MsgParser::msgPrivMsg(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "msgPrivMsg:" << txt << endl;
#endif
  int status=0;
  StringToken tf(from);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString to=tt.nextToken();
  QString  s=tt.toEnd("\n");
  int idx=s.find(':');
  idx++;
  s = s.mid(idx, s.length()-idx);

  if (s.isEmpty())
     return 0;

  // TCL THIngs
  QStrList funcName;
  funcName.setAutoDelete(TRUE);

#ifdef TCL
  QString entry="BIND_MSG";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    int nTcl=client->tclCmd->getBindProc("MSG", s, funcName);
    if (nTcl){
      QString argv = nick+" "+to+" "+QString(from)+" "+s;
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif

  if (s[0]==0x001 && s[s.length()-1]==0x001){
     s.remove(0,1);
     s.remove(s.length()-1, 1);
     status = onCtcp(from, to+" "+s);
  }
  else if (to[0]=='#' || to[0]=='&'){
#ifdef TCL
     QString entry="BIND_CHANMSG";
     QString value=ircapp->readEntry(entry, "Yes");
     if (value=="Yes"){
       int nTcl=client->tclCmd->getBindProc("CHANMSG", s, funcName);
       if (nTcl){
	 QString argv = nick+" "+to+" "+QString(from)+" "+s;
	 client->tclCmd->evalCmd(funcName, argv);
       }
     }
#endif

     // Check ignored
     if (client->isIgnored(from, "c"))
        return 1;

     IrcChannel* ic=client->channel->find(to);
     if (!ic)
        return 0;
     status = ic->onMsg(from, s);
  }
  else if (to == client->currentNick()){
#ifdef TCL
     QString entry="BIND_PRIVMSG";
     QString value=ircapp->readEntry(entry, "Yes");
     if (value=="Yes"){
       int nTcl=client->tclCmd->getBindProc("PRIVMSG", s, funcName);
       if (nTcl){
	 QString argv = nick+" "+to+" "+QString(from)+" "+s;
	 client->tclCmd->evalCmd(funcName, argv);
       }
     }
#endif
     // Check ignored
     if (client->isIgnored(from, "p"))
        return 1;

     IrcBell* ib=client->bell.find("PrivMsgBell");
     if (ib)
        ib->slotPlay();
     IrcPrivMsg* ip=client->privMsg->find(nick);
     if (!ip){
        QString value=ircapp->readEntry("OnPrivMsg", "AutoAccept");
	if (value=="Ignore")
	   return 0;
	else if (value=="AutoAccept")
	   client->addPrivMsg(from);
	else {
	   IrcDialog dlg(
			 client,
			 "PrivMsgDlgTimeout",
			 "PrivMsgDlgMax",
			 "PrivMsgDlgCur",
			 "Privmsg Dialog",
			 "Privmsg from "+nick+"\n("+QString(from)+")\n Accept it?\n",
			 "",
			 true,
			 0L,
			 from);
	   if (dlg.exec())
	      client->addPrivMsg(from);
	   else
	      return 0;
	}
	if (!(ip = client->privMsg->find(nick)))
	   return 0;
     }
     status = ip->onMsg(from, s);
  }
  return status;
}

int MsgParser::msgNotice(const char* from, const char* txt)
{
  StringToken tf(from);
  StringToken tt(txt);
  QString who  = tf.nextToken(" !");
  QString to   = tt.nextToken();
  QString kom  = tt.toEnd("\n");
  int idx=kom.find(':');
  idx++;
  kom = kom.mid(idx, kom.length()-idx);

  QString t="";
  if (kom.isEmpty())
     return 0;
  if (kom[0]==0x001 && kom[kom.length()-1]==0x001){
     kom.remove(0,1);
     kom.remove(kom.length()-1, 1);
     return onCtcpReply(from, kom);
  }

  // Check ignored
  if (client->isIgnored(from, "n"))
     return 1;
  if (to[0]=='#' || to[0]=='&'){
     IrcChannel* ic=client->channel->find(to);
     if (!ic)
        return 0;
      t += 0x02;
      t += "="+who+"=";
      t += 0x02;
      t += " "+kom;
      ic->slotWriteMsg(TYPE_NOTICE, t);
      ic->checkFlood(from);
      return 1;
  }

  if (to == client->currentNick()){
     QString t="";
     t += 0x02;
     t += "="+who+"=";
     t += 0x02;
     t += " "+kom;

     IrcPrivMsg* ip=client->privMsg->find(who);
     if (ip){
        ip->slotWriteMsg(TYPE_NOTICE, t);
	ip->checkFlood(from);
     }
     else
        client->slotWriteOnActive(TYPE_NOTICE, t);
     return 1;
  }
  else{
     QString t="";
     t += 0x02;
     t += "="+who+"=";
     t += 0x02;
     t += " "+kom;
     client->slotWriteMsg(TYPE_NOTICE, t);
     return 1;
  }
    
  return 0;
}

int MsgParser::msgInvite(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::msgInvite:"<<from <<":"<<txt<<endl;
#endif
  if (client->isIgnored(from,"i"))
     return 1;
  IrcBell* ib=client->bell.find("InviteBell");
  if (ib)
     ib->slotPlay();
  StringToken tf(from);
  StringToken tt(txt);
  QString who = tf.nextToken(" !");
  QString to  = tt.nextToken();
  QString chan= tt.nextToken(" :");

  QString val=ircapp->readEntry("OnChannelInvite", "Dialog");

  if (!stricmp(val, "Ignore"))
     return 1;
  if (!stricmp(val, "AutoJoin")){
     client->getSocket().sendJoin(chan);
     return 1;
  }
  
  QString ts;
  ts =who+" invites you to channel "+chan+"\n";
  ts += "Join it ?";
  IrcDialog dlg(client, 
		"InvDlgTimeout",
		"InvDlgMax",
		"InvDlgCur",
		"Invite Dialog "+chan,
		ts, 
		"/JOIN "+chan+"\n",
		true,
		0L,
		from);
  dlg.exec();
  return 1;
}

int MsgParser::msgJoin(const char* from, const char* txt)
{
  StringToken tf(from);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString chan=tt.nextToken();
  if (nick==client->currentNick()){
     client->addChannel(chan);
  }
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  int status=ic->joinChannel(from);

#ifdef TCL
  QString entry="BIND_JOIN";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);
    
    int nTcl=client->tclCmd->getBindProc("JOIN", from, funcName);
    if (nTcl){
      QString argv = nick+" "+chan+" "+QString(from);
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif

  return status;
}

int MsgParser::msgPart(const char* from, const char* txt)
{
  StringToken tf(from);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString chan=tt.nextToken();
  if (nick==client->currentNick()){
     client->delChannel(chan);
     return 1;
  }
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  int status=ic->partChannel(from);

#ifdef TCL
  QString entry="BIND_PART";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);
    
    int nTcl=client->tclCmd->getBindProc("PART", from, funcName);
    if (nTcl){
      QString argv = nick+" "+chan+" "+QString(from);
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif
  return status;
}

int MsgParser::msgMode(const char* From, const char* txt)
{
  StringToken tf(From);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString to = tt.nextToken();
  int status;
  if (to==client->currentNick()){
     QString mode=tt.nextToken(" :");
     status=client->setMode(mode);
  }
  else {
     IrcChannel* ic=client->channel->find(to);
     if (!ic)
        return 0;
     status=ic->setMode(From, tt.toEnd());
  }

#ifdef TCL
  QString entry="BIND_MODE";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
     QStrList funcName;
     funcName.setAutoDelete(TRUE);
     
     QString     mode = tt.nextToken();
     StringToken pt(tt.toEnd());

     QString ms="";
     for (uint i=0;i<mode.length();i++){
        switch(mode[i]){
	case '+':
	  ms += '+';
	  break;
	case '-':
	  ms += '-';
	  break;
	default :
	  ms += mode[i];
	  int nTcl=client->tclCmd->getBindProc("MODE", ms, funcName);
	  if (nTcl){
	     QString argv = nick+" "+to+" "+QString(From)+" "+ms+" "+pt.nextToken();
	     client->tclCmd->evalCmd(funcName, argv);
	  }
	  ms = "";
	  break;
	}
     }
  }
#endif

  return status;
}

int MsgParser::msgNick(const char* from, const char* txt)
{
  StringToken tf(from);
  QString nick=tf.nextToken(" !");
  StringToken tt(txt);
  QString newNick  =tt.nextToken(" :");
  if (nick==client->currentNick()){
     client->setCurNick(newNick);
  }
  // CHANNEL
  QDictIterator<IrcChannel> it(*client->channel);
  IrcChannel* ic;
  for (ic=it.current();(ic=it.current())!=0L;++it){
      if (ic->cuList->find(nick)!=NULL){
	 ic->changeNick(nick, newNick);
      }
  }
  // PRIVMSG
  IrcPrivMsg* ip=client->privMsg->take(nick);
  if (ip){
     client->privMsg->insert(newNick, ip);
     ip->changeNick(nick, newNick);
  }

#ifdef TCL
  QString entry="BIND_NICK";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
     QStrList funcName;
     funcName.setAutoDelete(TRUE);
     
     int nTcl=client->tclCmd->getBindProc("NICK", newNick, funcName);
     if (nTcl){
       QString argv = nick+" "+newNick+" "+QString(from);
       client->tclCmd->evalCmd(funcName, argv);
     }
  }
#endif
  return 1;
}

int MsgParser::msgPing(const char*, const char* txt)
{
  return client->getSocket().sendPong(txt);
}

int MsgParser::msgPong(const char*, const char* txt)
{
  StringToken tt(txt);
  
  QString to=tt.nextToken();
  QString sc=tt.nextToken(" :");
  ulong cur=(ulong)time(NULL);
  ulong dif=cur-sc.toULong();
  QString lag;
  lag.setNum(dif);
  client->slotLagging(lag);
  return 1;
}

int MsgParser::msgKick(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout <<"msgKick:"<< from << ":"<<txt<<endl;
#endif
  StringToken tf(from);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString chan=tt.nextToken();
  QString kicked=tt.nextToken();
  QString rest  =kicked+" "+tt.toEnd();
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;

#ifdef TCL
  QString entry="BIND_KICK";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);

    int nTcl=client->tclCmd->getBindProc("KICK", kicked, funcName);
    if (nTcl){
      QString argv = nick+" "+kicked+" "+QString(from)+" "+rest;
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif

  int status=0;
  ic->onKick(from, rest);
  if (kicked==client->currentNick()){
     IrcBell* ib=client->bell.find("KickBell");
     if (ib)
        ib->slotPlay();
     client->delChannel(chan);

     QString val=ircapp->readEntry("OnChannelKick", "Quiet");
     if (!stricmp(val, "Quiet"))
        status=1;
     else if (!stricmp(val, "AutoJoin")){
        client->getSocket().sendJoin(chan);
	status=1;
     }
     else {
        QString ts;
	ts = "You have been kicked off on "+chan+"\n";
	ts += "by "+nick+"("+QString(from)+")\n";
	ts += "Rejoin ?\n";
	IrcDialog dlg(client, 
		   "KickDlgTimeout",
		   "KickDlgMax",
		   "KickDlgCur",
		   "Kick Dialog "+chan,
		   ts, 
		   "/JOIN "+chan+"\n", 
		   true);
	dlg.exec();
     }
  }
  return status;
}

int MsgParser::msgKill(const char* from, const char* txt)
{
  StringToken tf(from);
  StringToken tt(txt);
  QString killed=tt.nextToken();
  QString kom   =tt.toEnd(" :");
  if (killed==client->currentNick()){
     QString t;
     t = "You have been killed by "+QString(from)+" ("+kom+")";

     QString entry=ircapp->readEntry("OnEventOutputKILL", "Status");
     if (!stricmp(entry, "Active"))
        client->slotWriteOnActive(TYPE_INFO|TYPE_IMG, t);
     else if (!stricmp(entry, "Status"))
        client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);

     client->slotDisconnected();
     return 1;
  }

  QDictIterator<IrcChannel> it(*client->channel);
  IrcChannel* ic;
  for (;(ic=it.current())!=0L;++it){
      if (ic->cuList->find(killed)!=NULL){
	 ic->onKill(from, txt);
      }
  }
  
  return 1;
}

int MsgParser::msgQuit(const char* from, const char* txt)
{
  StringToken tf(from);
  StringToken tt(txt);
  QString nick=tf.nextToken(" !");
  QString kom =tt.toEnd(" :");
  QDictIterator<IrcChannel> it(*client->channel);
  IrcChannel* ic;
  for (;(ic=it.current())!=0L;++it){
      if (ic->cuList->find(nick)!=NULL){
	 ic->onQuit(from, kom);
      }
  }
  return 1;
}

int MsgParser::msgError(const char*, const char* txt)
{
  QString st=txt?txt:"";

  QString entry=ircapp->readEntry("OnEventOutputERROR", "Status");
  if (!stricmp(entry, "Active"))
     client->slotWriteOnActive(TYPE_ERROR|TYPE_IMG, st);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_ERROR|TYPE_IMG, st);

  client->slotDisconnected();
  return 1;
}

// nick = #channel :@nick nick +nick
int MsgParser::onNameReply(const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onNameReply("<<txt<<")"<<endl;
#endif
  StringToken tt(txt);
  QString tmp;
  tmp=tt.nextToken();
  QString channel=tt.nextToken();
  IrcChannel* ic=client->channel->find(channel);
  if (!ic){
     return 0;
  }
  QString t="User on channel ";
  QString e=tt.toEnd(" :");
  t += QString(ic->name())+" "+e;
  client->slotWriteMsg(TYPE_MSG|TYPE_IMG, t);

  if (!ic->firstJoin)
     return 1;

  QString nick;
  QString mode="";
  int id;
  
  while(tt.hasMoreTokens(" :\n\r\t\b\v")){
       mode ="";
       nick=tt.nextToken();
       if (nick.isNull())
	  continue;
       id=nick.find('+', 0, FALSE);
       if (id>=0&&id<=1){
	  nick.remove(id, 1);
	  mode += 'v';
       }
       id=nick.find('@', 0, FALSE);
       if (id>=0&&id<=1){
	  nick.remove(id, 1);
	  mode += 'o';
       }
       ic->addUser(nick);
       if (mode.length())
	  ic->addUserMode(nick, mode);
  }
  ic->firstJoin=0;
  return 1;
}

int MsgParser::onTopic(const char* txt)
{
  StringToken tt(txt);
  QString chan=tt.nextToken();
  QString top =tt.toEnd(" :");
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  ic->setTopic(top, NULL);
  return 1;
}

int MsgParser::onTopicSetBy(const char* txt)
{
  StringToken tt(txt);
  QString chan  = tt.nextToken();
  QString setby = tt.toEnd(" :");
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  ic->setTopic(NULL, setby);
  return 1;
}


int MsgParser::onBanList(const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onBanList:" <<txt<<endl;
#endif
  StringToken tt(txt);
  QString chan  = tt.nextToken();
  QString ban   = tt.nextToken();
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;

  QString t="Ban on channel ";
  t += QString(ic->name())+" "+ban;
  client->slotWriteMsg(TYPE_INFO|TYPE_MSG, t);

  QString mode = "+b "+ban;
  return ic->setMode("", mode);
}


int MsgParser::onChannelMode(const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onChannelMode:" <<txt<<endl;
#endif
  StringToken tt(txt);
  QString chan  = tt.nextToken();
  QString mode  = tt.toEnd();
  IrcChannel* ic=client->channel->find(chan);
  if (!ic)
     return 0;
  return ic->setMode("", mode);
}


int MsgParser::onIson(const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onIson:"<<txt<<endl;
#endif
  StringToken t(txt);
  QStrIList list;
  QString   off="";
  QString   on ="";
  list.setAutoDelete(true);
  list = client->onList;
  client->onList.clear();
  QString n;
  int idx;
  while (t.hasMoreTokens()){
        n=t.nextToken();
	client->onList.append(n);
	if ((idx=list.find(n))>=0)
	   list.remove(idx);
	else
	   on +=n+" ";
  }

  for (n=list.first();n;n=list.next())
      off +=n+" ";

  if (!on.isEmpty()){
    QString s = "Signon "+on;
    QString entry=ircapp->readEntry("OnEventOutputISON", "Active");
    if (!stricmp(entry, "Active"))
       client->slotWriteOnActive(TYPE_INFO|TYPE_IMG, s);
    else if (!stricmp(entry, "Status"))
       client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  }
  if (!off.isEmpty()){
     QString s = "Signoff "+off;
     QString entry=ircapp->readEntry("OnEventOutputISON", "Active");
     if (!stricmp(entry, "Active"))
        client->slotWriteOnActive(TYPE_INFO|TYPE_IMG, s);
     else if (!stricmp(entry, "Status"))
        client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  }
  IrcCore* timer=client->timerList["IsOn"];
  int isonTimer=ircapp->readNumEntry("IsonDelay", 2);
  if (isonTimer<1)
    isonTimer=1;
  timer->setCusInterval((ulong)(isonTimer*60));
  if (!timer->isActive())
     timer->start();
  return 1;
}

int MsgParser::onRequestDialog(const char* txt, const char* Caption, const char* kom)
{
  StringToken t(txt);
  QString to=t.nextToken();
  QString ts=t.toEnd(" :");
  KMsgBox::message(NULL, 
		   QString(Caption)+" "+to,
		   ts+QString(kom)+ "\n",
		   KMsgBox::INFORMATION,
		   "OK");
  return 1;
}

int MsgParser::onNickNameInUse(const char* txt)
{
  StringToken t(txt);
  QString nick=t.nextToken();
  QString entry = "AutoChangeNick";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes"){
     int idx=client->nick.find(nick);
     if (idx>=0){
        if (++idx >= (int)client->nick.count())
	   idx=0;
	if (client->nick.at(idx)!=client->currentNick()){
	   client->getSocket().sendNick(client->nick.at(idx));
	   return 1;
	}
     }
  }
  SingleDialog dlg ("New nick:","", txt);
  if (dlg.exec()){
     QString nn=dlg.getText(TRUE);
     if (!nn.isEmpty())
        client->getSocket().sendNick(nn);
  }
  return 1;
}

int MsgParser::onWhoisReply(const char* txt)
{

  StringToken t(txt);
  QString nick=t.nextToken(" ");
  QString user=t.nextToken(" ");
  QString host=t.nextToken(" ");
  QString info=t.toToken(":");
  info = t.toEnd();

  IrcChannel* ic;
  IrcUser*    iu;
  QDictIterator<IrcChannel> c_it (*client->channel);
  for (;(ic=c_it.current())!=0L;++c_it){
      iu = ic->cuList->find(nick);
      if (iu && iu->info().isEmpty()){
	 iu->setInfo(info);
      }
  }
  
  IrcPrivMsg* ipm=client->privMsg->find(nick);
  if (ipm){
     ipm->setUser(nick, user, host);
     ipm->user->setInfo(info);
  }

  client->whoisCache->remove(nick);
  iu=new IrcUser(nick, user, host);
  iu->setInfo(info);
  client->whoisCache->insert(nick, iu);

  QString out = nick+" is "+nick+"!"+user+"@"+host+" < "+info+" > "; 

  QString entry=ircapp->readEntry("OnEventOutputWHOIS", "Active");
  if (!stricmp(entry, "Active"))
     client->slotWriteOnActive(TYPE_INFO|TYPE_IMG, out);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, out);
  else{
     iu=new IrcUser(nick, user, host);
     iu->setInfo(info);
     client->getWhoisDialog()->addIrcUser(iu);
  }
  return 1;
}

int MsgParser::onWhoisServer(const char* txt)
{

  StringToken t(txt);
  QString nick  =t.nextToken(" ");
  QString server=t.nextToken(" ");

  IrcChannel* ic;
  IrcUser*    iu;
  QDictIterator<IrcChannel> c_it (*client->channel);
  for (;(ic=c_it.current())!=0L;++c_it){
      iu = ic->cuList->find(nick);
      if (iu && iu->server().isEmpty()){
	 iu->setServer(server);
      }
  }

  IrcPrivMsg* ipm=client->privMsg->find(nick);
  if (ipm)
     ipm->user->setServer(server);

  iu=client->whoisCache->find(nick);
  if (iu!=0L)
     iu->setServer(server);

  client->getWhoisDialog()->setServer(nick, server);

  QString out = nick+"    "+server+" "+t.toEnd(); 

  QString entry=ircapp->readEntry("OnEventOutputWHOIS", "Active");
  if (!stricmp(entry, "Active"))
     client->slotWriteOnActive(TYPE_INFO|TYPE_IMG, out);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, out);
  return 1;
}

int MsgParser::onListReply(const char* txt, int f)
{
  QString s="";
  if (f==1){
     StringToken t(txt);
     s=t.nextToken(" ");
  }
  emit updateStatusListBox(s, f);
  return 1;
}

int MsgParser::onWriteMsg(const char* event, const char* txt, int Type, const char* def)
{
  QString entry=ircapp->readEntry(event, def);
  if (!stricmp(entry, "Active"))
     client->slotWriteOnActive(Type, txt);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(Type, txt);
  return 1;
}




