#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qframe.h>
#include "kmsgbox.h"
#include "StringToken.h"
#include "ircDefine.h"
#include "lineDialog.h"
#include "ircClient.h"
#include "opActionDialog.h"
#include "ircApp.h"

class IrcClient;

OpActionDialog::OpActionDialog(IrcClient* client, QWidget *parent, const char *name ) : 
  LineDialog(parent, name, true, "Op Action Channel Config")
{
#ifdef EDEBUG
  cout << "OpActionDialog Konstruktor"<<endl;
#endif
  mClient = client;
  createDialog();
  setMinimumWidth(400);
}

OpActionDialog::~OpActionDialog()
{
#ifdef EDEBUG
  cout << "Destruktor OpActionDialog" << endl;
#endif
}


void OpActionDialog::createDialog()
{
#ifdef EDEBUG
  cout << "OpActionDialog::createChannelBox" << endl;
#endif

  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Op Action :");       
  ll.append("Deop Action :");     
  ll.append("Voice Action :");   
  ll.append("Devoice Action :");
  ll.append("Ban Action :");
  ll.append("Kick Action :");

  varList.setAutoDelete(true);
  varList.append("ChannelOpAction");
  varList.append("ChannelDeopAction");
  varList.append("ChannelVoiceAction");
  varList.append("ChannelDevoiceAction");
  varList.append("ChannelBanAction");
  varList.append("ChannelKickAction");

  KConfig* config=ircapp->config;
  QString var, val;
  for (var=varList.first();varList.current()!=0L;var=varList.next()){
     val = config->readEntry(var, "");
     le.append(val);
  }

  setText(ll, le);
}

void OpActionDialog::done(int result)
{
  if (result==Accepted){
     KConfig* config=ircapp->config;
     QString var, val;
     for (uint idx=0;idx<varList.count();idx++){
        var = varList.at(idx);
	val = LineDialog::getText(idx);
	config->writeEntry(var, val);
     }
  }
  hide();
}

void OpActionDialog::show()
{
  QPoint p=pos();
  move(p);
  QDialog::show();
}

QString OpActionDialog::getText(const char* var)
{
  int idx = varList.find(var);
  if (idx<0)
     return "";
  return LineDialog::getText(idx);
}

#include "opActionDialog.moc"




