#ifndef __CHANNELDIALOG_H__
#define __CHANNELDIALOG_H__

#include <qwidget.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qdialog.h>
#include "ktablistbox.h"

class IrcClient;

class ChannelDialog : public QDialog
{
  Q_OBJECT
protected:
  IrcClient*   mClient;
  QLineEdit*   mChannelEdit;
  KTabListBox* mChannelBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

public:
  ChannelDialog(IrcClient* client, QWidget *parent = 0L, const char *name = 0L);
  ~ChannelDialog();
  virtual void show();
protected:
  void    readConfig();
  void    createButton();
  void    createChannelBox();
  bool    checkItem(QString s);
protected slots:
  void slotAdd();
  void slotDelete();
  void slotJoin();
  void slotOk();
};

#endif
