
#include <config.h>
#include <janbot.h>


/* Function: Reads a line from the server and prepares it for parsing. */
int read_server_line(char *buff)
{
	int index=0;
	char tmp;
	fd_set fdvar;
	struct timeval tval={0,0};
	
	FD_ZERO(&fdvar);
	FD_SET(sconn.servfd,&fdvar);
	if (select(sconn.servfd+1,&fdvar,(fd_set *)0,(fd_set *)0,&tval))
	{
		time(&sconn.lastrecv);
		DEBUG1("Server activity at %lu\n",time(NULL));
		while(read(sconn.servfd,&tmp,1)>0)
		{
			if (tmp!='\n')
			{
				buff[index++]=tmp;
			}
			else
			{
				buff[index]='\0';
				return(index);
			}
		}
		return(-1);
	}
	buff[0]='\0';
	return (0);
}

/* Function: Parses a prepared line from the server. */
int parse_server_line(char *buff)
{
	char *orig,*cmd,*dest,*args,*tmp;
	
	
	for (tmp=buff;(*tmp!='\r')&&(*tmp!='\0');tmp++);
	*tmp='\0';
	
	if (buff[0]==':')
	{
		orig=++buff;
		for (args=orig;(*args!=' ')&&(*args!='\0');args++);
		if (*args==' ') *args='\0';
		cmd=++args;
		for (;(*args!=' ')&&(*args!='\0');args++);
		if (*args==' ') *args='\0';
		dest=++args;
		for (;(*args!=' ')&&(*args!='\0');args++);
		if (*args==' ') *args='\0';
		if (*++args==':') args++;
				
		if (strchr(orig,'!')!=NULL)
		{
			parse_client_message(orig,cmd,args);
		}
		else
		{
			parse_server_message(orig,cmd,args);
		}		
	}
	else
	{
		args=buff;
		while ((*args!=' ')&&(*args!='\0')) args++;
		*args++='\0';
		if (strcasecmp(buff,"PING")==0)
		{
			send_to_server("PONG :%s\n",cfg.nick);
		}
		else
		if (strcasecmp(buff,"ERROR")==0)
		{
			close(sconn.servfd);
			DEBUG0("ERROR: Connection closed from server.\n");
			log(SERV,"SERVER ERROR \"%s\"",args);
		}
		else
		if (strcasecmp(buff,"NOTICE")==0)
		{
			log(SERV,"SERVER NOTICE \"%s\"",args);
		}
		/* There are lots of more server messages, but there's */
		/* no point in trying to handle them. Most of it is */
		/* channel related information, which we do not care about. */
		else log(SERV,"SERVER ??? \"%s\"",args);
	}
	return(0);
}

/* Function: Parses a server message. */
void parse_server_message(char *orig,char *cmd,char *args)
{
	int numeric;
	sscanf(cmd,"%d",&numeric);
	switch (numeric)
	{
	case 302:
		parse_userhost_reply(args);
		break;
	case 433:
		close(sconn.servfd);
		DEBUG0("Bugger. Nickname in use.\n");
		log(SERV,"Nickname in use: %s.",cfg.nick);
		break;
	default:
		DEBUG2("SrvMsg %.3d: %s\n",numeric,args);
	}
}

/* Function: Parses a message from a client. */
void parse_client_message(char *orig,char *cmd,char *args)
{
	if (*args=='\001')
	{
		args++;
		*strrchr(args,'\001')='\0';
		if (strcasecmp(cmd,"PRIVMSG")==0)
		{
			parse_ctcp(orig,args);
		}
		else
		if (strcasecmp(cmd,"NOTICE")==0)
		{
			parse_ctcp_reply(orig,args);
		}
	}
	else
	{
		if (strcasecmp(cmd,"PRIVMSG")==0)
		{
			parse_privmsg(orig,args);
		}
		else
		if (strcasecmp(cmd,"NOTICE")==0)
		{
			parse_notice(orig,args);
		}
	}
}

/* Function: Parses a CTCP from a client. */
void parse_ctcp(char *orig, char *args)
{
	char *cmd=args,*tmp,*u,*h,mask[USERHOST_LEN+1],pw[9];
	int ctcperr;
	struct chat_t *tmpc;
	struct user_t *tmpu;

	for (;(*args!=' ')&&(*args!='\0');args++);
	if (*args==' ') *args++='\0';

	log(CTCP,"CTCP %s from %s.",cmd,orig);

	if (!strcasecmp(cmd,"PING"))
	{
		send_to_server("NOTICE %s :\001PING %s\001\n",getnick(orig),args);
	}
	else
	if (!strcasecmp(cmd,"VERSION"))
	{
		send_to_server("NOTICE %s :\001VERSION %s\001\n",getnick(orig),BOTVERSION);
	}
	else
	if (!strcasecmp(cmd,"DCC"))
	{
		incoming_dcc(orig,args);
		return;
	}
	else
	if (!strcasecmp(cmd,"HELP"))
	{
		send_to_server("NOTICE %s :\001HELP \002%s\002 CTCP HELP:\001\n",getnick(orig),cfg.nick);
		send_to_server("NOTICE %s :\001HELP  \002AUTH\002 <passwd>   - Request connection.\001\n",getnick(orig));
		if (!cfg.tightarsedsecurity) send_to_server("NOTICE %s :\001HELP  \002IDENT\002 <passwd>  - Register hostmask.\001\n",getnick(orig));
		send_to_server("NOTICE %s :\001HELP  \002KILLME\002 <passwd> - Terminate connection.\001\n",getnick(orig));
		send_to_server("NOTICE %s :\001HELP End of help.\001\n",getnick(orig));
	}
	else
	if (!strcasecmp(cmd,"KILLME"))
	{
		for (tmp=args;(*tmp!=' ')&&(*tmp!='\0');tmp++);
		if (*tmp==' ') *tmp='\0';
		if (authenticate(getnick(orig),getuserhost(orig),args,&users)==0)
		{
			if ((tmpc=find_chat(get_user(getnick(orig),&users),&chatlist))!=NULL)
			{
				kill_chat(tmpc,&chatlist);
				send_to_server("NOTICE %s :\001KILLME Connection has been terminated.\001\n",getnick(orig));
			}
			else
			{
				send_to_server("NOTICE %s :\001KILLME No connection found.\001\n",getnick(orig));
			}
		}
	}
	else	
	if (!cfg.tightarsedsecurity&&!strcasecmp(cmd,"IDENT"))
	{
		for (tmp=args;(*tmp!=' ')&&(*tmp!='\0');tmp++);
		if (*tmp==' ') *tmp='\0';
		if (chkpasswd(getnick(orig),args,&users)==0)
		{
			u=strtok(getuserhost(orig),"@");
			if (*u=='^') u++;
			else if (*u=='~') u++;
			else if (*u=='+') u++;
			else if (*u=='=') u++;
			else if (*u=='-') u++;
			h=create_hostmask(strtok(NULL,"@"));
			sprintf(mask,"%s@%s",u,h);
			add_userhost(getnick(orig),mask,&users);
			send_to_server("NOTICE %s :\001IDENT Okay, I now recognize you from \002%s\002.\001\n",getnick(orig),mask);
		}
		else
		{
			if (cfg.publicaccess)
			{
				if ((tmpu=get_user(getnick(orig),&users))!=NULL)
				{
					send_to_server("NOTICE %s :\001IDENT Exsqueeze me? Baking powder? Do I know you?\001\n",getnick(orig));
					return;
				}
				if ((tmpu=add_user(getnick(orig),&users))==NULL)
				{
					send_to_server("NOTICE %s :\001IDENT Sorry, unable to register you as a new user.\001\n",getnick(orig));
					return;
				}
				strncpy(pw,strtok(args," "),8);
				setpasswd(getnick(orig),strtok(args," "),&users);
				u=strtok(getuserhost(orig),"@");
				if (*u=='^') u++;
				else if (*u=='~') u++;
				else if (*u=='+') u++;
				else if (*u=='=') u++;
				else if (*u=='-') u++;
				h=create_hostmask(strtok(NULL,"@"));
				sprintf(mask,"%s@%s",u,h);
				add_userhost(getnick(orig),mask,&users);
				send_to_server("NOTICE %s :Hi there! You have just been added to my userlist\n",getnick(orig));
				send_to_server("NOTICE %s :with the hostmask \002%s\002. To connect you must\n",getnick(orig),mask);
				send_to_server("NOTICE %s :always use your current nick, issue the command\n",getnick(orig));
				send_to_server("NOTICE %s :'/CTCP %s AUTH \002%s\002', and use the chat to play.\n",getnick(orig),cfg.nick,pw);
				send_to_server("NOTICE %s :\002%s\002 is your password, and it can be changed later.\n",getnick(orig),pw);
				printf("Sent notice...\n");
			}
			else
			{
				send_to_server("NOTICE %s :\001IDENT Exsqueeze me? Baking powder? Do I know you?\001\n",getnick(orig));
			}
		}
	}
	else
	if (!strcasecmp(cmd,"AUTH"))
	{
		for (tmp=args;(*tmp!=' ')&&(*tmp!='\0');tmp++);
		if (*tmp==' ') *tmp='\0';
		if (authenticate(getnick(orig),getuserhost(orig),args,&users)==0)
		{
			if ((ctcperr=add_chat(getnick(orig),&chatlist))==0)
			{
				send_to_server("NOTICE %s :\001AUTH Access granted!\001\n",getnick(orig));
			}
			else
			switch (ctcperr)
			{
			/* We have quite extensive error handling... */
			case 3:
				send_to_server("NOTICE %s :\001AUTH Sorry, only one chat allowed.\001\n",getnick(orig));
				break;
			case 4:
			case 5:
			case 6:
			case 7:
				send_to_server("NOTICE %s :\001AUTH Sorry, could not set up chat connection.\001\n",getnick(orig));
				break;
			case 8:
			case 9:
				send_to_server("NOTICE %s :\001AUTH Sorry, unable to set up child communication channel.\001\n",getnick(orig));
				break;
			case 10:
				send_to_server("NOTICE %s :\001AUTH Sorry, could not spawn child process.\001\n",getnick(orig));
				break;
			default:
				send_to_server("NOTICE %s :\001AUTH Sorry, cannot fullfill your wishes.\001\n",getnick(orig));
			}
		}
		else
		{
			send_to_server("NOTICE %s :\001AUTH Access denied.\001\n",getnick(orig));
		}			
	}
	else
	{
		send_to_server("NOTICE %s :\001ERRMSG Unknown CTCP query \"%s\"\001\n",getnick(orig),cmd);
	}
}

/* Function: Parses a CTCP_REPLY from a client. */
void parse_ctcp_reply(char *orig, char *args)
{
	/* We do not act on CTCP_REPLY, it could cause loops. */
	/* JanBot does not produce any CTCP requests apart from */
	/* DCC SEND and DCC CHAT, thus it's safe to assume that */
	/* any CTCP replies are fake (as SEND and CHAT should not */
	/* be replied to other than with a connection). */
	DEBUG2("CTCP_REPLY from %s: %s\n",getnick(orig),args);
	log(CTCP,"CTCP_REPLY from %s: ",orig,args);
}

/* Function: Parses a MSG from a client. */
void parse_privmsg(char *orig, char *args)
{
	/* This bot does not like to be msg'ed. Maybe we'll just recite */
	/* some poetry or something, to annoy the sender of the msg. */
	DEBUG2("PRIVMSG from %s received: %s\n",getnick(orig),args);
	log(MSG,"PRIVMSG from %s: %s",orig,args);
}

/* Function: Parses a NOTICE from a client. */
void parse_notice(char *orig, char *args)
{
	/* We do not act on NOTICE, it could cause loops. */
	DEBUG2("NOTICE from %s received: %s\n",getnick(orig),args);
	log(MSG,"NOTICE from %s: %s",orig,args);
}

/* Function: Parses and executes a command from a user. */
void parse_command(struct chat_t *tmp,char *buffer)
{
	int index;
	char *cmd=buffer,*args;

	/* Reset idle time... */
	tmp->itime=tmp->stime=time(NULL);

	/* Log this command... */
	log(CMD,"<%s> %s",tmp->chatter->nick,buffer);

	for (;*cmd==' ';cmd++);
	for (args=cmd;(*args!='\0')&&(*args!='\n');args++);
	if (*args=='\n') *args='\0';
	for (args=cmd;(*args!=' ')&&(*args!='\0');args++);
	if (*args==' ') *args++='\0';
	for (index=0;(cmdlist[index].name!=NULL)&&(strcasecmp(cmdlist[index].name,cmd));index++);
	if (cmdlist[index].name!=NULL)
	{
		if (cmdlist[index].level>tmp->chatter->level)
		{
			tell_user(tmp,toolow());
		}
		else
		{
			cmdlist[index].func(tmp,args);
		}
	}
	else
	{
		/* Some gimpy answer will be returned here. */
		tell_user(tmp,toolow());
	}
}

