
/* Try to determine what system we're on. */

#if defined(linux)
# ifndef _LINUX_
#  define _LINUX_
# endif
#elif defined(sun)||defined(sparc)
# ifndef _SOLARIS_
#  define _SOLARIS_
# endif
#elif defined(__FreeBSD__)||defined(bsdi)
# ifndef _BSD_
#  define _BSD_
# endif
#elif defined(_AIX)||defined(_AIX32)
# ifndef _AIX_
#  define _AIX_
# endif
#elif defined(hpux)||defined(hppa)
# error JanBot does not yet work on HPUX.
# ifndef _HPUX_
#  define _HPUX_
# endif
#endif


#include <config.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <fcntl.h>
#include <netinet/in.h>
#if !defined(ntohl)&&defined(_LINUX_)
# include <asm/byteorder.h>
#endif
#include <arpa/inet.h>
#include <time.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>

#ifdef _SOLARIS_
# include <crypt.h>
# define bcopy(s, d, n) memcpy ((d), (s), (n))
# define bzero(s, n) memset ((s), 0, (n))
#else
# include <strings.h>
#endif

#include <ctype.h>
#include <stdlib.h>
#include <pwd.h>
#include <dirent.h>
#include <stdarg.h>
#ifdef _BSD_
# ifdef USE_REGEX
#  include <regexp.h>
# endif
# include <sys/ioctl.h>
#else
# ifdef USE_REGEX
#  include <regex.h>
# endif
#endif

/* The current version of the bot. Don't change this. */
#define BOTVERSION "JanBot v3.07d"

/* The standard buffer size in the irc client. It's a good value to use. */
#define BIG_BUFFER_SIZE 2048
/* This is defines the default buffer size for the hyperdcc technology. */
#define DCC_BLOCK_SIZE 4096

/* Standard message size */
#define MSG_LEN 512

/* Length of an IPC message. */
#define IPC_MSG_LEN 256
#define IPC_TXT_LEN IPC_MSG_LEN-sizeof(int)-1

/* All these defines are confusing... :D */
#ifndef NAME_MAX
# ifdef MAXNAMLEN
#  define NAME_MAX MAXNAMLEN
# else
#  define NAME_MAX 256
# endif
#endif

#ifndef OPEN_MAX 
# ifdef _NFILE
#  define OPEN_MAX _NFILE
# else
#  define OPEN_MAX getdtablesize()
# endif
#endif

#ifndef INADDR_NONE
# define INADDR_NONE ((unsigned long int) 0xffffffff)
#endif

/* These are process name postfixes. */
#define DCC_CHAT_CHILD " (user process)"
#define MIRROR_SERVER_CHILD " (mirror server)"
#define MIRROR_CLIENT_CHILD " (mirror client)"
#define USERLIST_CHILD " (storing userlist)"



/* Userlist related stuff */

struct user_t
{
	char nick[NICK_LEN+1];
	char passwd[14]; /* This passwd string is stored encrypted. */
	struct userhost_t *userhost;
	int level,dcclimit;
	char dir[USERDIR_LEN+1];

	/* These are related to the ratio system. */
	int flags; /* Contains the users personal settings. */
	int ratio; /* Upload/Download ratio. */
	unsigned long long ul; /* Bytes uploaded. */
	unsigned long long dl; /* Bytes downloaded. */
	unsigned long long cr; /* Credit amount. */

	/* Next user in list. */
	struct user_t *next;
};

struct userhost_t
{
	char uh[USERHOST_LEN+1];
	struct userhost_t *next;
};

/* The user config flags. There will be more flags later. */
#define F_AUTO 0x0001	/* Automatical DCC SEND/GET if set. */
#define F_SORT 0x0002	/* Sort alphabetically if cleared, by date if set */ 
#define F_MOTD 0x0004	/* Toggle display of Message Of The Day */
#define F_RSUM 0x0008	/* Send DCC RESUME request if file exists. */
#define F_TAR  0x0010	/* Toggle TAR sending on/off. */

#define F_NONE 0x0000 /* No flags */
#define F_ALL  F_AUTO|F_SORT|F_MOTD|F_RSUM|F_TAR /* All flags. */

/* Server related stuff */

struct server_t
{
	char name[SERVER_LEN+1];
	unsigned int port;
	struct server_t *next;
};

struct servconn_t
{
	time_t lastrecv;
	time_t lastping;
	int servfd;
	struct sockaddr_in serv_addr;
};

/* DCC CHAT related stuff */

struct chat_t
{
	struct user_t *chatter;
	int active;
	int oldsockfd,sockfd,clilen;
	unsigned int port;
	int ipc[2];
	int childpid;
	int filenum,queued;
	time_t stime,itime;
	struct sockaddr_in srv_addr,cli_addr;
	struct chat_t *next;
};

struct childmsg_t
{
	int type;
	char msg[IPC_TXT_LEN];
};

/* These are the message names for the parent-child communication. */
/* They are used by both entities, but their meaning differs. */


#define ERROR	0	/* Should be pretty obvious */
#define LIST	1	/* Makes the child list all open/waiting dccs */
#define SEND	2	/* Parent: Send this file, Child: this file sent. */
#define TAR	4	/* Send this tarfile. */
#define GET	3	/* Parent: Get this file, Child: this file gotten. (?) */
#define KILL	5	/* Kill a dcc by number or ALL */
#define QLIST	6	/* List files in queue. */
#define QKILL	7	/* Dequeues a dcc by number or ALL */
#define AUTO	8	/* Sets autodcc & resume on/off. */
#define NEXT	9	/* Send next file in DCC queue. */
#define NUM	10	/* From Child to Parent, reporting number of DCCs, */
			/* from Parent to Child, setting DCC limit. */
#define RESUME	11	/* Incoming resume request. */
#define RESREQ	12	/* Outgoing resume request. */

#ifdef USE_RATIOS
# define RATIO	13	/* For the ratio system. */
#endif

/* DCC types */
#define D_SEND		0x01 /* Send file. */
#define D_GET		0x02 /* Get file. */
#define D_TAR		0x04 /* For sending tar files generated on-the-fly. */
#define D_RESUME	0x08 /* Not needed for anything but DCC GET. */

struct dcc_t
{
	char fname[NAME_MAX+1]; /* Not always the real filename. */
	int filefd,sockfd,tmpfd; /* File descriptor, Socket descriptors. */
	FILE *tarfile; /* Pipe to tar command. */
	int type; /* Get, Send, TarSend or Resume, I recon... */
	int active; /* Waiting or Active */
	time_t stime; /* Start time */
	int port,clilen; /* These are SEND related. */
	struct sockaddr_in srv_addr,cli_addr; /* For SEND we need both */
	unsigned long total,transmit; /* Total file size, bytes transmitted. */
	unsigned long resume; /* Total size of resumed file. */
	int remains; /* Amount of data left in buf[]. */
	int bsize; /* DCC Block Size for this particular connection. */
	char *buf; /* It's big, but required. */
	struct dcc_t *next;
};

/* This is a list of DCCs to be exterminated. */
struct deathrow_t
{
	struct dcc_t *convict;
	struct deathrow_t *next;
};

/* This is for the DCC queue system. */
struct dccqueue_t
{
	int type;
	char info[NAME_MAX+1]; /* Hope this is enough. */
	struct dccqueue_t *next;
};

/* This list is for sorting directory entries. */
struct dirlist_t
{
	char name[NAME_MAX+1];
	struct stat sbuf;
	struct dirlist_t *next;
};


/* Command related stuff */
struct cmd_t
{
	char *name;
	void (*func)();
	int level; /* Required access level. */
};	


/* This is some oddstuff for the user add command. */
struct uhost_query
{
	char nick[NICK_LEN+1];
	struct user_t *caller;
};

/* Configuration container */
struct cfg_t
{
 	char configfile[NAME_MAX+1];
 
        int reconnect;
	int walking;
	int overwrite;
	int publicaccess;
	int tightarsedsecurity;

	unsigned long loglevel;
	char nick[NICK_LEN+1];
	char userinfo[USERINFO_LEN+1];

	char bothome[NAME_MAX+1];
	char filedir[NAME_MAX+1];

	char userfile[NAME_MAX+1];
	char logfile[NAME_MAX+1];
	char helpfile[NAME_MAX+1];
	char motdfile[NAME_MAX+1];
	char tarpath[NAME_MAX+1];

	struct server_t *servlist;

	int dcctimeout;
	int chattimeout;
	int pingtimeout;
	int dcclimit;
	int scheduledwrite;
	int defaultflags;
	int dccblocksize;
	int defaultratio;
};

struct cfgfunc_t
{
	char *tag;
	int (*func)();
};


/* Log related stuff */
#define NONE	0x00
#define CMD	0x01
#define SERV	0x02
#define DCC	0x04
#define CTCP	0x08
#define SIG	0x10
#define MSG	0x20
#define CRAP	0x40
#define ALL CMD|SERV|DCC|CTCP|SIG|MSG|CRAP


/* Generic string container list */
struct list_t
{
	char str[NAME_MAX+1];
	struct list_t *next;
};

/* Generic file container list */
struct file_t
{
	time_t date;
	unsigned long size;
	char name[NAME_MAX+1];
	char path[NAME_MAX+1];
	struct file_t *next;
};

/* Function prototypes */

#if defined(sparc)||defined(sun)
extern int gethostname(char *name, size_t len);
#endif

/* chat.c */
extern int		add_chat();
extern struct chat_t	*find_chat();
extern void		kill_chat();
extern void		check_chat();
extern void		tell_user(struct chat_t *,char *,...);
extern void		send_to_child(struct chat_t *,int,char *,...);
extern void		parse_child_message();
extern void		display_stuff();
#ifdef USE_RATIOS
extern void		parse_child_ratio();
#endif

/* child.c */
extern void		init_child();
extern int		process_child();
extern void		kill_child();
extern void		parse_parent_message();
extern void		send_to_parent(int,char *,...);
#ifdef DEBUG
extern void		child_signal_handler();
#endif /* DEBUG */
#ifdef USE_RATIOS
extern void		parse_parent_ratio();
#endif

/* commands.c */
extern void		cmd_add();
#ifdef USE_RATIOS
extern void		cmd_adjust();
#endif
extern void		cmd_cd();
extern void		cmd_cutcon();
extern void		cmd_del();
extern void		cmd_dir();
#ifdef USE_RATIOS
extern void		cmd_donate();
#endif
extern void		cmd_help();
extern void		cmd_hint();
extern void		cmd_killdcc();
extern void		cmd_killq();
extern void		cmd_limit();
extern void		cmd_mkdir();
extern void		cmd_next();
extern void		cmd_passwd();
#ifdef USE_RATIOS
extern void		cmd_ratio();
#endif
extern void		cmd_rehash();
extern void		cmd_relevel();
extern void		cmd_retire();
extern void		cmd_send();
extern void		cmd_server();
extern void		cmd_set();
extern void		cmd_setpass();
extern void		cmd_showdcc();
extern void		cmd_showq();
extern void		cmd_status();
#ifdef DEBUG
extern void		cmd_test(); /* Only for test purposes. */
#endif
extern void		cmd_users();
extern void		cmd_who();
extern void		cmd_whoami();

/* config.c */
extern void		init_config();
extern int		read_configfile();
extern int		parse_config_line();
extern char		*expand_tilde();
extern int		cfg_nick();
extern int		cfg_userinfo();
extern int		cfg_server();
extern int		cfg_bothome();
extern int		cfg_filedir();
extern int		cfg_userfile();
extern int		cfg_logfile();
extern int		cfg_helpfile();
extern int		cfg_motdfile();
extern int		cfg_tarpath();
extern int		cfg_reconnect();
extern int		cfg_serverwalking();
extern int		cfg_overwrite();
extern int		cfg_tightarsedsecurity();
extern int		cfg_publicaccess();
extern int		cfg_loglevel();
extern int		cfg_dcctimeout();
extern int		cfg_chattimeout();
extern int		cfg_pingtimeout();
extern int		cfg_dcclimit();
extern int		cfg_dccblocksize();
extern int		cfg_scheduledwrite();
extern int		cfg_defaultflags();
#ifdef USE_RATIOS
extern int		cfg_defaultratio();
#endif /* USE_RATIOS */

/* dcc.c */
extern void		incoming_dcc();
extern void		open_incoming_file();
extern void		process_outgoing_file();
extern void		process_incoming_file();
extern int		dcc_count();
extern int		queue_count();
extern void		put_on_deathrow();
extern void		clear_deathrow();
extern void		check_dcc();
extern void		process_dccget();
extern void		process_dccsend();
extern void		send_dcc_offer();
extern void		check_dcc_timeout();
extern void		put_on_dccqueue();
extern void		check_dccqueue();
extern void		show_dcc_list();
extern int		dcc_exists();
extern int		is_in_queue();
extern void		show_dcc_queue();
extern void		remove_dcc();
extern void		remove_queued();
extern void		process_next();
extern void		parse_resume_request();
extern void		process_resume();

/* janbot.c */
extern int		do_bot_things();
extern void		show_cli_help();
extern void		signal_handler();
extern void		sighup_handler();

/* match.c */
#ifndef USE_REGEX
# define regex_match wild_match
# define regex_match_file wild_match_file
extern int		wild_match();
extern int		wild_match_file(); 
#endif

/* parser.c */
extern int		read_server_line();
extern int		parse_server_line();
extern void		parse_server_message();
extern void		parse_client_message();
extern void		parse_ctcp();
extern void		parse_ctcp_reply();
extern void		parse_privmsg();
extern void		parse_notice();
extern void		parse_command();

/* server.c */
extern int		server_connect();
extern int		server_init();
extern struct server_t	*next_server();
extern void		add_server();
extern char 		*del_server();
extern void		send_to_server(char *,...);

/* stuff.c */
extern void		ms_delay();
extern char		*getnick();
extern char		*getuserhost();
extern char		*toolow();
extern char		*base_name();
extern char		*mode2str();
extern struct dirlist_t *create_dirlist();
extern struct file_t	*create_reclist();
extern char		*convert_date();
extern char		*convert_idle();
extern char		*convert_uptime();
extern int		check_dir();
extern char		*create_hostmask();
extern void		showhelp();
extern int		read_line();
extern void		log(unsigned long,char *,...);
extern unsigned int	next_port();
extern int		dirlist_compare();
extern unsigned long	calculate_tarsize();
#ifdef USE_REGEX
# define regex_match_file regex_match
extern int		regex_match();
#endif
extern char		*gethomepath();
extern int		isvalidnick();
extern int		readytoread();
extern void		purify_path();
extern void		*mymalloc();
#ifdef DEBUG
extern void		new_function_level();
extern void		old_function_level();
#endif

/* userlist.c */
extern struct user_t 	*add_user();
extern struct user_t 	*get_user();
extern void 		free_users();
extern void 		del_user();
extern int		initusers();
extern int		read_users();
extern void		write_users();
extern void 		write_scheduled();
extern void		add_userhost();
extern void		del_userhost();
extern int		userhost_count();
extern int		authenticate();
extern int		setpasswd();
extern int		chkpasswd();
extern int		setlevel();
extern int		setlimit();
extern void		parse_userhost_reply();
extern void		enter_new_user();


/* GLOBALS VARIABLES */

extern struct user_t *users;

extern struct server_t *current_server;
extern struct servconn_t sconn;
extern struct servmsg_t *msgqueue;

extern struct chat_t *chatlist;

extern struct cfg_t cfg;

extern time_t bot_uptime;

extern int background;

/* These are for the child processes */
extern struct dcc_t *dcclist;
extern struct deathrow_t *deathrow;
extern struct dccqueue_t *dccqueue;
extern int userfd;
extern int logfd;
extern int parent;
extern int dcclimit;
extern int autodcc;
extern int resume;

#ifdef DEBUG
extern int traceflag;
extern int function_level;
#endif

extern struct in_addr hostaddr;
extern char hostname[256];
extern unsigned long local_ip;
extern struct hostent *local_hp;

extern struct cmd_t cmdlist[];

extern char *toolowlist[];

/* Might get extended to a table or list in the future. */
extern struct uhost_query uhquery;


/* For publishing the argument list. */
extern int p_argc;
extern char **p_argv;


#ifdef USE_RATIOS
extern int ratio;
extern unsigned long long ul;
extern unsigned long long dl;
extern unsigned long long cred;
#endif


/* Some debugging stuff */

#ifdef DEBUG

#define DEBUG0(txt) if (traceflag) { printf(txt); }
#define DEBUG1(txt,arg1) if (traceflag) { printf(txt,arg1); }
#define DEBUG2(txt,arg1,arg2) if (traceflag) { printf(txt,arg1,arg2); }
#define DEBUG3(txt,arg1,arg2,arg3) if (traceflag) { printf(txt,arg1,arg2,arg3); }

#define ENTER0(lvl,txt) if (traceflag>lvl) { new_function_level(); printf(txt); }
#define ENTER1(lvl,txt,arg1) if (traceflag>lvl) { new_function_level(); printf(txt,arg1); }
#define ENTER2(lvl,txt,arg1,arg2) if (traceflag>lvl) { new_function_level(); printf(txt,arg1,arg2); }
#define ENTER3(lvl,txt,arg1,arg2,arg3) if (traceflag>lvl) { new_function_level(); printf(txt,arg1,arg2,arg3); }

#define LEAVE(lvl) if (traceflag>lvl) old_function_level()

#else

#define DEBUG0(txt)
#define DEBUG1(txt,arg1)
#define DEBUG2(txt,arg1,arg2)
#define DEBUG3(txt,arg1,arg2,arg3)

#define ENTER0(lvl,txt)
#define ENTER1(lvl,txt,arg1)
#define ENTER2(lvl,txt,arg1,arg2)
#define ENTER3(lvl,txt,arg1,arg2,arg3)

#define LEAVE(lvl)

#endif


