#include <config.h>
#include <janbot.h>

/* Function: Adds a new user, or adds a hostmask to an existing user. */
void cmd_add(struct chat_t *usr,char *args)
{
	char *tmp,*p;
	struct user_t *target;

	for (tmp=args;(*tmp!='\0')&&(*tmp!=' ');tmp++);
	
	for (p=tmp;(*p==' ')&&(*p!='\0');p++);
	if (*p=='\0') *tmp='\0';

	if (*tmp!='\0')
	{
		*tmp++='\0';
		while (*tmp==' ') tmp++;
		for (p=tmp;(*p!=' ')&&(*p!='\0');p++);
		if (*p!='\0') *p='\0';

		if ((target=get_user(args,&users))==NULL)
		{
			if ((target=add_user(args,&users))!=NULL)
			{
				add_userhost(args,tmp,&users);
				tell_user(usr,"Added new user \002%s\002 with hostmask \002%s\002.\n",target->nick,tmp);
			}
			else
			{
				tell_user(usr,"Unable to add user \002%s\002.\n",args);
			}
		}
		else
		{
			add_userhost(args,tmp,&users);
			tell_user(usr,"Added hostmask \002%s\002 to user \002%s\002.\n",tmp,target->nick);
		}
	}
	else
	{
		/* This is a nasty workaround for the USERHOST call. */
		strncpy(uhquery.nick,args,NICK_LEN+1);
		uhquery.caller=usr->chatter;
		send_to_server("USERHOST %s\n",args);
		/* Actually, this is all we do. Now we just have to wait */
		/* for a server reply to this thing. It'll be handled later. */
	}
}

/* Function: Adjusts Upload/Download/Credit amounts for a user. */
#ifdef USE_RATIOS
void cmd_adjust(struct chat_t *usr,char *args)
{
	char *i,*j,*k;
	struct user_t *u;
	struct chat_t *c;
	unsigned long long t;

	if ((i=strtok(args," "))==NULL||(j=strtok(NULL," "))==NULL||(k=strtok(NULL," "))==NULL)
	{
		tell_user(usr,"Usage: \002ADJUST\002 <user> UL|DL|CRED <amount>\n");
		return;
	}
	if ((u=get_user(i,&users))==NULL)
	{
		tell_user(usr,"Cannot find user \002%s\002 in my records.\n");
		return;
	}
	sscanf(k,"%llu",&t);
	t*=1024;
	if (!strcasecmp(j,"UL")) u->ul=t;
	else if (!strcasecmp(j,"DL")) u->dl=t;
	else if (!strcasecmp(j,"CRED")) u->cr=t;
	else
	{
		tell_user(usr,"Valid types are \002UL\002, \002DL\002 and \002CRED\002.\n");
		return;
	}
	if ((c=find_chat(u->nick,&chatlist))!=NULL)
	{
		send_to_child(c,RATIO,"%s %llu",j,t);
	}
	tell_user(usr,"\002%s\002's UL/DL/CRED values are now: \002%lluK/%lluK/%lluK\002.\n",u->nick,u->ul/1024,u->dl/1024,u->cr/1024);
}
#endif

/* Function: Displays or changes a users current directory. */
void cmd_cd(struct chat_t *usr,char *args)
{
	char *token;
	char newdir[256],fullpath[256];
	int argno=0;
	int index;
	DIR *thedir;
	struct dirlist_t *dl,*p;
	
	if (strlen(args)==0)
	{
		tell_user(usr,"Current directory: \002%s\002\n",usr->chatter->dir);
		return;
	}
	strcpy(newdir,usr->chatter->dir);
	index=strlen(newdir);
	if (*args=='/')
	{
		*newdir='\0';
		args++;
	}	
	do
	{
		if (argno++==0)
		{
			token=strtok(args,"/");
		}
		else
		{
			token=strtok(NULL,"/");
		}
		if (token!=NULL)
		{
			if (strcmp(token,".")!=0)
			{
				if (strcmp(token,"..")==0)
				{
					/* Rewind */
					if (index>1)
					{
						for (;newdir[index]!='/';--index);
						newdir[index]='\0';
					}
				}
				else
				{
					strcpy(fullpath,cfg.filedir);
					strcat(fullpath,newdir);
					/* purify_path(fullpath); */
					if ((thedir=opendir(fullpath))!=NULL)
					{
						if ((dl=create_dirlist(thedir))!=NULL)
						{
							for (p=dl;(p!=NULL)&&(!regex_match_file(token,p->name));p=p->next);
							if (p!=NULL)
							{
								if (newdir[index-1]!='/')
								{
									strcat(newdir,"/");
								}
								strcat(newdir,p->name);
								index=strlen(newdir);
							}
							else
							{
								tell_user(usr,"No such directory.\n");
								create_dirlist(NULL);
								closedir(thedir);
								return;
							}
							create_dirlist(NULL);
						}
						else
						{
							tell_user(usr,"No such directory.\n");
							closedir(thedir);
							return;
						}
						closedir(thedir);
					}
					else
					{
						tell_user(usr,"No such directory.\n");
						return;
					}
				}				
			}
		}
	}
	while(token!=NULL);

	if (strlen(newdir)==0)
	{
		strcpy(newdir,"/");
	}
	strcpy(fullpath,cfg.filedir);
	strcat(fullpath,newdir);

	if ((thedir=opendir(fullpath))==NULL)
	{
		tell_user(usr,"No such directory.\n");
	}
	else
	{
		closedir(thedir);
		purify_path(newdir);
		strcpy(usr->chatter->dir,newdir);
		tell_user(usr,"Current directory: \002%s\002\n",newdir);
	}
}


/* Function: Terminates a users connection. */
void cmd_cutcon(struct chat_t *usr,char *args)
{
	struct chat_t *c;
	struct user_t *u;
	char *n;
	
	if ((n=strtok(args," "))!=NULL)
	{
		if ((u=get_user(n,&users))!=NULL)
		{
			if ((c=find_chat(u,&chatlist))!=NULL)
			{
				if (c==usr)
				{
					tell_user(usr,"Whatever you say, boss.\n");
				}
				else
				{
					tell_user(c,"I have been instructed to terminate this connection. Bye!\n");
					tell_user(usr,"Terminating connection to \002%s\002.\n",u->nick);
				}
				kill_chat(c,&chatlist);
			}
			else
			{
				tell_user(usr,"\002%s\002 is not connected.\n",u->nick);
			}
		}
		else
		{
			tell_user(usr,"Cannot find \002%s\002 in my records.\n",n);
		}
	}
	else
	{
		tell_user(usr,"Usage: \002CUTCON\002 <user>\n");
	}
}			


/* Function: Deletes a user, or deletes a hostmask from user. */
void cmd_del(struct chat_t *usr,char *args)
{
	struct user_t *tmp;
	struct userhost_t *p;
	struct chat_t *c;
	char *u,*h;
	int hn,idx;
	
	if ((u=strtok(args," "))==NULL)
	{
		tell_user(usr,"Usage: \002DEL\002 <user> [hostnum]\n");
	}
	else if ((h=strtok(NULL," "))==NULL)
	{
		if ((tmp=get_user(u,&users))==NULL)
		{
			tell_user(usr,"Cannot find user \002%s\002 in my records.\n",u);
		}
		else
		if (usr->chatter==tmp)
		{
			tell_user(usr,"You cannot delete yourself!\n");
		}
		else
		{
			if ((c=find_chat(tmp->nick,&chatlist))!=NULL)
			{
				tell_user(c,"Sorry, your user has been deleted. Terminating connection.\n");
				kill_chat(c,&chatlist);
				tell_user(usr,"User \002%s\002 has been deleted, and connection terminated.\n",tmp->nick);
			}
			else
			{
				tell_user(usr,"User \002%s\002 has been deleted.\n",tmp->nick);
			}
			del_user(tmp->nick,&users);
		}
	}
	else
	{
		if ((tmp=get_user(u,&users))==NULL)
		{
			tell_user(usr,"Cannot find user \002%s\002 in my records.\n",u);
		}
		else
		if (sscanf(h,"%d",&hn)==0)
		{
			tell_user(usr,"Usage: \002DEL\002 <user> [hostnum]\n");
		}
		else
		if ((hn<1)||(hn>userhost_count(tmp->userhost)))
		{
			tell_user(usr,"Unable to delete hostmask number \002%d\002 from user \002%s\002.\n",hn,tmp->nick);
		}
		else
		{
			for(p=tmp->userhost,idx=1;idx<hn;p=p->next,idx++);
			tell_user(usr,"Deleted hostmask \002%s\002 from user \002%s\002.\n",p->uh,tmp->nick);
			del_userhost(tmp->nick,hn-1,&users);
		}
	}
}

/* Function: Displays long listing of current directory. */
void cmd_dir(struct chat_t *usr,char *args)
{
	DIR *thedir;
	char cwdir[256],file[256];
	struct dirlist_t *dlist,*p,**dsort;
	int dcount,idx;
	
	strcpy(cwdir,cfg.filedir);
	strcat(cwdir,usr->chatter->dir);
	
	if ((thedir=opendir(cwdir))==NULL)
	{
		tell_user(usr,"Invalid directory: \002%s\002\n",usr->chatter->dir);
		return;
	}
	
	tell_user(usr,"Directory listing of: \002%s\002\n",usr->chatter->dir);
	
	if ((dlist=create_dirlist(thedir))==NULL)
	{
		tell_user(usr,"Directory is empty.\n");
		return;
	}

	for (p=dlist;p!=NULL;p=p->next)
	{
		strcpy(file,cwdir);
		strcat(file,"/");
		strcat(file,p->name);
		purify_path(file);
		stat(file,&p->sbuf);
	}

	if (usr->chatter->flags&F_SORT)
	{
		for (dcount=0,p=dlist;p!=NULL;p=p->next,dcount++);
		dsort=(struct dirlist_t **)malloc(sizeof(struct dirlist_t *)*dcount);
		for (idx=0,p=dlist;p!=NULL;idx++,p=p->next)
		{
			dsort[idx]=(struct dirlist_t *)malloc(sizeof(struct dirlist_t));
			bcopy(p,dsort[idx],sizeof(struct dirlist_t));
		}
		qsort(dsort,dcount,sizeof(struct dirlist_t *),dirlist_compare);
		for (idx=0;idx<dcount;idx++)
		{
			p=dsort[idx];
			tell_user(usr,"%s %10lu %s \002%s\002\n",mode2str(p->sbuf.st_mode),(unsigned long)p->sbuf.st_size,convert_date(p->sbuf.st_mtime),p->name);
			free(p);
		}
		free(dsort);
	}
	else
	{
		for (p=dlist;p!=NULL;p=p->next)		
		{
			tell_user(usr,"%s %10lu %s \002%s\002\n",mode2str(p->sbuf.st_mode),(unsigned long)p->sbuf.st_size,convert_date(p->sbuf.st_mtime),p->name);
		}
	}

	tell_user(usr,"End of list.\n");

	/* This is important to do, else the list will accumulate. */
	create_dirlist(NULL);
	closedir(thedir);
}	

/* Function: Donates credits to other users. */
#ifdef USE_RATIOS
void cmd_donate(struct chat_t *usr,char *args)
{
	char *i,*j;
	struct user_t *u;
	struct chat_t *c;
	unsigned long long cred;

	if ((i=strtok(args," "))==NULL||(j=strtok(NULL," "))==NULL)
	{
		tell_user(usr,"Usage: \002DONATE\002 <user> <credits>\n");
		return;
	}
	if (usr->chatter->ratio==0)
	{
		tell_user(usr,"Users with no ratio may not donate credits.\n");
		return;
	}
	if ((u=get_user(i,&users))==NULL)
	{
		tell_user(usr,"Cannot find user \002%s\002 in my records.\n");
		return;
	}
	sscanf(j,"%llu",&cred);
	if ((cred*1024)>usr->chatter->cr)
	{
		tell_user(usr,"You do not that much credits.\n");
		return;
	}
	u->cr+=cred*1024;
	usr->chatter->cr-=cred*1024;
	if ((c=find_chat(i,&chatlist)))
	{
		send_to_child(c,RATIO,"CRED %llu",u->cr);
	}
	tell_user(usr,"\002%lluK\002 credits has been donated to \002%s\002.\n",cred,u->nick);
}
#endif

/* Function: Displays help about commands. */
void cmd_help(struct chat_t *usr,char *args)
{
	char *h;
	int idx;
	
	if ((h=strtok(args," "))==NULL)
	{
		showhelp(usr,"HELP");
		return;
	}
	
	for (idx=0;(cmdlist[idx].name!=NULL)&&(strcasecmp(cmdlist[idx].name,h)!=0);idx++);
	if ((cmdlist[idx].name!=NULL)&&(cmdlist[idx].level<=usr->chatter->level))
	{
		showhelp(usr,cmdlist[idx].name);
	}
	else
	{
		tell_user(usr,"Help: No such command.\n");
	}
}

/* Function: Displays short command list. */
void cmd_hint(struct chat_t *usr,char *args)
{
	int idx,cnt;
	char cmd[20],buf[MSG_LEN+1];
	
	*buf='\0';
	tell_user(usr,"Short command index:\n");
	for (idx=0,cnt=0;cmdlist[idx].name!=NULL;idx++)
	{
		if ((usr->chatter->level)>=cmdlist[idx].level)
		{
			sprintf(cmd,"\002%-12s\002",cmdlist[idx].name);
			strcat(buf,cmd);
			if ((cnt++%4)==3) strcat(buf,"\n");
		}
	}
	tell_user(usr,"%s%s",buf,cnt%4?"\n":"");
	tell_user(usr,"End of list.\n");
}



/* Function: Remove an Active or Waiting DCC from user. */
void cmd_killdcc(struct chat_t *usr,char *args)
{
	char *arg1,*arg2;
	struct user_t *tmpusr;
	struct chat_t *tmpchat;

	if (usr->chatter->level<1)
	{
		if ((arg1=strtok(args," "))==NULL)
		{
			tell_user(usr,"Usage: \002KILLDCC\002 <#num||#all>\n");
		}
		else
		{
			if (*arg1!='#')
			{
				tell_user(usr,"Usage: \002KILLDCC\002 <#num||#all>\n");
			}
			else
			{
				send_to_child(usr,KILL,"%s %s",usr->chatter->nick,arg1);
			}
		}
	}
	else
	{
		if ((arg1=strtok(args," "))==NULL)
		{
			tell_user(usr,"Usage: \002KILLDCC\002 [user] <#num||#all>\n");
		}
		else
		{
			if ((arg2=strtok(NULL," "))==NULL)
			{
				if (*arg1!='#')
				{
					tell_user(usr,"Usage: \002KILLDCC\002 [user] <#num||#all>\n");
				}
				else
				{
					send_to_child(usr,KILL,"%s %s",usr->chatter->nick,arg1);
				}
			}
			else
			{
				if (*arg2!='#')
				{
					tell_user(usr,"Usage: \002KILLDCC\002 [user] <#num||#all>\n");
				}
				else
				{
					if ((tmpusr=get_user(arg1,&users))==NULL)
					{
						tell_user(usr,"Cannot find user \002%s\002 in my records.\n",arg1);
					}
					else
					{
						if ((tmpchat=find_chat(tmpusr->nick,&chatlist))!=NULL)
						{
							send_to_child(tmpchat,KILL,"%s %s",usr->chatter->nick,arg2);
						}
						else
						{
							tell_user(usr,"User \002%s\002 is not connected.\n",tmpusr->nick);
						}
					}
				}
			}
		}
	}
}




/* Function: Remove a queued DCC from user. */
void cmd_killq(struct chat_t *usr,char *args)
{
	char *arg1,*arg2;
	struct user_t *tmpusr;
	struct chat_t *tmpchat;

	if (usr->chatter->level<1)
	{
		if ((arg1=strtok(args," "))==NULL)
		{
			tell_user(usr,"Usage: \002KILLQ\002 <#num||#all>\n");
		}
		else
		{
			if (*arg1!='#')
			{
				tell_user(usr,"Usage: \002KILLQ\002 <#num||#all>\n");
			}
			else
			{
				send_to_child(usr,QKILL,"%s %s",usr->chatter->nick,arg1);
			}
		}
	}
	else
	{
		if ((arg1=strtok(args," "))==NULL)
		{
			tell_user(usr,"Usage: \002KILLQ\002 [user] <#num||#all>\n");
		}
		else
		{
			if ((arg2=strtok(NULL," "))==NULL)
			{
				if (*arg1!='#')
				{
					tell_user(usr,"Usage: \002KILLQ\002 [user] <#num||#all>\n");
				}
				else
				{
					send_to_child(usr,QKILL,"%s %s",usr->chatter->nick,arg1);
				}
			}
			else
			{
				if (*arg2!='#')
				{
					tell_user(usr,"Usage: \002KILLQ\002 [user] <#num||#all>\n");
				}
				else
				{
					if ((tmpusr=get_user(arg1,&users))==NULL)
					{
						tell_user(usr,"Cannot find user \002%s\002 in my records.\n",arg1);
					}
					else
					{
						if ((tmpchat=find_chat(tmpusr->nick,&chatlist))!=NULL)
						{
							send_to_child(tmpchat,QKILL,"%s %s",usr->chatter->nick,arg2);
						}
						else
						{
							tell_user(usr,"User \002%s\002 is not connected.\n",tmpusr->nick);
						}
					}
				}
			}
		}
	}
}


/* Function: Sets users DCC limit. */
void cmd_limit(struct chat_t *usr,char *args)
{
	int lim;
	char *l;
	
	if (((l=strtok(args," "))==NULL)||(sscanf(l,"%d",&lim)==0))
	{
		tell_user(usr,"Usage: \002LIMIT\002 <number>\n");
	}
	else
	{
		if (lim<1)
		{
			tell_user(usr,"A DCC limit of \002%d\002 wouldn't be smart.\n",lim);
		}
		else
		{
			if (setlimit(usr->chatter->nick,lim,&users)!=0)
			{
				tell_user(usr,"Unable to set DCC limit.\n");
			}
			else
			{
				send_to_child(usr,NUM,"%d",lim);
				tell_user(usr,"Your DCC limit has been set to \002%d\002.\n",lim);
			}
		}
	}
}

/* Function: Creates a new directory. */
void cmd_mkdir(struct chat_t *usr,char *args)
{
	char *dn,newdir[256];
	
	if ((dn=strtok(args," "))!=NULL)
	{
		strcpy(newdir,cfg.filedir);
		strcat(newdir,usr->chatter->dir);
		strcat(newdir,"/");
		strcat(newdir,args);
		if (mkdir(newdir,0777)!=0)
		{
			tell_user(usr,"Unable to create directory!\n");
		}
		else
		{
			tell_user(usr,"New directory created.\n");
		}
	}
	else
	{
		tell_user(usr,"Usage: \002MKDIR\002 <dirname>\n");
	}
}

/* Function: Makes the robot send more files from the DCC queue. */
void cmd_next(struct chat_t *usr,char *args)
{
	char *t;
	int count;
	
	if (usr->chatter->flags&F_AUTO)
	{
		tell_user(usr,"This command is disabled when \002AutoSend\002 is enabled.\n");
		return;
	}
	if ((t=strtok(args," "))==NULL)
	{
		count=1;
	}
	else if ((count=atoi(t))<1)
	{
		tell_user(usr,"Usage: \002NEXT\002 [number]\n");
		return;
	}
	send_to_child(usr,NEXT,"%d",count);
}

/* Function: Changes a users password. */
void cmd_passwd(struct chat_t *usr,char *args)
{
	if (strlen(args)==0)
	{
		tell_user(usr,"Usage: \002PASSWD\002 <password>\n");
	}
	else
	{
		setpasswd(usr->chatter->nick,strtok(args," "),&users);
		tell_user(usr,"Password has been changed.\n");
	}
}

/* Function: Changes someone's Upload/Download ratio. */
#ifdef USE_RATIOS
void cmd_ratio(struct chat_t *usr,char *args)
{
	struct user_t *tmp;
	struct chat_t *c;
	char *u,*l;
	int rat;
	
	if (((u=strtok(args," "))==NULL)||((l=strtok(NULL," "))==NULL))
	{
		tell_user(usr,"Usage: \002RATIO\002 <user> <ratio>\n");
	}
	else
	if (sscanf(l,"%d",&rat)==0)
	{
		tell_user(usr,"Usage: \002RATIO\002 <user> <ratio>\n");
	}
	else
	if ((tmp=get_user(u,&users))==NULL)
	{
		tell_user(usr,"Cannot find \002%s\002 in my records.\n",u);
	}
	else
	{
		tmp->ratio=rat;
		if ((c=find_chat(tmp->nick,&chatlist))!=NULL) send_to_child(c,RATIO,"RATIO %d",tmp->ratio);
		if (rat) tell_user(usr,"User \002%s\002 now has an Upload/Download ratio of 1:\002%d\002.\n",tmp->nick,tmp->ratio);
		else tell_user(usr,"User \002%s\002 now has no Upload/Download ratio.\n",tmp->nick);
	}
}
#endif

/* Function: Rereads the config file. */
void cmd_rehash(struct chat_t *usr,char *args)
{

	if (strtok(args," ")!=NULL)
	{
		tell_user(usr,"\002REHASH\002 takes no parameters.\n");
	}	
	else
	{
		tell_user(usr,"Rehashing config file...\n");
		init_config(NULL,usr);
		tell_user(usr,"Done rehashing.\n");
	}
}

/* Function: Changes someone's user level. */
void cmd_relevel(struct chat_t *usr,char *args)
{
	struct user_t *tmp;
	
	char *u,*l;
	int lvl;
	
	if (((u=strtok(args," "))==NULL)||((l=strtok(NULL," "))==NULL))
	{
		tell_user(usr,"Usage: \002RELEVEL\002 <user> <level>\n");
	}
	else
	if (sscanf(l,"%d",&lvl)==0)
	{
		tell_user(usr,"Usage: \002RELEVEL\002 <user> <level>\n");
	}
	else
	if ((tmp=get_user(u,&users))==NULL)
	{
		tell_user(usr,"Cannot find \002%s\002 in my records.\n",u);
	}
	else
	if (usr->chatter==tmp)
	{
		tell_user(usr,"You cannot relevel yourself!\n");
	}
	else
	if ((lvl>2)||(lvl<0))
	{
		tell_user(usr,"Level \002%d\002 is not a valid user level.\n",lvl);
	}
	else
	if (setlevel(tmp->nick,lvl,&users)!=0)
	{
		tell_user(usr,"Unable to relevel user \002%s\002.\n",tmp->nick);
	}
	else
	{
		tell_user(usr,"User \002%s\002 has been releveled to \002%d\002.\n",tmp->nick,tmp->level);
	}
	/* Whew, we reached the bottom... */
}



/* Function: Make the bot quit. */
void cmd_retire(struct chat_t *usr,char *args)
{
	struct chat_t *tmp;
	char boss[NICK_LEN+1];

	strcpy(boss,usr->chatter->nick);
	for (tmp=chatlist;tmp!=NULL;tmp=tmp->next)
	{
		if (usr==tmp)
		{
			tell_user(tmp,"Okay, committing suicide.\n");
		}
		else
		{
			tell_user(tmp,"I have been instructed by \002%s\002 to retire. Bye!\n",boss);
		}
		kill_chat(tmp,&chatlist);
	}
	DEBUG1("Shutdown initiated by %s.\n",boss);
	write_users(&users);
	free_users(&users);

	/* BOOM */
	log(ALL,"Exiting on request from %s.",boss);
	log(ALL,"***  LOG ENDED  ***");
	DEBUG0("Terminating.\n");
	exit(0);
}

/* Function: Sends all files matching filemask. */
void cmd_send(struct chat_t *usr,char *args)
{
	char *token,destination[NICK_LEN+1];
	int argno=0,matches;
	char newdir[NAME_MAX+1],newfile[NAME_MAX+1];
	DIR *thedir;
	struct dirlist_t *dlist,*p;
	struct file_t *l,*m;

	strncpy(destination,usr->chatter->nick,NICK_LEN);
	destination[NICK_LEN]='\0';
	strcpy(newdir,cfg.filedir);
	strcat(newdir,usr->chatter->dir);
	purify_path(newdir);

	if ((thedir=opendir(newdir))==NULL)
	{
		tell_user(usr,"Unable to find directory!\n");
		return;
	}
	
	if ((dlist=create_dirlist(thedir))==NULL)
	{
		tell_user(usr,"Directory is empty!\n");
		closedir(thedir);
		return;
	}
	
	for (p=dlist;p!=NULL;p=p->next)
	{
		sprintf(newfile,"%s/%s",newdir,p->name);
		stat(newfile,&p->sbuf);
	}

	do
	{
		matches=0;
		if (!argno)
		{
			token=strtok(args," ");
		}
		else
		{
			token=strtok(NULL," ");
		}
		argno++;
		if (token!=NULL)
		for (p=dlist;p!=NULL;p=p->next)
		{
			if (regex_match_file(token,p->name))
			{
				if (p->sbuf.st_mode&S_IFREG)
				{
					send_to_child(usr,SEND,"%s %s/%s",destination,newdir,p->name);
				}
				else if (p->sbuf.st_mode&S_IFDIR)
				{
					if (usr->chatter->flags&F_TAR)
					{
						send_to_child(usr,TAR,"%s %s/%s",destination,newdir,p->name);
					}
					else
					{
						sprintf(newfile,"%s/%s",newdir,p->name);
						if ((l=create_reclist(newfile))!=NULL)
						{
							for (m=l;l->next!=NULL;m=l,l=l->next,free(m))
							{
								send_to_child(usr,SEND,"%s %s",destination,l->name);
							}
						}
					}
				}
				matches++;
			}
			if (argno==1&&!matches&&isvalidnick(token))
			{
				strncpy(destination,token,NICK_LEN);
				destination[NICK_LEN]='\0';
			}
		}
	}
	while (token!=NULL);
	create_dirlist(NULL);
	closedir(thedir);
}

/* Function: List/Change/Add/Remove servers. */
void cmd_server(struct chat_t *usr,char *args)
{
	char *u,*p;
	struct server_t *tmp,*tmp2;
	int idx;
	
	if ((u=strtok(args," "))==NULL)
	{
		tell_user(usr,"Server list:\n");
		for (idx=1,tmp=cfg.servlist;tmp!=NULL;tmp=tmp->next,idx++)
		{
			if (tmp==current_server)
			{
				tell_user(usr,"%2d) %s %d (Current)\n",idx,tmp->name,tmp->port);
			}
			else
			{
				tell_user(usr,"%2d) %s %d\n",idx,tmp->name,tmp->port);
			}
		}
		tell_user(usr,"End of list.\n");
	}
	else if (*u=='-')
	{
		if ((idx=atoi(++u)))
		{
			/* Delete server number */
			tell_user(usr,del_server(idx));
			return;
		}
		else
		{
			tell_user(usr,"Sorry, \002%s\002 is not a valid server number.\n",u);
			return;
		}
	}
	else if (!strcmp(u,"0")||(idx=atoi(u)))
	{
		/* Switch to this server */
		if (idx==1)
		{
			tell_user(usr,"Switching to server \002%s:%d\002.\n",cfg.servlist->name,cfg.servlist->port);
			current_server=NULL;
			close(sconn.servfd);
		}
		else
		{
			for (--idx,tmp=cfg.servlist;(tmp->next!=NULL)&&(idx>0);tmp=tmp->next,--idx);
			if (!idx)
			{
				for (tmp2=cfg.servlist;(tmp2->next)!=tmp;tmp2=tmp2->next);
				tell_user(usr,"Switching to server \002%s:%d\002.\n",tmp->name,tmp->port);
				current_server=tmp2;
				close(sconn.servfd);
			}
			else
			{
				tell_user(usr,"Unable to switch server.\n");
			}
		}
		return;
	}
	else
	{
		/* Add this server */
		if ((p=strtok(NULL," "))!=NULL)
		{
			/* Use this port. */
			if ((idx=atoi(p))&&(idx<65536))
			{
				add_server(u,idx);
				tell_user(usr,"Added server \002%s:%d\002 to server list.\n",u,idx);
			}
			else
			{
				tell_user(usr,"Invalid port.\n");
			}
		}
		else
		{
			/* Use default port. */
			add_server(u,PORT);
			tell_user(usr,"Added server \002%s:%d\002 to server list.\n",u,PORT);
		}
	}
}

/* Function: Displays or sets user options. */
void cmd_set(struct chat_t *usr,char *args)
{
	char *c;
	struct user_t *u=usr->chatter;
	
	if ((c=strtok(args," "))==NULL)
	{
		tell_user(usr,"Settings for user \002%s\002:\n",u->nick);

		tell_user(usr,"  Autoactivate DCCs  [\002AUTO\002]: \002%s\002\n",(u->flags&F_AUTO)?"On":"Off");
		tell_user(usr,"  Sorting method     [\002SORT\002]: \002%s\002\n",(u->flags&F_SORT)?"Date":"Name");
		tell_user(usr,"  Message of the day [\002MOTD\002]: \002%s\002\n",(u->flags&F_MOTD)?"Shown":"Hidden");
		tell_user(usr,"  Autorequest RESUME [\002RSUM\002]: \002%s\002\n",(u->flags&F_RSUM)?"On":"Off");
		tell_user(usr,"  Autosend TAR files [\002 TAR\002]: \002%s\002\n",(u->flags&F_TAR)?"On":"Off");

		tell_user(usr,"End of settings.\n");		
	}
	else if (!strcasecmp(c,"AUTO"))
	{
		u->flags^=F_AUTO;
		tell_user(usr,"Automatic DCC activation is now %s.\n",(u->flags&F_AUTO)?"enabled":"disabled");
		send_to_child(usr,AUTO,"%d %d",u->flags&F_AUTO?1:0,u->flags&F_RSUM?1:0);
	}
	else if (!strcasecmp(c,"SORT"))
	{
		u->flags^=F_SORT;
		tell_user(usr,"Direcory listings are now sorted by %s.\n",(u->flags&F_SORT)?"date":"name");
	}
	else if (!strcasecmp(c,"MOTD"))
	{
		u->flags^=F_MOTD;
		tell_user(usr,"Message of the day is now %s.\n",(u->flags&F_MOTD)?"shown":"hidden");
	}
	else if (!strcasecmp(c,"RSUM"))
	{
		u->flags^=F_RSUM;
		tell_user(usr,"Automatic DCC RESUME request is now %s.\n",(u->flags&F_RSUM)?"enabled":"disabled");
		send_to_child(usr,AUTO,"%d %d",u->flags&F_AUTO?1:0,u->flags&F_RSUM?1:0);
	}
	else if (!strcasecmp(c,"TAR"))
	{
		u->flags^=F_TAR;
		tell_user(usr,"Autosending TAR files is now %s.\n",(u->flags&F_TAR)?"enabled":"disabled");
	}
	else
	{
		tell_user(usr,"Available flags: \002AUTO SORT MOTD RSUM TAR\002.\n");
	}		
}

/* Function: Set another user's password. */
void cmd_setpass(struct chat_t *usr,char *args)
{
	char *u,*p;
	struct user_t *tmp;

	if (((u=strtok(args," "))==NULL)||((p=strtok(NULL," "))==NULL))
	{
		tell_user(usr,"Usage: \002SETPASS\002 <user> <password>\n");
		return;
	}	
	else if ((tmp=get_user(u,&users))==NULL)
	{
		tell_user(usr,"Cannot find user \002%s\002 in my records.\n",u);
		return;
	}
	else
	{
		setpasswd(u,p,&users);
		tell_user(usr,"Password for user \002%s\002 has been changed.\n",tmp->nick);
	}
}

/* Function: Display DCC information for a user. */
void cmd_showdcc(struct chat_t *usr,char *args)
{
	char *tmp;
	struct user_t *tmpusr;
	struct chat_t *tmpchat;
	
	if (strlen(args)==0)
	{
		send_to_child(usr,LIST,"%s",usr->chatter->nick);
	}
	else
	{
		for (tmp=args;(*tmp!=' ')&&(*tmp!='\0');tmp++);
		if (*tmp==' ') *tmp='\0';
		if ((tmpusr=get_user(args,&users))!=NULL)
		{
			if ((tmpusr!=usr->chatter)&&(usr->chatter->level<1))
			{
				tell_user(usr,"With your current userlevel, that is impossible.\n");
			}
			else
			{
				if ((tmpchat=find_chat(tmpusr,&chatlist))!=NULL)
				{
					send_to_child(tmpchat,LIST,"%s",usr->chatter->nick);
				}
				else
				{
					tell_user(usr,"Sorry, \002%s\002 is not connected.\n",tmpusr->nick);
				}
			}
		}
		else
		{
			tell_user(usr,"Sorry, can't find user \002%s\002 in my records.\n",args);
		}
	}
}

/* Function: Display DCC Queue information for a user. */
void cmd_showq(struct chat_t *usr,char *args)
{
	char *tmp;
	struct user_t *tmpusr;
	struct chat_t *tmpchat;
	
	if (strlen(args)==0)
	{
		send_to_child(usr,QLIST,"%s",usr->chatter->nick);
	}
	else
	{
		for (tmp=args;(*tmp!=' ')&&(*tmp!='\0');tmp++);
		if (*tmp==' ') *tmp='\0';
		if ((tmpusr=get_user(args,&users))!=NULL)
		{
			if ((tmpusr!=usr->chatter)&&(usr->chatter->level<1))
			{
				tell_user(usr,"With your current userlevel, that is impossible.\n");
			}
			else
			{
				if ((tmpchat=find_chat(tmpusr,&chatlist))!=NULL)
				{
					send_to_child(tmpchat,QLIST,"%s",usr->chatter->nick);
				}
				else
				{
					tell_user(usr,"Sorry, \002%s\002 is not connected.\n",tmpusr->nick);
				}
			}
		}
		else
		{
			tell_user(usr,"Sorry, can't find user \002%s\002 in my records.\n",args);
		}
	}
}

/* Function: Displays some status information about the robot. */
void cmd_status(struct chat_t *usr,char *args)
{
	int cnt,cnt2;
	struct user_t *utmp;
	struct chat_t *ctmp;
	struct utsname ub;

	tell_user(usr,"Status information for \002%s\002:\n",cfg.nick);
	if (!uname(&ub))
		tell_user(usr,"  System:           \002%s %s\002\n",ub.sysname,ub.release);
	else
		tell_user(usr,"  System:           \002Unknown.\002\n");
	tell_user(usr,"  Uptime:           \002%s\002\n",convert_uptime(time(NULL)-bot_uptime));
	for (cnt=0,utmp=users;utmp!=NULL;utmp=utmp->next,cnt++);
	tell_user(usr,"  Registered users: \002%d\002\n",cnt);
	for (cnt=cnt2=0,ctmp=chatlist;ctmp!=NULL;ctmp=ctmp->next,cnt++) cnt2+=ctmp->filenum;
	tell_user(usr,"  Connected users:  \002%d\002\n",cnt);
	tell_user(usr,"  Total open DCCs:  \002%d\002\n",cnt2);
	if (current_server!=NULL) tell_user(usr,"  Current server:   \002%s:%d\002\n",current_server->name,current_server->port);
	tell_user(usr,"  Flags:            \002%s%s%s\002\n",cfg.reconnect?"Reconnect ":"",cfg.overwrite?"Overwrite ":"",cfg.walking?"ServerWalking ":"");
	tell_user(usr,"  DCC Timeout:      \002%d\002 min.\n",cfg.dcctimeout/60);
	tell_user(usr,"  Chat Timeout:     \002%d\002 min.\n",cfg.chattimeout/60);
	tell_user(usr,"  Def. DCC limit:   \002%d\002\n",cfg.dcclimit);
	tell_user(usr,"  DCC Block Size:   \002%d\002\n",cfg.dccblocksize);
#ifdef USE_RATIOS
	tell_user(usr,"  Def. UL/DL Ratio: \002%d\002\n",cfg.defaultratio);
#endif
	tell_user(usr,"End of report.\n");
}

/* Function: Test function for debugging/development purposes. */
#ifdef DEBUG
void cmd_test(struct chat_t *usr,char *args)
{
	struct file_t *p,*q;
	char dir[NAME_MAX+1];

	strcpy(dir,cfg.filedir);
	if ((p=create_reclist(dir))!=NULL)
	{
		for (q=p;q!=NULL;q=q->next)
		{
			tell_user(usr,"%lu %lu \002%s\002\n",q->date,q->size,q->name+strlen(cfg.filedir));
		}
		while (p!=NULL)
		{
			q=p->next;
			free(p);
			p=q;
		}
	}
	else
	{
		tell_user(usr,"No files found.\n");
	}
}
#endif

/* Function: Displays brief listing of users and their level. */
void cmd_users(struct chat_t *usr,char *args)
{
	struct user_t *p;
	int cnt;
	char str[30],buf[MSG_LEN+1];
	
	*buf='\0';
	tell_user(usr,"List of registered users:\n");
	for (p=users,cnt=0;p!=NULL;p=p->next)
	{
		sprintf(str,"\002%-9s\002 (\002%1d\002)   ",p->nick,p->level);
		strcat(buf,str);
		if ((cnt++%3)==2)
		{
			tell_user(usr,"%s\n",buf);
			*buf='\0';
		}
	}
	tell_user(usr,"%s%s",buf,cnt%3?"\n":"");
	tell_user(usr,"End of list.\n");
}

/* Function: Lists connected user, or info on specific user. */
void cmd_who(struct chat_t *usr,char *args)
{
	struct chat_t *tmp;
	char *n;
	struct user_t *u;
	struct chat_t *c;
	struct userhost_t *p;
	int index;
	
	if ((n=strtok(args," "))==NULL)
	{
		tell_user(usr,"User      Lvl  Idle      DCCs  Q'ed\n");
		for(tmp=chatlist;tmp!=NULL;tmp=tmp->next)
		{
			tell_user(usr,"\002%-9s\002 %3d  %s  %4d  %4d\n",tmp->chatter->nick,tmp->chatter->level,convert_idle(time(NULL)-(tmp->itime)),tmp->filenum,tmp->queued);
		}
		tell_user(usr,"End of list.\n");
	}
	else
	{
		if ((u=get_user(n,&users))!=NULL)
		{
			tell_user(usr,"User information for: \002%s\002\n",u->nick);
			tell_user(usr,"  Directory:  \002%s\002\n",u->dir);
			tell_user(usr,"  User level: \002%d\002\n",u->level);
			for (index=0,p=u->userhost;p!=NULL;index++,p=p->next)
			{
				if (!index)
				{
					tell_user(usr,"  Hostmasks:  %.2d: \002%s\002\n",index+1,p->uh);
				}
				else
				{
					tell_user(usr,"              %.2d: \002%s\002\n",index+1,p->uh);
				}
			}

			tell_user(usr,"  DCC limit:  \002%d\002\n",u->dcclimit);

			tell_user(usr,"  Flags:      \002%s%s%s%s\002\n",(u->flags&F_AUTO)?"AutoSend ":"",
				(u->flags&F_SORT)?"SortByDate ":"SortByName ",(u->flags&F_MOTD)?"ShowMOTD ":"",
				(u->flags&F_RSUM)?"AutoResume ":"");

#ifdef USE_RATIOS
			if (u->ratio) tell_user(usr,"  Ratio:      1:\002%d\002\n",u->ratio);
			else tell_user(usr,"  Ratio:      \002No ratio.\002\n");
			tell_user(usr,"  UL/DL/Cred: \002%lluK/%lluK/%lluK\002\n",(u->ul)/1024,(u->dl)/1024,(u->cr)/1024);
#endif
			if ((c=find_chat(u,&chatlist))!=NULL)
			{
				tell_user(usr,"  Idletime:   \002%s\002\n",convert_idle(time(NULL)-(c->itime)));
				tell_user(usr,"  Open DCCs:  \002%d\002\n",c->filenum);
				tell_user(usr,"  Q'ed DCCs:  \002%d\002\n",c->queued);				
			}
			else
			{
				tell_user(usr,"  \002%s\002 is not connected.\n",u->nick);
			}
			tell_user(usr,"End of list.\n");
		}
		else
		{
			tell_user(usr,"Cannot find user \002%s\002 in my records.\n",n);
		}
	}
}
		
/* Function: Lists information about user. */
void cmd_whoami(struct chat_t *usr,char *args)
{
	/* Shortcut of the day. */
	cmd_who(usr,usr->chatter->nick);
}
