/* Fairlight's ICB Client                                                    */
/* Copyright 1994, Mark Luljak <fairlite@arcadia.aldridge.sol.net>           */
/*                                                                           */



#include "flicb.h"

/*  Function:  [hi]output(stringer, y, x, wptr);
 *  Output a [highlighted] string in the window environment.
 *  Parms:  stringer = string to output
 *          wptr     = pointer to window to output in
 *          x, y     = x, y coordinates within window to print at
 *  Return:  returns static value of zero (0)
 */

int hioutput(stringer, y, x, wptr)
char stringer[STRINGSIZE];
int y, x;
WINDOW *wptr;
{
     char *sptr;

     wmove(wptr, y, x);
     wclrtoeol(wptr);
     wstandout(wptr);
     for (sptr = stringer; *sptr; sptr++) {
          waddch(wptr, *sptr);
          x++;
          wmove(wptr,y,x);
          wclrtoeol(wptr);
     }
     wstandend(wptr);
     wrefresh(wptr);
     return(0);
}


int output(stringer, y, x, wptr)
char stringer[STRINGSIZE];
int y, x;
WINDOW *wptr;
{
     char *sptr;

     wmove(wptr, y, x);
     wclrtoeol(wptr);
     for (sptr = stringer; *sptr; sptr++) {
          waddch(wptr, *sptr);
          x++;
          wmove(wptr,y,x);
          wclrtoeol(wptr);
     }
     wrefresh(wptr);
     return(0);
}



int noutput(stringer, y, x, wptr)
char stringer[STRINGSIZE];
int y, x;
WINDOW *wptr;
{
     char *sptr;

     wmove(wptr, y, x);
     for (sptr = stringer; *sptr; sptr++) {
          waddch(wptr, *sptr);
          x++;
          wmove(wptr,y,x);
     }
     return(0);
}

int w_pub_output(stringer,nick, y, x, wptr,winsize,ismesg)
char stringer[STRINGSIZE], nick[15];
int y,x;
WINDOW *wptr;
int winsize,ismesg;
{
     int a,endy,flag=0,origx;
     char totalnick[17],buffer[STRINGSIZE],bbuf[STRINGSIZE],*tmpword;
     char newstring[STRINGSIZE];
     char *optr,*tptr,*zptr;

     endy=y;
     origx=x;
     sprintf(newstring,"%s\0",stringer);
     wmove(wptr, y, origx);
     sprintf(totalnick,"<%s> ",nick);
     for (tptr=newstring;*tptr;tptr++) {}
     for (tmpword=strtok(newstring," ");tmpword;) {
          #ifdef SYSLOG
          openlog("flicb",LOG_PID,LOG_USER);
	  syslog(LOG_INFO,"nick: %s",totalnick);
          #endif
          if (y >= winsize) {
              flag=1;
              y = winsize-1;
              wmove(wptr,0,0);
              wdeleteln(wptr);
	      wmove(wptr,y,origx);
              winsertln(wptr);
	      wmove(wptr,y,origx);
              wclrtobot(wptr);
              wrefresh(wptr);
          }
          output(totalnick,y,x,wptr);
          x+=strlen(totalnick);
          wmove(wptr,y,x);
          sprintf(buffer,"%s",tmpword);
          a=strlen(tmpword);
          #ifdef SYSLOG
          syslog(LOG_INFO,"tmpword: %s",tmpword);
          #endif
          for (;;) {
               for (optr=tmpword;*optr;optr++) {}
               optr++;
               for (zptr=buffer;*zptr;zptr++) {}
               for (;!(a+1 > (80-origx-strlen(totalnick)-3));) {
                    if (*optr != ' ') { break; }
                    if (*optr) {
                         *zptr=*optr;
                         zptr++;
                         optr++;
                         a++;
                    } else { break; }
               }
               *zptr='\0';
               tmpword = strtok(NULL," ");
               #ifdef SYSLOG
               syslog(LOG_INFO,"tmpword: %s",tmpword);
               syslog(LOG_INFO,"optr: %s",optr);
               #endif
               if (!tmpword) {
                    break;
               }
               if ((a+strlen(tmpword)) > (80-origx-strlen(totalnick)-3)) {
                    break;
               } else {
                    sprintf(buffer,"%s %s",buffer,tmpword);
                    a+=(strlen(tmpword)+1);
               }
          }
          sprintf(buffer,"%s%c",buffer,NULL);
          output(buffer,y,x,wptr);
          y++;
          x=origx;
     }
     x=origx;
     if (alertmes == 1 && ismesg == 1) {
          wmove(wptr,1,1);
          waddch(wptr,'\007');
          wmove(wptr,y,x);
          wrefresh(wptr);
          wmove(wptr,1,1);
          waddch(wptr,' ');
     }
     wmove(wptr,y,x);
     wrefresh(wptr);
     #ifdef SYSLOG
     closelog();
     #endif 
     if (flag) {
          return(winsize);
     } else {
          return(y-endy);
     }
}


int w_stat_output(stringer,nick, y, x, wptr,winsize)
char stringer[STRINGSIZE], nick[15];
int y,x;
WINDOW *wptr;
int winsize;
{
     int a,endy,flag=0,origx;
     char totalnick[17],buffer[STRINGSIZE],bbuf[STRINGSIZE],*tmpword;
     char newstring[STRINGSIZE];

     endy=y;
     origx=x;
     sprintf(newstring,"%s",stringer);
     wmove(wptr, y, origx);
     sprintf(totalnick,"[=%s=] - ",nick);
     for (tmpword=strtok(newstring," ");tmpword;) {
          if (y >= winsize) {
              flag=1;
              y = winsize-1;
              wmove(wptr,0,0);
              wdeleteln(wptr);
              wmove(wptr, y, origx);
              winsertln(wptr);
              wmove(wptr, y, origx);
              wclrtobot(wptr);
              wrefresh(wptr);
          }
          output(totalnick,y,x,wptr);
          x+=strlen(totalnick);
          wmove(wptr,y,x);
          sprintf(buffer,"%s",tmpword);
          a=strlen(tmpword);
          for (;;) {
               tmpword = strtok(NULL," ");
               if (!tmpword) {
                    break;
               }
               if ((a+strlen(tmpword)) > (80-origx-strlen(totalnick)-3)) {
                    break;
               } else {
                    sprintf(buffer,"%s %s",buffer,tmpword);
                    a+=(strlen(tmpword)+1);
               }
          }
          sprintf(buffer,"%s%c",buffer,NULL);
          output(buffer,y,x,wptr);
          y++;
          x=origx;
     }
     x=origx;
     wmove(wptr,y,x);
     wrefresh(wptr);
     if (flag) {
          return(winsize);
     } else {
          return(y-endy);
     }
}





int w_beep_output(stringer,nick, y, x, wptr,winsize)
char stringer[STRINGSIZE], nick[15];
int y,x;
WINDOW *wptr;
int winsize;
{
     int a,endy,flag=0,origx;
     char totalnick[17],buffer[STRINGSIZE],bbuf[STRINGSIZE],*tmpword;
     char newstring[STRINGSIZE];

     endy=y;
     origx=x;
     sprintf(newstring,"%s sent you a beep!",stringer);
     wmove(wptr, y, origx);
     sprintf(totalnick,"[=BEEP=] - ");
     for (tmpword=strtok(newstring," ");tmpword;) {
          if (y >= winsize) {
              flag=1;
              y = winsize-1;
              wmove(wptr,0,0);
              wdeleteln(wptr);
              wmove(wptr,y,origx);
              winsertln(wptr);
              wmove(wptr, y, origx);
              wclrtobot(wptr);
              wrefresh(wptr);
          }
          output(totalnick,y,x,wptr);
          x+=strlen(totalnick);
          wmove(wptr,y,x);
          sprintf(buffer,"%s",tmpword);
          a=strlen(tmpword);
          for (;;) {
               tmpword = strtok(NULL," ");
               if (!tmpword) {
                    break;
               }
               if ((a+strlen(tmpword)) > (80-origx-strlen(totalnick)-3)) {
                    break;
               } else {
                    sprintf(buffer,"%s %s",buffer,tmpword);
                    a+=(strlen(tmpword)+1);
               }
          }
          sprintf(buffer,"%s%c",buffer,NULL);
          output(buffer,y,x,wptr);
          y++;
          x=origx;
          wmove(wptr, y, x);
     }
     x=origx;
     wmove(wptr,1,1);
     waddch(wptr,'\007');
     wmove(wptr,y,x);
     wrefresh(wptr);
     wmove(wptr,1,1);
     waddch(wptr,' ');
     wmove(wptr,y,x);
     wrefresh(wptr);
     if (flag) {
          return(winsize);
     } else {
          return(y-endy);
     }
}


int w_ver_output(stringer,nick, y, x, wptr,winsize)
char stringer[STRINGSIZE], nick[15];
int y,x;
WINDOW *wptr;
int winsize;
{
     int a,endy,flag=0,origx;
     char totalnick[17],buffer[STRINGSIZE],bbuf[STRINGSIZE],*tmpword;
     char newstring[STRINGSIZE];

     endy=y;
     origx=x;
     if (y >= winsize) {
         flag=1;
         y = winsize-1;
         wmove(wptr,0,0);
         wdeleteln(wptr);
         wmove(wptr, y, origx);
         winsertln(wptr);
         wmove(wptr, y, origx);
         wclrtobot(wptr);
         wrefresh(wptr); 
     }
     sprintf(newstring,"%s",stringer);
     wmove(wptr, y, origx);
     sprintf(buffer,"Connected to %s - %s",newstring,nick);
     output(buffer,y,x,wptr);
     y++;
     wmove(wptr,y,x);
     x=origx;
     wmove(wptr,y,x);
     wrefresh(wptr);
     if (flag) {
          return(winsize);
     } else {
          return(y-endy);
     }
}

int w_cmd_output(stringer,nick, y, x, wptr,winsize)
char stringer[STRINGSIZE], nick[STRINGSIZE];
int y,x;
WINDOW *wptr;
int winsize;
{
     int a,endy,flag=0,origx;
     char totalnick[17],buffer[STRINGSIZE],bbuf[STRINGSIZE],*tmpword;
     char newstring[STRINGSIZE];

     endy=y;
     origx=x;
     if (y >= winsize) {
         flag=1;
         y = winsize-1;
         wmove(wptr,0,0);
         wdeleteln(wptr);
         wrefresh(wptr);
         wmove(wptr,y,origx);
         wclrtobot(wptr);
     }
     sprintf(newstring,"%s",stringer);
     wmove(wptr, y, origx);
     sprintf(totalnick,"%s",nick);
     output(newstring,y,x,wptr);
     y++;
     x=origx;
     wmove(wptr,y,x);
     wrefresh(wptr);
     if (flag) {
          return(winsize);
     } else {
          return(y-endy);
     }
}



/*  Function:  center(string, row, window, flag);
 *  Output centered text in a specified window at a specified row
 *  Parms:  string = string to center
 *          row    = row to center text in
 *          window = window to center text in
 *  Return:  returns static integer zero (0)
 *  Depends on:  output()
 */

int center(stringval, row, wptr, flag)
char stringval[STRINGSIZE];
int row;
WINDOW *wptr;
int flag;
{
     int pos;

     pos = ((80-(strlen(stringval))) / 2);
     if (flag) {wstandout(wptr);}
     noutput(stringval, row, pos, wptr);
     if (flag) {wstandend(wptr);}
     wrefresh(wptr);
     return(0);
}



/*  Function:  rightflush(wptr, row, column, string)
 *  Output string flushed right against a given column at given row
 *      in a given window
 *  Parms:  string = string to output
 *          column = column to flush against
 *          row    = row to output in
 *          wptr   = window to output in
 *  Return:  returns static integer zero (0)
 *  Depends on:  output()
 */

rightflush(wptr, row, column, string)
WINDOW *wptr;
char string[STRINGSIZE];
int row, column;
{
     int start;

     start = ((column - strlen(string) + 1));
     output(string, row, start, wptr);
     wrefresh(wptr);
     return(0);

}


/*  Function:  boxit(x, y, width, height, wptr)
 *  Draw a box in inverse chars, char being BOXCHAR
 *  Parms:  x      = starting x
 *          y      = starting y
 *          width  = width of box (interior width, not counting lines)
 *          height = height of box (interior)
 *          wptr   = window to draw box in
 *  Return:  returns static integer zero (0)
 */


int boxit(x, y, width, height, wptr)
int x,y,width,height;
WINDOW *wptr;
{
     int count;

     wstandout(wptr);
     for (count = 0; count < width + 2; count++) {
          wmove(wptr, y - 1, x + count - 1);
          waddch(wptr, (char) BOXCHAR);
          wmove(wptr, y + height + 1, x + count);
          waddch(wptr, (char) BOXCHAR);
     }
     for (count = 0; count < height + 3; count++) {
          wmove(wptr, y + count - 1, x - 1);
          waddch(wptr, (char) BOXCHAR);
          wmove(wptr, y + count - 1, x + width + 1);
          waddch(wptr, (char) BOXCHAR);
     }
     wstandend(wptr);
     wrefresh(wptr);
     return(0);
}



/*  Function:  centerbox(arr, wptr)
 *  Center text in an array of strings inside a box centered onscreen
 *  Parms:  arr  = array of strings to display
 *          wptr = window to display to
 *  Return:  returns static integer zero (0)
 */

int centerbox(arr, wptr)
char *arr[];
WINDOW  *wptr;
{
     int maxwidth, start_x, start_y, numstrings, count;

     count = 0;
     maxwidth = 0;

     for (numstrings = 0; arr[numstrings]; numstrings++) {
          if(arr[numstrings]) {
               if (strlen(arr[numstrings]) > maxwidth) {
                    maxwidth = strlen(arr[numstrings]) + 2;
	       }
	  }
     }
     
     numstrings--;
     start_x = ((80 - (maxwidth + 2)) / 2);
     start_y = ((24 - (numstrings + 2)) / 2);

     boxit(start_x, start_y, maxwidth, numstrings + 2, wptr);
     for (numstrings = 0; arr[numstrings]; numstrings++) {
          if (arr[numstrings]) {
               center(arr[numstrings], (start_y + 1 + count++), wptr, 0);
	  }
     }
     wrefresh(wptr);
     return(0);
}




int spinner(stringer,wptr,y,invers)
char *stringer;
WINDOW *wptr;
int y,invers;
{
     char *lptr,*rptr;
     int dres,lnum,rnum,lpos,rpos;
     float result; 
 
     if (invers) {
          wstandout(wptr);
     }
     dres=strlen(stringer);
     result=dres/2;
     if ((result*2)!=dres) {
          lptr=stringer;
          rptr=stringer;
          lptr+=(dres/2);
          rptr+=(dres/2);
          rnum=(dres/2);
          lnum=(dres/2);
          lpos=((80-dres)/2)+(result); 
          rpos=lpos;
          wmove(wptr,y,lpos);
          waddch(wptr,*lptr);
          lpos--;
          rpos++;
          lptr--;
          rptr++;
          for (;lnum>0;lnum--) {
               wmove(wptr,y,rpos);
               waddch(wptr,'/');
               wmove(wptr,y,lpos);
               waddch(wptr,'\\');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'|');
               wmove(wptr,y,lpos);
               waddch(wptr,'|');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'-');
               wmove(wptr,y,lpos);
               waddch(wptr,'-');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'\\');
               wmove(wptr,y,lpos);
               waddch(wptr,'/');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,lpos);
               waddch(wptr,*lptr);
               wmove(wptr,y,rpos);
               waddch(wptr,*rptr);
               wrefresh(wptr);
               usleep(17500);
               lpos--;
               rpos++;
               lptr--;
               rptr++;
          }
     } else {
          lptr=stringer;
          rptr=stringer;
          lptr+=(dres/2)-1;
          rptr+=(dres/2)-1;
          rptr++;
          rnum=(dres/2)-1;
          lnum=(dres/2)-1;
          lpos=((80-dres)/2)+(result)-1; 
          rpos=lpos+1;
          wmove(wptr,y,lpos);
          waddch(wptr,*lptr);
          wmove(wptr,y,rpos);
          waddch(wptr,*rptr);
          lpos--;
          rpos++;
          lptr--;
          rptr++;
          for (;lnum>0;lnum--) {
               wmove(wptr,y,rpos);
               waddch(wptr,'/');
               wmove(wptr,y,lpos);
               waddch(wptr,'\\');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'|');
               wmove(wptr,y,lpos);
               waddch(wptr,'|');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'-');
               wmove(wptr,y,lpos);
               waddch(wptr,'-');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,rpos);
               waddch(wptr,'\\');
               wmove(wptr,y,lpos);
               waddch(wptr,'/');
               wrefresh(wptr);
               usleep(17500);
               wmove(wptr,y,lpos);
               waddch(wptr,*lptr);
               wmove(wptr,y,rpos);
               waddch(wptr,*rptr);
               wrefresh(wptr);
               usleep(17500);
               lpos--;
               rpos++;
               lptr--;
               rptr++;
          }
     }
     if (invers) {
          wstandend(wptr);
     }
     return(0);
}
