/* fdes.c --- File descriptor I/O functions

    Copyright (C) 1993, 1994  Rolf Krahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include "fdes.h"

int dgets (int fd, char *buf, int maxsize /* maxsize >= 1 */ )
{
  char c = '\0';
  int i = 0;

  while ((c != '\n') && (i < maxsize - 1))
  {
    if (read(fd, &c, 1) != 1) break;
    buf[i] = c;
    i++;
  }

  buf[i] = '\0';

  return i;
}

int dputs (int fd, const char *buf)
{
   int i;
   
   i = write(fd, buf, strlen(buf));
   write(fd, "\n", 1);
   
   return (i >= 0) ? (i + 1) : i;
}

