# OpenVerse Server GUI
# 
# This is the GUI wrapper for the server source code.
#
# Module Name		- Server GUI
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMain
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

#NOTE
#
# Now using curley braces around functiosn for greater speed


proc KillServer {} {
	global MVS

	catch {close $MVS(server_socket)}
	foreach sckt $MVS(socks) {
		SendToUser $sckt "CHAT $MVS($sckt.name) Server Is Going Down!"
		DisconnectUser $sckt 1
	}
	set MVS(serving) 0
	if {[winfo exists .ovserver]} {destroy .ovserver}
	DoNames
}

proc AnnounceServer {} {
	global MVS MV
	SendToServer "URL * OpenVerse://$MV(MyIpAddress):$MVS(port)"
}

proc AnnounceServerToUser {person} {
	global MVS MV
	SendToServer "URL $MV(whois.$person) OpenVerse://$MV(MyIpAddress):$MVS(port)"
	SendToServer "URL $MV(nick) OpenVerse://$MV(MyIpAddress):$MVS(port)"
}

proc ConnectToOwn {} {
	global MVS MV
	Disconnect
	set MV(roomhost) 127.0.0.1
	set MV(roomport) $MVS(port)
	Connect
}

proc ClearServerLog {} {
	.ovserver.log delete 0.0 end
}

proc StartServer {} {
	global MVS

	if {[winfo exists .serverQuestion]} {destroy .serverQuestion}
	if $MVS(serving) {
		ReallyStartServer
		return
	}
	if ![tk_dialog .serverQuestion "Really Start Server?" \
		"This command will start a personal OpenVerse Server. Are you sure you want to do this? A personal server is used to invite people to chat in your own private room." \
		"" 1 "Start The Server" "Oops! Nevermind!"] {
		ReallyStartServer
	}

}

proc ReallyStartServer {} {
	global MV tcl_interactive MVS

	if ![winfo exists .ovserver] {
		toplevel .ovserver
		wm title .ovserver "Personal OpenVerse Server"
		frame .ovserver.buttons -relief sunken -borderwidth 1
		button .ovserver.buttons.close -text "Kill Server" -command {KillServer}
		button .ovserver.buttons.announce -text "Announce Server" -command {AnnounceServer}
		button .ovserver.buttons.connect -text "Connect" -command {ConnectToOwn}
		button .ovserver.buttons.clear -text "Clear Log" -command {ClearServerLog}
		button .ovserver.buttons.setup -text "Server Settings" -command {ServerSetup}
		frame .ovserver.buttons.info -relief raised -borderwidth 1
		label .ovserver.buttons.info.l -text "Users Connected"
		label .ovserver.buttons.info.v -text $MVS(users) -relief sunken -borderwidth 1
		text .ovserver.log
		pack .ovserver.buttons -fill both -expand y
		pack .ovserver.log -fill both -expand y
		pack .ovserver.buttons.close .ovserver.buttons.setup \
			.ovserver.buttons.announce .ovserver.buttons.connect \
			.ovserver.buttons.clear .ovserver.buttons.info \
			-side left -fill both -expand y
		pack .ovserver.buttons.info.l -side left \
			-fill both -expand y
		pack .ovserver.buttons.info.v -side left
	} 
	if $MVS(serving) {return} else {
		set tcl_interactive 1
		set homedir "$MV(homedir)"
		catch {source "$MV(libbase)/server.tcl"} err
		LogIt $err
		LogIt "Server Started - Your IP Address is $MV(MyIpAddress)"
	}
	DoNames
}

proc ServerSetup {} {
	global SMVS MVS MV

	if {[winfo exists .serversetup]} {destroy .serversetup}

	toplevel .serversetup
	wm title .serversetup "Server Settings"
	frame .serversetup.roomname -relief raised -borderwidth 2
	frame .serversetup.image -relief raised -borderwidth 2
	frame .serversetup.port -relief raised -borderwidth 2
	frame .serversetup.buttons -relief raised -borderwidth 2

	label .serversetup.roomname.l -relief raised -borderwidth 2 -width 20 \
		-text "Room Name"
	button .serversetup.image.l -width 20 -command ChooseServerImage \
		-text "Room Image"
	label .serversetup.port.l -relief raised -borderwidth 2 -width 20 \
		-text "Server Port"

	entry .serversetup.roomname.v -textvariable SMVS(roomname)
	entry .serversetup.image.v -textvariable SMVS(roomfile)
	entry .serversetup.port.v -textvariable SMVS(port)

	button .serversetup.buttons.cancel -text Cancel -command {destroy .serversetup}
	button .serversetup.buttons.save -text "Save/Apply" -command {SaveServerSettings}
	

	pack .serversetup.roomname -fill both -expand y
	pack .serversetup.image -fill both -expand y
	pack .serversetup.port -fill both -expand y
	pack .serversetup.buttons -fill both -expand y
	
	pack .serversetup.roomname.l .serversetup.roomname.v -side left \
		-fill both -expand y
	pack .serversetup.port.l .serversetup.port.v -side left \
		-fill both -expand y
	pack .serversetup.image.l .serversetup.image.v -side left \
		-fill both -expand y
	pack .serversetup.buttons.cancel .serversetup.buttons.save \
		-side left -fill both -expand y

	set SMVS(roomname) $MVS(roomname)
	set SMVS(port) $MVS(port)
	set SMVS(roomfile) $MVS(roomfile)
}

proc SaveServerSettings {} {
	global MV MVS SMVS
	set outfile [open "$MV(homedir)/pserver.cfg" w]

	if ![file exists "$MV(homedir)/rooms/[file tail $SMVS(roomfile)]"] {
		file copy "$SMVS(roomfile)" "$MVS(homedir)/rooms"
	}
	puts $outfile "set MVS(roomname) \"$SMVS(roomname)\""
	puts $outfile "set MVS(port) \"$SMVS(port)\""
	puts $outfile "set MVS(roomfile) \"[file tail $SMVS(roomfile)]\""
	set MVS(port) $SMVS(port)
	set MVS(roomname) $SMVS(roomname)
	set MVS(roomfile) $SMVS(roomfile)
	close $outfile
	destroy .serversetup
	ReloadConfig
}

proc ChooseServerImage {} {
	global SMVS

	set file [tk_getOpenFile]
	#Performance enhancement
	if {[string compare $file ""]} {set SMVS(roomfile) $file}
}
