# OpenVerse Objects Module 
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Objects Module
# Current Revision No.	- 0.1
# Current Maintainter 	- Cruise <cruise@drunkenbastards.org>
# Last update 		- Sun Sep  5 21:24:33 EDT 1999
# Sourced By		- Command Line
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# Performance enhancements using string compare


proc NewObject {} {
}

proc DrawBox {name x1 y1 x2 y2 fill outline duration} {
	global MV
	
	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		KillServerObject $MV(server_objects.$name.id)
	}
	lappend MV(server_objects) $name
	set id [.top.c create rectangle $x1 $y1 $x2 $y2 \
		-fill $fill -outline $outline]

	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$name.type) "BOX"

	if $duration {
		after $duration "KillServerObject $id"
	} else {
		update idletasks
	}
}

proc DrawImage {name x1 y1 image size duration} {
	global MV

	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		set MV(server_objects.$name.image) $image
		if ![file exists "$MV(objects)/$image"] {
			if {[lsearch -exact $MV(downloads) $image] == -1} {
				SendToServer "DCCSENDOB $image"
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			} else {
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			}
		} else {
			if {$size != [file size "$MV(objects)/$image"]} {
				if {[lsearch -exact $MV(downloads) $image] == -1} {
					SendToServer "DCCSENDOB $image"
					image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
				} else {
					image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
				}
			} else {
				image create photo server_object_$name -file "$MV(objects)/$image"
			}
		}
		if $duration {
			after $duration "KillServerObject $MV(server_objects.$name.id)"
		} else {
			update idletasks
		}
		return
	}
	lappend MV(server_objects) $name

	if ![file exists "$MV(objects)/$image"] {
		if {[lsearch -exact $MV(downloads) $image] == -1} {
			SendToServer "DCCSENDOB $image"
			image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
		} else {
			image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
		}
	} else {
		if {$size != [file size "$MV(objects)/$image"]} {
			if {[lsearch -exact $MV(downloads) $image] == -1} {
				SendToServer "DCCSENDOB $image"
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			} else {
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			}
		} else {
			image create photo server_object_$name -file "$MV(objects)/$image"
		}
	}

	set id [.top.c create image $x1 $y1 -image server_object_$name]

	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) $image
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$name.type) "IMAGE"

	if $duration {
		after $duration "KillServerObject $id"
	} else {
		update idletasks
	}
}

proc DrawMouseOver {name x1 y1 image1 size1 image2 size2 duration} {
	global MV

	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		if ![file exists "$MV(objects)/$image1"] {
			if {[lsearch -exact $MV(downloads) $image1] == -1} {
				SendToServer "DCCSENDOB $image1"
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			} else {
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			}
		} else {
			if {$size1 != [file size "$MV(objects)/$image1"]} {
				if {[lsearch -exact $MV(downloads) $image1] == -1} {
					SendToServer "DCCSENDOB $image1"
					image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
				} else {
					image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
				}
			} else {
				image create photo server_object_$name -file "$MV(objects)/$image1"
			}
		}

		if ![file exists "$MV(objects)/$image2"] {
			if {[lsearch -exact $MV(downloads) $image2] == -1} {
				SendToServer "DCCSENDOB $image2"
			}
		} else {
			if {$size2 != [file size "$MV(objects)/$image2"]} {
				if {[lsearch -exact $MV(downloads) $image2] == -1} {
					SendToServer "DCCSENDOB $image2"
				}
			}
		}
		if $duration {
			after $duration "KillServerObject $MV(server_objects.$name.id)"
		} else {
			update idletasks
		}
		return
	}
	lappend MV(server_objects) $name

	if ![file exists "$MV(objects)/$image1"] {
		if {[lsearch -exact $MV(downloads) $image1] == -1} {
			SendToServer "DCCSENDOB $image1"
			image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
		} else {
			image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
		}
	} else {
		if {$size1 != [file size "$MV(objects)/$image1"]} {
			if {[lsearch -exact $MV(downloads) $image1] == -1} {
				SendToServer "DCCSENDOB $image1"
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			} else {
				image create photo server_object_$name -file "$MV(icondir)/unknown.gif"
			}
		} else {
			image create photo server_object_$name -file "$MV(objects)/$image1"
		}
	}

	if ![file exists "$MV(objects)/$image2"] {
		if {[lsearch -exact $MV(downloads) $image2] == -1} {
			SendToServer "DCCSENDOB $image2"
		}
	} else {
		if {$size2 != [file size "$MV(objects)/$image2"]} {
			if {[lsearch -exact $MV(downloads) $image2] == -1} {
				SendToServer "DCCSENDOB $image2"
			}
		}
	}

	set id [.top.c create image $x1 $y1 -image server_object_$name]
	.top.c bind $id <Enter> "MouseOverEvent 1 $id"
	.top.c bind $id <Leave> "MouseOverEvent 0 $id"

	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) $image1
	set MV(server_objects.$name.image2) $image2
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$name.type) "MOUSEOVER"

	if $duration {
		after $duration "KillServerObject $id"
	} else {
		update idletasks
	}
}

proc DrawText {name x1 y1 color size duration text} {
	global MV

	set font(1) -*-Helvetica-Medium-R-Normal-*-8-*
	set font(2) -*-Helvetica-Medium-R-Normal-*-12-*
	set font(3) -*-Helvetica-Medium-R-Normal-*-14-*
	set font(4) -*-Helvetica-Medium-R-Normal-*-18-*
	set font(5) -*-Helvetica-Medium-R-Normal-*-24-*
	
	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		.top.c itemconfigure $MV(server_objects.$name.id) -fill $color -text $text -font $font($size)
		if $duration {
			after $duration "KillServerObject $MV(server_objects.$name.id)"
		} else {
			update idletasks
		}
		return
	}
	lappend MV(server_objects) $name

	set id [.top.c create text $x1 $y1 -fill $color -text $text -font $font($size)]
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.type) "TEXT"

	if $duration {
		after $duration "KillServerObject $id"
	}
}

proc DrawWText {name x1 y1 color size duration width text} {
	global MV

	set font(1) -*-Helvetica-Medium-R-Normal-*-8-*
	set font(2) -*-Helvetica-Medium-R-Normal-*-12-*
	set font(3) -*-Helvetica-Medium-R-Normal-*-14-*
	set font(4) -*-Helvetica-Medium-R-Normal-*-18-*
	set font(5) -*-Helvetica-Medium-R-Normal-*-24-*
	
	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		.top.c itemconfigure $MV(server_objects.$name.id) -fill $color -text $text -font $font($size) -width $width
		if $duration {
			after $duration "KillServerObject $MV(server_objects.$name.id)"
		} else {
			update idletasks
		}
		return
	}
	lappend MV(server_objects) $name

	set id [.top.c create text $x1 $y1 -fill $color -text $text -font $font($size) -width $width]
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.type) "TEXT"

	if $duration {
		after $duration "KillServerObject $id"
	}
}

proc DrawEntry {name x1 y1 length color text_color duration text} {
	global MV

	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		KillServerObject $MV(server_objects.$name.id)
	}
	lappend MV(server_objects) $name

	set MV(server_objects.$name.text) "$text"
	entry .top.c.$name -width $length -bg $color \
		-fg $text_color -textvariable MV(server_objects.$name.text)

	set id [.top.c create window $x1 $y1 -window .top.c.$name]
	set MV(server_objects.$name.id) $id
	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.type) "ENTRY"

	if $duration {
		after $duration "KillServerObject $id"
	} else {
		update idletasks
	}
}

proc DrawSubmit {name x1 y1 color text_color duration text} {
	global MV

	if {[lsearch -exact $MV(server_objects) $name] != -1} {
		KillServerObject $MV(server_objects.$name.id)
	}
	lappend MV(server_objects) $name

	set MV(server_objects.$name.text) "$text"
	button .top.c.$name -bg $color -fg $text_color \
		-activebackground $color \
		-text $MV(server_objects.$name.text)

	set id [.top.c create window $x1 $y1 -window .top.c.$name]
	set MV(server_objects.$name.id) $id
	.top.c.$name configure -command "ObjectSubmit $id"
	set MV(server_objects.$id.name) $name
	set MV(server_objects.$name.image) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.image2) "NOT_IMAGE_COMPATABLE"
	set MV(server_objects.$name.type) "SUBMIT"

	if $duration {
		after $duration "KillServerObject $id"
	} else {
		update idletasks
	}
}

proc DrawLink {name x1 y1 x2 y2 duration url} {
	global MV

	if {[lsearch -exact $MV(server_links) $name] != -1} {
		KillServerLink $MV(server_links.$name.id)
	}
	lappend MV(server_links) $name

	set id [incr MV(current_link_id)]
	set MV(server_links.$name.x1) $x1
	set MV(server_links.$name.y1) $y1
	set MV(server_links.$name.x2) $x2
	set MV(server_links.$name.y2) $y2
	set MV(server_links.$name.url) $url
	set MV(server_links.$id.name) $name
	set MV(server_links.$name.id) $id
	if $duration {
		after $duration "KillServerLink $id"
	} else {
		update idletasks
	}
}

# TELL  NAME x1 y1 x2 y2 duration
proc DrawTell {name x1 y1 x2 y2 duration} {
	global MV

	if {[lsearch -exact $MV(server_tells) $name] != -1} {
		KillServerTell $MV(server_tells.$name.id)
	}
	lappend MV(server_tells) $name

	set id [incr MV(current_tell_id)]
	set MV(server_tells.$name.x1) $x1
	set MV(server_tells.$name.y1) $y1
	set MV(server_tells.$name.x2) $x2
	set MV(server_tells.$name.y2) $y2
	set MV(server_tells.$name.url) "NOT URL COMPATABLE"
	set MV(server_tells.$id.name) $name
	set MV(server_tells.$name.id) $id
	if $duration {
		after $duration "KillServerTell $id"
	} else {
		update idletasks
	}
}

proc DrawExit {name x1 y1 x2 y2 duration host port} {
	global MV

	if {[lsearch -exact $MV(server_exits) $name] != -1} {
		KillServerExit $MV(server_exits.$name.id)
	}
	lappend MV(server_exits) $name

	set id [incr MV(current_exits_id)]
	set MV(server_exits.$name.x1) $x1
	set MV(server_exits.$name.y1) $y1
	set MV(server_exits.$name.x2) $x2
	set MV(server_exits.$name.y2) $y2
	set MV(server_exits.$name.host) $host
	set MV(server_exits.$name.port) $port
	set MV(server_exits.$id.name) $name
	set MV(server_exits.$name.id) $id
	if $duration {
		after $duration "KillServerExit $id"
	} else {
		update idletasks
	}
}

proc KillServerExit {id} {
	global MV
	set idx [lsearch -exact $MV(server_exits) $MV(server_exits.$id.name)]
	set MV(server_exits) [lreplace $MV(server_exits) $idx $idx]
}

proc KillServerLink {id} {
	global MV
	set idx [lsearch -exact $MV(server_links) $MV(server_links.$id.name)]
	set MV(server_links) [lreplace $MV(server_links) $idx $idx]
}

proc KillServerTell {id} {
	global MV
	set idx [lsearch -exact $MV(server_tells) $MV(server_tells.$id.name)]
	set MV(server_tells) [lreplace $MV(server_tells) $idx $idx]
}

proc KillServerObject {id} {
	global MV

	if {[string compare $MV(server_objects.$MV(server_objects.$id.name).image) "NOT_IMAGE_COMPATABLE"]} {
		image delete server_object_$MV(server_objects.$id.name)
	}
	if {[string compare $MV(server_objects.$MV(server_objects.$id.name).image2) "NOT_IMAGE_COMPATABLE"]} {
		image delete server_object_$MV(server_objects.$id.name)
	}
	set idx [lsearch -exact $MV(server_objects) $MV(server_objects.$id.name)]
	set MV(server_objects) [lreplace $MV(server_objects) $idx $idx]
	.top.c delete $id
	switch $MV(server_objects.$MV(server_objects.$id.name).type) {
		"ENTRY" {
			destroy .top.c.$MV(server_objects.$id.name)
		}
		"SUBMIT" {
			destroy .top.c.$MV(server_objects.$id.name)
		}
	}
}

proc MouseOverEvent {onoff id} {
	global MV

	if $onoff {
		catch {image create photo server_object_$MV(server_objects.$id.name) -file "$MV(objects)/$MV(server_objects.$MV(server_objects.$id.name).image2)"} err
	} else {
		catch {image create photo server_object_$MV(server_objects.$id.name) -file "$MV(objects)/$MV(server_objects.$MV(server_objects.$id.name).image)"}
	}
}

proc ObjectSubmit {id} {
	global MV
	foreach object $MV(server_objects) {
		# Performance Enhancement DRG
		if {![string compare $MV(server_objects.$object.type) "ENTRY"]} {
			SendToServer "ENTRY $object $MV(server_objects.$object.text)"
		}
	}
	SendToServer "SUBMIT $MV(server_objects.$id.name)"
}

