# OpenVerse InitGlobal Variables
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Init Global Variables
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Modifications by KaosBeetl:
#    Room History, 01/16/2000, revised 02/07/2000, again 02/09/2000
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.


#
# THIS IS THE DEFAULT SERVER AND PORT
#
set MV(roomhost) "world.openverse.org"
set MV(roomport) "7000"


#
# TODO:
# All of these things need to be documented.
#

#
# Significant RunTime Variables
#
# The following variables will have an effect on 
# OpenVerse at runtime. Others will not affect OpenVerse
# visibly and are listed after this block.
#
# Directories and files
#
set MV(personal.image) "$MV(homedir)/icons/pinfo.gif"
set MV(personal.homepage) "http://openverse.org/"
set MV(bookmarks) "$MV(homedir)/passageways.txt"
set MV(configfile) "$MV(homedir)/MetaV.cfg"
set MV(history) "$MV(homedir)/history.txt"
set MV(rem_images) "$MV(homedir)/rimages"
set MV(plugindir) "$MV(homedir)/plugins"
set MV(objects) "$MV(homedir)/objects"
set MV(paneldir) "$MV(homedir)/panels"
set MV(images) "$MV(homedir)/images"
set MV(icondir) "$MV(homedir)/icons"
set MV(roomdir) "$MV(homedir)/rooms"
set MV(anims) "$MV(homedir)/anims"
set MV(avatar) "default.gif"
set MV(anim) "default.av"
#
# Strings
#
set MV(personal.info) "Type Information About Yourself Here!"
set MV(personal.email) "myemail@example.com"
set MV(download_dir) "$MV(homedir)/download"
set MV(roomname) "Welcome To The OpenVerse"
set MV(personal.realname) "My Real Name"
set MV(personal.availability) "Never"
set MV(browser_cmd) "netscape"
set MV(personal.sex) "Other"
set MV(nick) "Guest"
#
# Numeric Variables
#
set MV(use_windowmanager_colors) 0
set MV(download_avatars) 1
set MV(name_y_offset) 40
set MV(anim.baloon_x) 24
set MV(sort_bookmarks) 0
set MV(name_x_offset) 0
set MV(anim.baloon_y) 6
set MV(sendbuffer) 4096
set MV(honor_effects) 1
set MV(history_max) 10
set MV(getbuffer) 1024
set MV(dcctimeout) 180
set MV(anim.y_off) 20
set MV(keep_images) 3
set MV(honor_exits) 1
set MV(urltimeout) 30
set MV(anim.x_off) 0
set MV(movespeed) 10
set MV(honor_call) 1
set MV(chatsave) 200
set MV(prevsave) 100
set MV(timestamp) 0
set MV(staytime) 10
set MV(movespeed) 1
set MV(tooltips) 1
set MV(rot13) 0
set MV(bell) 1
set MV(x) 320
set MV(y) 200
#
# The following variables initalize various runtime states and should not
# be changed at all!! DO NOT CHANGE VARIABLES WITHIN THIS BLOCK.
#
# Begin State Initialization Section.
#
# Strings
#
set MV(version) "0.8-1"
set MV(MyIpAddress) "0.0.0.0"
#
# List Variables
#
set MV(server_objects) {}
set MV(server_queries) {}
set MV(ignore.avatar) {}
set MV(ignore.effect) {}
set MV(ignore.speech) {}
set MV(server_links) {}
set MV(server_tells) {}
set MV(server_exits) {}
set MV(ignore.move) {}
set MV(ignore.sub) {}
set MV(ignore.url) {}
set MV(ignore.all) {}
set MV(downloads) {}
set MV(roomloads) {}
set MV(people) {}
set MV(chats) {}
set MV(moves) {}
set MV(prev) {}
set MV(dcc_list) {}
#
# Numeric Variables
#
set MV(default_avatar_number) 0
set MV(current_exits_id) 0
set MV(downloadingroom) 0
set MV(textwindow.lock) 0
set MV(current_link_id) 0
set MV(current_tell_id) 0
set MV(anim.current) -1
set MV(popup_window) 0
set MV(anim.running) 0
set MV(pwq.queries) 0
set MV(textwindow) 0
set MV(query_time) 0
set MV(killsteam) 0
set MV(dlwindows) 0
set MV(killnotes) 0
set MV(killsmile) 0
set MV(killfrown) 0
set MV(anim.stop) 1
set MV(killhigh) 0
set MV(killlove) 0
set MV(killidea) 0
set MV(killwink) 0
set MV(curprev) -1
set MV(dcc_num) 0
set MV(moving) 0
set MV(dlnum) 0
set MV(names) 1
set MV(sock) -1
set MV(debug) 0
set MV(log) 0
#
# End State Initialization Section.
#

#
# Panel Related
#
set MV(panel) "Fun"

# ------------------------------------------------------------------------
#                          Plugin Specific Variables.
# ------------------------------------------------------------------------

# ------------------------------------
# ProcChat {who what system balloon}
# ------------------------------------
set MV(plugin.traps.ProcChat.pre) {}
set MV(plugin.traps.ProcChat.post) {}

# ------------------------------------
# ChangeAvatar {filename}
# ------------------------------------
set MV(plugin.traps.ChangeAvatar) {}

# ------------------------------------
# ChangeNick {newnick}
# ------------------------------------
set MV(plugin.traps.ChangeNick) {}

# ------------------------------------
# ChangeUserAvatar {who filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.ChangeUserAvatar) {}

# ------------------------------------
# Disconnect {}
# ------------------------------------
set MV(plugin.traps.Disconnect) {}

# ------------------------------------
# DoNames {widget who idx} (will call for each name in list.)
# ------------------------------------
set MV(plugin.traps.DoNames) {}

# ------------------------------------
# ShowName {who}
# ------------------------------------
set MV(plugin.traps.ShowName) {}

# ------------------------------------
# ShowNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.ShowNames) {}

# ------------------------------------
# KillNames {who} (will process for each user.)
# ------------------------------------
set MV(plugin.traps.KillNames) {}

# ------------------------------------
# ProcURL {who url type}
# ------------------------------------
set MV(plugin.traps.ProcURL) {}

# ------------------------------------
# RightClick {x y}
# ------------------------------------
set MV(plugin.traps.RightClick) {}

# ------------------------------------
# MoveTo {x y}
# ------------------------------------
set MV(plugin.traps.MoveTo.Pre) {}
set MV(plugin.traps.MoveTo.Post) {}

# ------------------------------------
# Pushed {x y}
# ------------------------------------
set MV(plugin.traps.Pushed.Pre) {}
set MV(plugin.traps.Pushed.Post) {}

# ------------------------------------
# MoveUser {who x y speed}
# ------------------------------------
set MV(plugin.traps.MoveUser.Pre) {}
set MV(plugin.traps.MoveUser.Post) {}

# ------------------------------------
# NewPerson {who x y filename name_x name_y filesize baloon_x baloon_y}
# ------------------------------------
set MV(plugin.traps.NewPerson) {}

# ------------------------------------
# ProcessCommand {original cmd parms rest}
# ------------------------------------
set MV(plugin.traps.ProcessCommand) {}

# ------------------------------------------------------------------------
#                       Our URL Type Handlers.
# ------------------------------------------------------------------------
set MV(URLS.x) {20 60 100 140 180 220 260 300 340 380 420 460 500 540 580 620}
set MV(URLS.y) {20 60 100 140 180 220 260 300 340 380 420}
for {set c 0} {$c < 16} {incr c} {
	for {set d 0} {$d < 12} {incr d} {
		set MV(URLS.$c.$d) 0
	}
}
set MV(url.icon.unknown) "unknown.gif"
set MV(url.txtlen.unknown) 24

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------

# ------------------------------------
# PersonLeft {who}
# ------------------------------------
set MV(plugin.traps.PersonLeft) {}

# ------------------------------------
# ProcessInput {original_text cmd parms rest}
# ------------------------------------
set MV(plugin.traps.ProcessInput.pre) {}
set MV(plugin.traps.ProcessInput.post) {}

# ------------------------------------
# SendText {text_to_send}
# ------------------------------------
set MV(plugin.traps.SendText) {}

# ------------------------------------------------------------------------
#                       Our default color scheme.
# ------------------------------------------------------------------------
# Colors of text in balloons.
set MV(color.0) "white"
set MV(color.1) "black"
set MV(color.2) "navy blue"
set MV(color.3) "dark green"
set MV(color.4) "red"
set MV(color.5) "brown"
set MV(color.6) "magenta"
set MV(color.7) "orange"
set MV(color.8) "yellow"
set MV(color.9) "green"
set MV(color.00) "white"
set MV(color.01) "black"
set MV(color.02) "navy blue"
set MV(color.03) "dark green"
set MV(color.04) "red"
set MV(color.05) "brown"
set MV(color.06) "magenta"
set MV(color.07) "orange"
set MV(color.08) "yellow"
set MV(color.09) "green"
set MV(color.10) "#00808"
set MV(color.11) "cyan"
set MV(color.12) "blue"
set MV(color.13) "hot pink"
set MV(color.14) "dark grey"
set MV(color.15) "light grey"
set MV(color.16) "white"
set MV(color.99) "black"
# Baloons.
set MV(colors.chat.baloon) "white"
set MV(colors.chat.text) "black"
set MV(colors.privmsg.baloon) "light blue"
set MV(colors.privmsg.text) "black"
set MV(colors.system.baloon) "white"
set MV(colors.system.text) "red"
set MV(colors.whois.baloon) "light green"
set MV(colors.whois.text) "black"

# ------------------------------------
# Main Window Buttons, entry points. (Button Mode)
# ------------------------------------
set MV(colors.buttons.quit.bg) "light blue"
set MV(colors.buttons.quit.fg) "black"
set MV(colors.buttons.quit.abg) "light blue"
set MV(colors.buttons.quit.afg) "red"
# ------------------------------------
set MV(colors.buttons.textchat.bg) "light blue"
set MV(colors.buttons.textchat.fg) "black"
set MV(colors.buttons.textchat.abg) "light blue"
set MV(colors.buttons.textchat.afg) "red"
# ------------------------------------
set MV(colors.buttons.help.bg) "light blue"
set MV(colors.buttons.help.fg) "black"
set MV(colors.buttons.help.abg) "light blue"
set MV(colors.buttons.help.afg) "red"
# ------------------------------------
set MV(colors.buttons.setup.bg) "light blue"
set MV(colors.buttons.setup.fg) "black"
set MV(colors.buttons.setup.abg) "light blue"
set MV(colors.buttons.setup.afg) "red"
# ------------------------------------
set MV(colors.buttons.passageways.bg) "light blue"
set MV(colors.buttons.passageways.fg) "black"
set MV(colors.buttons.passageways.abg) "light blue"
set MV(colors.buttons.passageways.afg) "red"
# ------------------------------------
set MV(colors.buttons.aved.bg) "light blue"
set MV(colors.buttons.aved.fg) "black"
set MV(colors.buttons.aved.abg) "light blue"
set MV(colors.buttons.aved.afg) "red"
# ------------------------------------
set MV(colors.buttons.animate.bg) "light blue"
set MV(colors.buttons.animate.fg) "black"
set MV(colors.buttons.animate.abg) "light blue"
set MV(colors.buttons.animate.afg) "red"
# ------------------------------------
set MV(colors.buttons.avatars.bg) "light blue"
set MV(colors.buttons.avatars.fg) "black"
set MV(colors.buttons.avatars.abg) "light blue"
set MV(colors.buttons.avatars.afg) "red"
# ------------------------------------
set MV(colors.buttons.sound.bg) "light blue"
set MV(colors.buttons.sound.fg) "black"
set MV(colors.buttons.sound.abg) "light blue"
set MV(colors.buttons.sound.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.bg) "light blue"
set MV(colors.buttons.names.fg) "black"
set MV(colors.buttons.names.abg) "light blue"
set MV(colors.buttons.names.afg) "red"
# ------------------------------------
set MV(colors.buttons.names.chk.bg) "light blue"
set MV(colors.buttons.names.chk.fg) "black"
set MV(colors.buttons.names.chk.abg) "light blue"
set MV(colors.buttons.names.chk.afg) "red"
# ------------------------------------
set MV(colors.buttons.send.bg) "light blue"
set MV(colors.buttons.send.fg) "black"
set MV(colors.buttons.send.abg) "light blue"
set MV(colors.buttons.send.afg) "red"
# ------------------------------------
set MV(colors.buttons.connect.bg) "light blue"
set MV(colors.buttons.connect.fg) "black"
set MV(colors.buttons.connect.abg) "light blue"
set MV(colors.buttons.connect.afg) "red"
# ------------------------------------
# Main Window Entry Boxes
# ------------------------------------
set MV(colors.buttons.entry.bg) "light blue"
set MV(colors.buttons.entry.fg) "black"
# ------------------------------------
# Main Window Frames
# ------------------------------------
set MV(colors.frames.chat.bg) "light blue"
set MV(colors.frames.topbar.bg) "light blue"
set MV(colors.frames.canvas.bg) "light blue"
set MV(colors.frames.menu.bg) "light blue"
set MV(colors.frames.menu.bord.bg) "light blue"
set MV(colors.frames.menu.top.bg) "light blue"
set MV(colors.frames.menu.bot.bg) "light blue"
set MV(colors.frames.names.bg) "light blue"
# ------------------------------------
# Passageways Entries.
# ------------------------------------
set MV(colors.pw.bg) "light blue"
set MV(colors.pw.fg) "black"
set MV(colors.pw.abg) "light blue"
set MV(colors.pw.afg) "red"
# ------------------------------------
# Avatars Entries.
# ------------------------------------
set MV(colors.av.bg) "light blue"
set MV(colors.av.fg) "black"
set MV(colors.av.abg) "light blue"
set MV(colors.av.afg) "red"
# ------------------------------------
# Names Entries.
# ------------------------------------
set MV(colors.name.bg) "light blue"
set MV(colors.name.fg) "black"
set MV(colors.name.abg) "light blue"
set MV(colors.name.afg) "red"
# ------------------------------------
# URL Offer information Window.
# ------------------------------------
set MV(colors.url.frames.bg) "light blue"
set MV(colors.url.labels.fg) "black"
set MV(colors.url.labels.bg) "light blue"
set MV(colors.url.entries.fg) "light green"
set MV(colors.url.entries.bg) "black"
set MV(colors.url.buttons.bg) "light blue"
set MV(colors.url.buttons.abg) "light blue"
set MV(colors.url.buttons.fg) "black"
set MV(colors.url.buttons.afg) "red"
# ------------------------------------
# Download information Window.
# ------------------------------------
set MV(colors.dl.frames.bg) "light blue"
set MV(colors.dl.labels.bg) "light blue"
set MV(colors.dl.labels.fg) "black"
set MV(colors.dl.entries.bg) "black"
set MV(colors.dl.entries.fg) "light green"
set MV(colors.dl.buttons.bg) "light blue"
set MV(colors.dl.buttons.fg) "black"
set MV(colors.dl.buttons.abg) "light blue"
set MV(colors.dl.buttons.afg) "red"



#
# Build our download window array and set all items to 0ff
#
for {set c 0} {$c < 26} {incr c} {
	for {set s 1} {$s < 4} {incr s} {
		set MV(dls.$c.$s) 0
		set MV(dlcps.$c.$s) 0
		set MV(dlactive.$c.$s) 0
	}
}
global tl
set tl(-1) 0


# ------------------------------------
# Personal Server Settings
# ------------------------------------
set MVS(serving) 0
set MVS(users) 0
