# OpenVerse Debugging GUI
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Debugging GUI
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMain
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# NOTE: Now using string compare to increase performance

proc ToggleDebug {} {
	global MV

	if $MV(debug) {
		set MV(debug) 0
		if {[winfo exists .debug]} {destroy .debug}
	} else {
		OpenDebugWindow
		set MV(debug) 1
	}
}

proc OpenDebugWindow {} {
	global MV

	toplevel .debug
	wm title .debug "OpenVerse Debug Window"
	frame .debug.stuff -relief sunken -borderwidth 2
	frame .debug.text -relief sunken -borderwidth 2

	label .debug.stuff.pos -text "Current Positon" -relief raised -borderwidth 2
	label .debug.stuff.x -width 3 -textvariable MV(x) -relief raised -borderwidth 2
	label .debug.stuff.y -width 3 -textvariable MV(y) -relief raised -borderwidth 2
	text .debug.text.text

	pack .debug.stuff -side top -fill both -expand y
	pack .debug.text -side bottom -fill both -expand y
	pack .debug.stuff.pos .debug.stuff.x .debug.stuff.y \
		-side left
	
	pack .debug.text.text -side bottom -fill both -expand y
}

proc DebugIt { what } {
	global MV

	if $MV(debug) {
		if {[winfo exists .debug]} {
			.debug.text.text insert end "$what\n"
		}
	}
}
