
#
# $Id: ._hosts_update.sh,v 1.3 1998/02/15 09:40:41 root Exp root $
#
# Do NOT remove this file or move it to a different location.
#
# This file contains common shell functions for use by the SPARC-Linux
# Xterminal package. It should not be executable. It should not start
# with "#!/bin/sh". It is sourced by the scripts which utilize the
# functions.
#
## 
## Copyright (c) 1997, 1998  John Little (gaijin@pobox.com)
## 
## Permission is hereby granted, free of charge, to any person obtaining a
## copy of this software and associated documentation files (the "Software"),
## to deal in the Software without restriction, including without limitation
## the rights to use, copy, modify, merge, publish, distribute, sublicense,
## and/or sell copies of the Software, and to permit persons to whom the
## Software is furnished to do so, subject to the following conditions:
## 
## The above copyright notice and this permission notice shall be included
## in all copies or substantial portions of the Software.
## 
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
## THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
## OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
## ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
## OTHER DEALINGS IN THE SOFTWARE.
##
#

#
# This routine is used to check and update both hosts and ethers files.
#
Update_Net_File(){
	[ ${#} -ne 4 ] && Fatal "Update_Net_File called with bad ARGC";
	[ -z "${1}" -o -z "${2}" -o -z "${3}" -o -z "${4}" ] && \
		Fatal "Update_Net_File() called with empty arg string.";
	E_FILE=${1}; E_HWAD=${2}; E_HOST=${3}; E_DOMN=${4};

	[ ! -r ${E_FILE} ] && Fatal "Cannot read: ${E_FILE}";
	cat ${E_FILE} | ${AWK} '
	BEGIN {	E_HOST		= "'"${E_HOST}"'";
		E_HWAD		= "'"${E_HWAD}"'";
		FULLMATCH	= 0 + 0;
		HOSTMATCH	= 0 + 0;
		HWADMATCH	= 0 + 0;
	}
	/^#/ || /^$/ { next; }
	$1 == E_HWAD && $2 == E_HOST {
		FULLMATCH++;
		next;
	}
	$1 == E_HWAD {
		HWADMATCH++;
		ADDRESS_A[HWADMATCH]	= $0;
		next;
	}
	$2 == E_HOST {
		HOSTMATCH++;
		HOSTNAME_A[HOSTMATCH]	= $0;
		next;
	}
	END {
		if (FULLMATCH == 1 && HWADMATCH == 0 && HOSTMATCH == 0) {
			exit 0;
		}
		if (FULLMATCH == 0 && HWADMATCH == 0 && HOSTMATCH == 0) {
			exit 1;
		}
		if (HWADMATCH > 0) {
			print "H/W Address already in use by different host" \
								| "cat >&2";
			for (i=1; i<=HWADMATCH; i++) {
				print ADDRESS_A[i]		| "cat >&2";
			}
		}
		if (HOSTMATCH > 0) {
			print "Hostname already in use with different MAC" \
								| "cat >&2";
			for (i=1; i<=HOSTMATCH; i++) {
				print HOSTNAME_A[i]		| "cat >&2";
			}
		}
		exit 2;
	}';

	case ${?} in
		0)	Totty "${E_FILE} entry already exists";
			YorN "Continue?";
			return 0;;

		1)	if [ "${E_DOMN}" != "NULL" -a \
				"${E_FILE}" = "${HOSTS}" ];	then
				E_HOST="${E_HOST} ${E_HOST}.${E_DOMN}";
			fi
			Write_Net_File ${E_FILE} "${E_HWAD}" "${E_HOST}";
			return ${?};;

		*)	Fatal "Please clean up ${E_FILE} and restart.";;

	esac
}

#
# This routine is used to write extra lines to the end of both hosts
# and ethers files.
#
Write_Net_File(){
	[ ${#} -ne 3 ] && Fatal "Write_Ethers() called with bad ARGC";
	[ -z "${1}" -o -z "${2}" -o -z "${3}" ] && \
		Fatal "Write_Net_File() called with empty arg string.";
	WE_FILE=${1}; WE_HWAD=${2}; WE_HOST=${3};

	[ ! -w ${WE_FILE} ] && Fatal "Cannot read: ${WE_FILE}";
	BackUp_File ${WE_FILE};
	[ ${?} -ne 0 ] && Fatal "Unable to make back-up copy: ${WE_FILE}";

	echo -e "${WE_HWAD}\t\t${WE_HOST}\t\t## Xterminal"	>> ${WE_FILE};
	[ ${?} -ne 0 ] && Fatal "Write to ${WE_FILE} failed. Check back-up.";

	return 0;
}	


#
# Check for hostname matches as either stand-alone entries or as part of
# a fully qualified host/domainname combination.
#
# The input, "GHN_FILE", is a line, or lines, grepped from the hosts file
# with matches of "GHN_HOST" embedded. The function checks the basic sanity
# of matching lines and puts informational results into the following
# environmental variables (for use by the caller):-
#
#   HOST_HITS			- Number of lines where hostname matches
#				  have been found.
#
#   HOST_HIT_1 ~ HOST_HIT_n	- The lines matched.
#
#   DOMN_HITS			- Number of lines where hostname/domainname
#				  clashes have been found.
#
#   DOMN_HIT_1 ~ DOMN_HIT_n	- The lines matched.
#
Grok_HName(){
	[ ${#} -ne 2 ] && Fatal "Grok_HName() called with bad ARGC";
	[ -z "${1}" -o -z "${2}" ] && \
		Fatal "Grok_HName() called with empty arg string";
	GHN_FILE=${1}; GHN_HOST=${2};

	eval `cat "${GHN_FILE}" | ${AWK} '
	BEGIN {	GHN_NAME	= "'"${GHN_HOST}"'";
		MATCH_CNT	= 0 + 0;
		DOMAIN_CNT	= 0 + 0;
	}
	/^#/ || /^$/ || NF < 2 { next; }
	{
		for (i=2; i<=NF; i++) {
			if (index($i, "#") == 1) {
				next;			## Ending comments.
			}
			if (GHN_NAME == $i) {
				MATCH_CNT++;
				HM_LINE[MATCH_CNT]	= $0;
				next;
			}
		}
		for (i=2; i<=NF; i++) {
			SF_CNT	= split($i, DOM_ARRAY, ".");
			if (SF_CNT < 2) {
				next;
			}
			if (GHN_NAME == DOM_ARRAY[1]) {
				print $0;
				MATCH_CNT++;
			}
			for (x=1; x<=SF_CNT; x++) {
				if (GHN_NAME == DOM_ARRAY[x]) {
					DOMAIN_CNT++;
					DOM_LINE[DOMAIN_CNT]	= $0;
				}
			}
		}
	}
	END {
		if (MATCH_CNT > 0) {
			printf("HOST_HITS=%d;\n", MATCH_CNT);
			for (i=1; i<=MATCH_CNT; i++) {
				printf("HOST_HIT_%d=\"%s\";\n", i, HM_LINE[i]);
			}
		}
		if (DOMAIN_CNT > 0) {
			printf("DOMN_HITS=%d;\n", DOMAIN_CNT);
			for (i=1; i<=DOMAIN_CNT; i++) {
				printf("DOMN_HIT_%d=\"%s\";\n", i, DOM_LINE[i]);
			}
		}
	}'`;
}

#
# Update the ARP/RARP tables with the new client information.
#
Run_RARP(){
	[ ${#} -ne 1 ] && Fatal "Run_RARP() called with bad ARGC.";
	[ -z "${1}" ] && Fatal "Run_RARP() called with empty arg string.";
	RR_FILE=${1};
	if [ ! -f /proc/net/rarp ];	then
		insmod rarp;
		if [ ${?} -ne 0 -o ! -f /proc/net/rarp ];	then
			cat >/dev/tty <<- EO_RARP

       The RARP table does not seem to exist and \"insmod rarp\" does
       not seem to work. Please check that a RARP module exists or
       recompile your kernel with RARP support.

			EO_RARP

			Fatal "Unable to populate RARP table";
		fi
	fi
	#
	# Re-adding an existing entry does not appear to hurt anything, so
	# we will work our way through the ethers file and add each entry.
	#		
	[ ! -r ${RR_FILE} ] && Fatal "${RR_FILE} is not readable.";
	cat ${RR_FILE} | ${AWK} '
	BEGIN {	ERR_CNT		= 0 + 0;
	}
	/^#/ || /^$/ || NF < 2 { next; }
	{
		RR_LINE	= sprintf("rarp -s %s %s\n", $2, $1);
		if (system(RR_LINE) != 0) {
			ERR_CNT++;
		}
		AR_LINE	= sprintf("arp -s %s %s\n", $2, $1);
		if (system(AR_LINE) != 0) {
			ERR_CNT++;
		}
	}
	END {
		exit ERR_CNT;
	}';
	if [ ${?} -ne 0 ];	then
		cat > /dev/tty <<- EO_RARPE

        Some of the hosts found in the ${ETHERS} file were not
        added for some reason. Please use the "arp -a " & "rarp -a" 
        commands to see which hosts are missing from the table. You
        might need to add them manually, using "(r)arp -s <HOSTNAME> <MAC>".

        Please see the manual pages for "arp" & "rarp" if you need more help.

		EO_RARPE
		return 2;
	fi
	return 0;
}

#
# Convert a decimal, dot-delimited IP address into a Hex string.
#
IP_ToHex(){
	[ ${#} -ne 1 -o -z "${1}" ] && Fatal "Bad argpassed to IP_ToHex().";
	DEC_IP=${1};

	for I in \
		`echo "${DEC_IP}" | ${AWK} -F. '{print $1, $2, $3, $4;}'`;
	do
		HEX_SEG=`echo -e "obase=16\n${I}\n" | bc`;
		[ ${?} -ne 0 -o -z "${HEX_SEG}" ] && \
			Fatal "Hex segment conversion failed.";
		#
		# Pad with leading zeros if needed. Note that the echo
		# statement below adds a newline character, so the count
		# is always one greater than you would expect.
		#
		SEG_CHARS=`echo "${HEX_SEG}" | wc -c | bc`;
		case ${SEG_CHARS} in
			2)	HEX_SEG="0${HEX_SEG}";;
			3)	;;
			*)	Fatal "Hex segment conversion failed.";;
		esac
		HEX_ADDR="${HEX_ADDR}${HEX_SEG}";
		HEX_SEG=;
	done
	HEX_IP="${HEX_ADDR}";
	return 0;
}

#
# Create the client links to the kernel file in the tftpboot directory
# to enable client boot.
#
# The format of the file is <HEX_IP_ADDRESS>.SUN<ARCH>, where the
# "ARCH" is an indicator of the client machine hardware architecture.
# Possible values are 3, 4, 4C, 4M, 4U, 4D. The kernels from Sun
# Microsystems are architecture specific, while Linux does the correct
# thing and is architecture independent. So, for Linux SPARC Xterminals
# we just need to create links using the "SUN4C" and "SUN4M" (anyone
# using one of the others needs their head examined... but is free to
# alter the code below to add the required links if they so desire).
#
Link_BootFile(){
	[ ${#} -ne 5 -o -z "${1}" -o -z "${2}" \
		-o -z "${3}" -o -z "${4}" -o -z "${5}" ] && \
		Fatal "Bad arg list passed to Link_BootFile().";
	LBF_BDIR=${1};
	LBF_HIP=${2};
	LBF_DIP=${3};
	LBF_KERN=${4};
	LBF_ROOT=${5};
	
	pushd ${LBF_BDIR} >/dev/null 2>&1;
	[ ${?} -ne 0 ] && Fatal "Could not \"cd\" to ${LBF_BDIR}.";

	#
	# Create link to tftp bootable kernel.
	#
	[ ! -f ${LBF_KERN} ] && \
		Fatal "Kernel file ${LBF_KERN} not found in ${LBF_BDIR}.";
	for LBF_ARCH in "SUN4C" "SUN4M";	do
		[ -L ./${LBF_HIP}.${LBF_ARCH} ] && continue;
		ln -s ./${LBF_KERN} "./${LBF_HIP}.${LBF_ARCH}";
		[ ${?} -ne 0 ] && \
			Error "Kernel link ${LBF_HIP}.${LBF_ARCH} failed.";
	done

	#
	# Create link to shared root filesystem.
	#
	[ ! -d ${LBF_ROOT} ] && Fatal "Missing client shared root filesystem.";
	if [ ! -L ./${LBF_DIP} ];	then
		ln -s ./${LBF_ROOT} ./${LBF_DIP};
		[ ${?} -ne 0 -o ! -L ./${LBF_DIP} ] && Fatal \
			"Failed to create link to shared root for: ${LBF_DIP}.";
	fi

	popd >/dev/null 2>&1;
	return 0;
}

#
# Put an entry in the Xservers file for the new client.
#
Update_Xservers(){
	[ ${#} -ne 2 -o -z "${1}" -o -z "${2}" ] && \
		Fatal "Bad args passed to Update_Xservers()";

	UX_FILE=${1};
	UX_HOST=${2};
	[ ! -w ${UX_FILE} ] && 
		Fatal "Cannot write to XDM control file: ${UX_FILE}.";
	
	#
	# This adds only the single, primary display name, "host:0", to
	# the servers file. Anyone with enough knowledge to run dual
	# headed should know enough to update the file manually.
	#
	UX_LINE="${UX_HOST}:0	foreign";
	BackUp_File ${UX_FILE};
	[ ${?} -ne 0 ] && Fatal "Unable to make back-up copy: ${UX_FILE}";
	echo "${UX_LINE}" >> ${UX_FILE};
	[ ${?} -ne 0 ] && Fatal "Update of ${UX_FILE} failed. Check backup.";

	return 0;
}

#
# Put an entry in the XDM config file for the new client.
#
Update_XDM(){
	[ ${#} -ne 5 -o -z "${1}" -o -z "${2}" \
		-o -z "${3}" -o -z "${4}" -o -z "${5}" ] && \
				Fatal "Bad args passed to Update_XDM()";

	UXD_CONFIG=${1};
	UXD_DIR=${2};
	UXD_HOST=${3};
	UXD_FILE=${4};
	UXD_DDOM=${5};
	[ ! -w ${UXD_CONFIG} ] && 
		Fatal "Cannot write to XDM config file: ${UXD_CONFIG}.";
	[ ! -w ${UXD_DIR} ] && Fatal "Unable to create files in: ${UXD_DIR}.";
	
	#
	# Update the config file to contain pointers to an Xsetup file
	# for the new terminal.
	#
	XDMNOD=`echo "DisplayManager.${UXD_HOST}_0.setup:"`;
	cat ${UXD_CONFIG} | egrep -wq "${XDMNOD}" >/dev/null 2>&1;
	RET_VAL=${?};
	case ${RET_VAL} in
		0)	Totty "XDM config entry exists. Skipping";
			return 0;;
		1)	;;
		*)	Error "Could not access ${XDM_CONFIG}. Please check.";
			return 2;;
	esac
	UXD_SETUP="${UXD_DIR}/${UXD_FILE}";
	BackUp_File ${UXD_CONFIG};
	[ ${?} -ne 0 ] && Fatal "Could not back-up: ${UXD_CONFIG}.";
	echo -e "${XDMNOD}\t${UXD_SETUP}"		>> ${UXD_CONFIG};
	[ ${?} -ne 0 ] && Fatal "Failed to update: ${UXD_CONFIG}.";

	#
	# If there is a DNS domainname (*not* NIS) part to the hostname, we
	# add another line using that, too.
	#
	if [ "${UXD_DDOM}" != "NULL" ];	then
		UXD_DDOM=`echo ".${UXD_DDOM}" | tr "." "_"`;
		XDMDOM=`echo "DisplayManager.${UXD_HOST}${UXD_DDOM}_0.setup:"`;
		echo -e "${XDMDOM}\t${UXD_SETUP}"	>> ${UXD_CONFIG};
		if [ ${?} -ne 0 ];	then
			Error "Failed to update: ${UXD_CONFIG}.";
			return 2;
		fi
	fi
	return 0;
}

Crt_Xsetup(){
	[ ${#} -ne 2 -o -z "${1}" -o -z "${2}" ] && \
			Fatal "Bad args passed to Crt_Xsetup().";
	CXS_FILE=${1};
	CXS_TEMPLATE=${2};

	if [ ! -s ${CXS_TEMPLATE} ];	then
		Error "Template file missing or empty: ${CXS_TEMPLATE}.";
		return 2;
	fi
	if [ -f ${CXS_FILE} ];	then
		diff ${CXS_TEMPLATE} ${CXS_FILE} >/dev/null 2>&1;
		if [ ${?} -ne 0 ];	then
			BackUp_File ${CXS_FILE};
			[ ${?} -ne 0 ] && \
				Fatal "Failed to back-up: ${CXS_FILE}.";
		fi
	fi
	cat ${CXS_TEMPLATE} > ${CXS_FILE};
	[ ${?} -ne 0 ] && Fatal "Failed to update file: ${CXS_FILE}.";

	chmod a+x ${CXS_FILE};
	return ${?};
}
