
#
# $Id: ._functions.sh,v 1.4 1998/01/12 12:33:01 root Exp $
#
# Do NOT remove this file or move it to a different location.
#
# This file contains common shell functions for use by the SPARC-Linux
# Xterminal package. It should not be executable. It should not start
# with "#!/bin/sh". It is sourced by the scripts which utilize the
# functions.
#
## 
## Copyright (c) 1997, 1998  John Little (gaijin@pobox.com)
## 
## Permission is hereby granted, free of charge, to any person obtaining a
## copy of this software and associated documentation files (the "Software"),
## to deal in the Software without restriction, including without limitation
## the rights to use, copy, modify, merge, publish, distribute, sublicense,
## and/or sell copies of the Software, and to permit persons to whom the
## Software is furnished to do so, subject to the following conditions:
## 
## The above copyright notice and this permission notice shall be included
## in all copies or substantial portions of the Software.
## 
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
## THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
## OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
## ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
## OTHER DEALINGS IN THE SOFTWARE.
##
#

#
# Simple output.
#
Totty(){
	tty -s;
	[ ${?} -ne 0 ] && exit 255;
	echo -e "\n\t${*}\n"				>/dev/tty;
}

Error(){
	Totty "\a${NAME:-SH}: ERROR - ${*}";
}

Fatal(){
	Error "${*}";
	exit 255;
}

YorN(){
	echo -en "\n\t${*} - Y/[N]: "			>/dev/tty;
	read YORN					</dev/tty;
	case ${YORN} in
		Y*|y*)	return 0;;
		*)	return 1;;
	esac
}

Restart(){
	[ ${#} -ne 1 -o -z "${1}" ] && Fatal "Bad arg passed to Restart().";
	YorN "Restart?";
	[ ${?} -eq 0 ] && exec ${PROGNAME};
}


#
# Check File Access.
#

#
# File Read/Write.
#
Check_RWA(){
	[ ! -f ${1} -o ! -r ${1} -o ! -w ${1} ] && return 1;
	return 0;
}

#
# Dir Read/Write Access.
#
Check_Dir(){
	[ ! -d ${1} -o ! -r ${1} -o ! -w ${1} ] && return 1;
	return 0;
}

#
# Identify the destination directory of a (possibly-multiple) link.
# Sets global LC_REAL variable to full pathname of real directory.
#
Link_Check(){
	[ ${#} -ne 1 -o -z "${1}" ] && Fatal "Bad arg passed to Link_Check().";
	LC_REAL=; LC_LINK=${1};
	pushd ${LC_LINK} >/dev/null 2>&1;
	[ ${?} -ne 0 ] && return 1;		## Non-existent or ordinary
	LC_TEMP=`/bin/pwd`;			## file and not directory.
	if [ ${?} -ne 0 -o -z "${LC_TEMP}" ];	then
		popd >/dev/null 2>&1;
		return 1;
	else
		LC_REAL=${LC_TEMP};		## Caller must use LC_REAL var.
		popd >/dev/null 2>&1;
		return 0;
	fi
}

#
# Make back-up copy of a file.
#
# If an original back-up copy already exists, and is larger than the 
# current version, assume that the extra information might be needed and
# move the larger, original back-up to a second back-up file.
#
# This is much messier than using SCCS/RCS, but past experience indicates
# that people are generally happier with something simple, even if it does
# leave "droppings". :-(
#
BackUp_File(){
	if [ ${#} -ne 1 ];	then
		 Error "Bad ARGC passed to BackUp_File()";
		 return 2;
	fi
	BU_FILE=${1}; BU_SUFF=".BAK"; BU_SUFF_1=".BAK_1";
	if [ ! -r ${BU_FILE} ];	then
		 Error "Cannot read: ${BU_FILE}";
		 return 2;
	fi
	if [ ! -w ${BU_FILE} ];	then
		 Error "Cannot write: ${BU_FILE}";
		 return 2;
	fi

	#
	# Check for existing back-ups.
	#
	if [ -s ${BU_FILE}${BU_SUFF} ];	then
		ORIG_SZ=`cat ${BU_FILE} | wc -c | bc`;
		[ ${?} -ne 0 ] && return 2;
		BUPC_SZ=`cat ${BU_FILE}${BU_SUFF} | wc -c | bc`;
		[ ${?} -ne 0 ] && return 2;
		if [ ${BUPC_SZ} -gt ${ORIG_SZ} ];	then
			cp ${BU_FILE}${BU_SUFF} ${BU_FILE}${BU_SUFF_1};
			[ ${?} -ne 0 ] && return 2;
		fi
	fi
	cp ${BU_FILE} ${BU_FILE}${BU_SUFF};
	[ ${?} -ne 0 ] && Fatal "Creation of back-up copy failed: ${BU_FILE}";

	return 0;
}

#
# Save original copy of a file. This function is used by the install
# procedure to save original copies of all files which are to be updated.
# In this case the copies are saved to <FILENAME>_<YEAR-MONTH-DAY>, just 
# in case the install is run again. If the install is run twice on the same
# day, nothing is done.
#
Save_Original(){
	if [ ${#} -ne 1 ];	then
		 Error "Bad ARGC passed to Save_Original()";
		 return 2;
	fi
	SO_FILE=${1};
	SO_SUFF=`date +%y%m%d`;
	[ ${?} -ne 0 -o -z "${SO_SUFF}" ] && \
		Fatal "Could not get save date for Save_Original().";
	if [ ! -r ${SO_FILE} ];	then
		 Error "Cannot read: ${SO_FILE}";
		 return 2;
	fi
	if [ ! -w ${SO_FILE} ];	then
		 Error "Cannot write: ${SO_FILE}";
		 return 2;
	fi

	#
	# Check for existing back-ups.
	#
	[ -s ${SO_FILE}_${SO_SUFF} ] && return 0;

	cp ${SO_FILE} ${SO_FILE}_${SO_SUFF};
	[ ${?} -ne 0 ] && Fatal \
		"Save of original failed: ${SO_FILE} to ${SO_FILE}_${SO_SUFF}";

	return 0;
}

#
# Check UID.
#
Check_UID(){
	USER_INFO=`id | cut -d= -f2 | cut -c1,3-6`;
	[ ${?} -ne 0  -o -z "${USER_INFO}" ] && \
			Fatal "Failed to get UID. Cannot continue.";
	[ "${USER_INFO}" != "0root" ] && \
			Fatal "Must be run as \"root\". Cannot continue.";
	return 0;
}

#
# Modify strings in a given file.
#
Mod_File(){
	[ ${#} -ne 3 -o -z "${1}" -o -z "${2}" -o -z "${3}" ] && \
					Fatal "Bad arg passed to Mod_File()";
	MF_TEMP=/tmp/${NAME}_MF.$$;
	MF_FILE=${1}; MF_ORIG="${2}"; MF_NEW="${3}";
	[ ! -r ${MF_FILE} ] && Fatal "Cannot read: ${MF_FILE}";
	trap "" 1 2 3 15;
	cat ${MF_FILE} | egrep "${MF_ORIG}"	>/dev/null 2>&1;
	case ${?} in
		0)	;;
		1)	trap 1 2 3 15; return 1;;
		2)	Fatal "Unable to check content: ${MF_FILE}.";;
	esac

	cp ${MF_FILE} ${MF_TEMP};
	[ ${?} -ne 0 -o ! -s ${MF_TEMP} ] && \
		Fatal "Unable to back-up ${MF_FILE} to ${MF_TEMP}.";
	ed -s ${MF_FILE} <<- EO_EDIT
		,s/${MF_ORIG}/${MF_NEW}/
		w
		q
	EO_EDIT
	if [ ${?} -ne 0 -o ! -s ${MF_FILE} ];	then
		Error "Could not modify file: ${MF_FILE}. Recovering original.";
		cp ${MF_TEMP} ${MF_FILE};
		if [ ${?} -ne 0 ];	then
			cat > /dev/tty <<- EO_MFMESS

        The attempted recovery of the file ${MF_FILE} has failed. Please
        copy the back-up copy of the original, ${MF_TEMP} back to 
        ${MF_FILE} manually and then restart ${NAME}.

			EO_MFMESS
			exit 255;
		fi
		trap 1 2 3 15; return 2;
	fi
	rm -f ${MF_TEMP};
	trap 1 2 3 15;
	return 0;
}

#
# Re-initialize a daemon.
#
Re_Init(){
	[ ${#} -ne 1 -o -z "${1}" ] && Fatal "Bad arg passed to Re_Init().";
	PROC_STRING="${1}";
	PROC_ID=`ps -ax | sort +0n | \
			egrep "${PROC_STRING}" | egrep -v grep | \
					head -1 | ${AWK} '{print $1}'`;

	if [ ${?} -ne 0 -o ${PROC_ID:-0} -lt 1 ];	then
		Error "Could not get PID of ${PROC_STRING} daemon.";
		return 2;
	elif [ ${PROC_ID} -lt 50 ];	then
		Error "<<WARNING>> Cannot kill PIDs lower than 50.";
		return 2;
	else
		kill -HUP ${PROC_ID};
		Totty "Re-initialized ${PROC_STRING} daemon.";
		return 0;
        fi
}

