#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <syslog.h>
#include <errno.h>
#include <pwd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>

#if defined(linux) && !defined(SIGHUP)
#define        SIGHUP          1       /* Hangup (POSIX).  */
#endif

#include "str.h"
#include "pset.h"

#include "options.h"

#include "attr.h"
#include "server.h"
#include "state.h"
#include "sconst.h"
#include "config.h"

#ifdef sun
#include <sys/signal.h>
#endif


#define READ_BUFFER 1500
#define WRITE_BUFFER 1500

/* Do the redirection of a service */
/* This function gets called from child.c after we have been forked */
void redir_handler( struct server *serp )
{
	struct service *sp = SERVER_SERVICE( serp );
	struct service_config *scp = SVC_CONF( sp );
	int descriptor = SERVER_FD( serp );
	char *adr;
	int serverfd, num_wrote=0, ret=0;
	struct sockaddr_in serveraddr;
	pid_t pid;
	
	adr = inet_ntoa(*scp->sc_redir_addr);

	/* If it's a tcp service we are redirecting */
	if( scp->sc_protocol.value == IPPROTO_TCP )
	{
		char *foo;
		serverfd = socket(AF_INET, SOCK_STREAM, 0);

		if( serverfd < 0 )
		{
			syslog(LOG_ERR, "redir_handler:socket: cannot create socket.\n");
			exit(0);
		}
		
		bzero(&serveraddr, sizeof(struct sockaddr_in));

		serveraddr.sin_family = AF_INET;
		serveraddr.sin_port = htons(scp->sc_redir_port);
		serveraddr.sin_addr.s_addr = scp->sc_redir_addr->s_addr;

		foo = inet_ntoa(serveraddr.sin_addr);
		
		if( connect(serverfd, (struct sockaddr *)&serveraddr, sizeof(struct sockaddr_in)) < 0 )
		{
			foo = inet_ntoa(serveraddr.sin_addr);
			syslog(LOG_ERR, "redir_handler:connect: can't connect to remote host %s\n", foo);
			exit(0);
		}

		/* connection now established */

		if( (pid = fork()) < 0 )
		{
			syslog(LOG_ERR, "redir_handler:fork: can't fork\n");
			exit(0);
		}

		if( pid == 0 )
		{
			char buff[READ_BUFFER];
			int num_read;
			/* I am the child */

			while( (num_read = read(serverfd, buff, READ_BUFFER)) > 0 )
			{
				num_wrote = 0;
				while( num_wrote < num_read )
				{
					ret = write(descriptor, buff+num_wrote, num_read-num_wrote);
					if( ret < 0 )
					{
						syslog(LOG_ERR, "redir_handler:write: %s\n", strerror(errno));
						exit(0);
					}
					num_wrote += ret;
				}
			}
			exit(0);
		}
		else
		{
			char buff[WRITE_BUFFER];
			int num_read;
			/* I am the parent */

			while( (num_read = read(descriptor, buff, WRITE_BUFFER)) > 0 )
			{
				/* write(serverfd, buff, num_read); */
				num_wrote = 0;
				while( num_wrote < num_read )
				{
					ret = write(serverfd, buff+num_wrote, num_read-num_wrote);
					if( ret < 0 )
					{
						syslog(LOG_ERR, "redir_handler:write: %s\n", strerror(errno));
						exit(0);
					}
					num_wrote += ret;
				}
			}

			kill(pid, SIGHUP);

		}
		wait(NULL);
		exit(0);
	}
	syslog(LOG_ERR, "redir_handler: redirect with any protocol other than tcp is not supported at this time.\n");
	exit(0);
}
