
/*

    File: rshproxy/rsh.h

    Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifndef	_RSH_INCLUDED
#define	_RSH_INCLUDED


extern char *program;
extern char progname[80];

extern int debug;
extern int numeric_only;
extern int extralog;

#define	RSH_CMDLEN		4096

#define	PORT_REXEC		512
#define	PORT_RLOGIN		513
#define	PORT_RSH		514

typedef struct _config {
    int		timeout;
    int		sourceport;

    int		wait_extra;
    int		xhack;
    char	xprg[200];
    int		vnchack;
    char	vncprg[200];

    int		selectserver;
    union {
	char	server[200];
	char	*serverlist;
	} u;

    char	acp[200];
    char	varname[80];
    } config_t;


#define	RSH_XWIN		1
#define	RSH_VNC			2

#define	RSH_STDINCLOSED		1
#define	RSH_STDOUTCLOSED	2
#define	RSH_STDERRCLOSED	4
#define	RSH_CLOSED		(RSH_STDINCLOSED | RSH_STDOUTCLOSED)

#define	RSH_NOEXTRA		0
#define	RSH_CLIENTFWD		1
#define	RSH_SERVERFWD		2

#define	RSH_LISTEN		1
#define	RSH_CONNECTED		2

typedef struct _port {
    int		sock;
    char	ipnum[80];
    unsigned int port;
    } port_t;

typedef struct _channel {
    int		type;
    int		state;		/* LISTEN oder CONNECTED */
    int		mode;		/* Client- oder Server-Forwarding */

    port_t	client;
    port_t	server;
    } channel_t;


typedef struct _rsh {
    config_t	*config;
    
    char	interface[80];
    unsigned int port;

    char	client[200];
    char	client_ip[80];

    struct {				/* Input received from client */
	char	client[80];		/* IP number */
	unsigned int port;		/* client port */

	int	stderrport, stderrsock;
	char	client_uname[80];

	char	username[80];
	char	password[80];
	char	command[RSH_CMDLEN + 2];
	} data;

    struct {				/* Proxy Authentication */
	char	username[80];
	char	password[80];
	} local;

    struct {
	char	localinterface[80];

	char	name[80];
	unsigned int port;

	char	ipnum[80];

	int	fd;
	int	stderrport, stderrsock;
	} server;

    int		rshstatus;
    int		use_extra;
    channel_t	extra;
    } rsh_t;


extern int proxy_request(config_t *config);

#endif

