
/*

    File: rshproxy/rexecd.h

    Copyright (C) 1999,2000  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifndef	_REXECD_INCLUDED
#define	_REXECD_INCLUDED


extern char *program;
extern char progname[80];

extern int debug;
extern int extralog;

#define	RSH_CMDLEN		4096

#define	PORT_REXEC		512
#define	PORT_RLOGIN		513
#define	PORT_RSH		514

typedef struct _config {
    int		timeout;
    int		sourceport;

    char	acp[200];
    char	varname[80];
    } config_t;


typedef struct _rexec {
    config_t	*config;
    
    char	interface[80];
    unsigned int port;

    char	client[200];
    char	client_ip[80];

    struct {				/* Input received from client */
	char	client[80];		/* IP number */
	unsigned int port;		/* client port */

	int	stderrport, stderrsock;
	char	client_uname[80];

	char	username[80];
	char	password[80];
	char	command[RSH_CMDLEN + 2];
	} data;

    struct {
	char	home[200];
	char	shell[80];
	unsigned int uid, gid;
	} user;
    } rexec_t;


#endif

