
/*

    File: rshproxy/rexec.c

    Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/stat.h>

#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>
#include <netdb.h>

#include "lib.h"


char	*program =		"";

int	timeout =		0;
int	askpw =			0;

char	*server =		"";
char	username[200] =		"";
char	password[200] =		"";
char	*command =		NULL;

char	home[200] =		"";

int	sfd =			-1;
int	efd =			-1;
int	zeroinput =		0;



char *get_userhome(char *dir, int size)
{
	struct passwd *pw;

	if ((pw = getpwuid(getuid())) == NULL) {
		fprintf (stderr, "%s: no such user, uid= %u\n", program, getuid());
		exit (-1);
		}

	copy_string(dir, pw->pw_dir, size);
	return (dir);
}

char *get_username(char *name, int size)
{
	struct passwd *pw;

	if ((pw = getpwuid(getuid())) == NULL) {
		fprintf (stderr, "%s: no such user, uid= %u\n", program, getuid());
		exit (-1);
		}

	copy_string(name, pw->pw_name, size);
	return (name);
}

char *get_password(char *filename, char *hostname, char *username, char *password, int size)
{
	int	is_user, is_server;
	char	*p, token[80], par[80], line[200];
	struct stat sbuf;
	FILE	*fp;

	*password = 0;
	if (stat(filename, &sbuf) != 0)
		return (0);
	else if ((sbuf.st_mode & 0x077) != 0) {
		fprintf (stderr, "%s: wrong permission on %s\n", program, filename);
		exit (1);
		}

	if ((fp = fopen(filename, "r")) == NULL) {
		fprintf (stderr, "%s: can't open %s\n", program, filename);
		exit (1);
		}

	is_server = is_user = 0;
	while (fgets(line, sizeof(line), fp) != NULL) {
		p = skip_ws(noctrl(line));
		if (*p == 0  ||  *p == '#')
			continue;

		get_word(&p, token, sizeof(token));
		get_word(&p, par, sizeof(par));
		if (strcmp(token, "machine") == 0) {
			is_server = (strcasecmp(par, hostname) == 0);
			continue;
			}

		if (is_server != 0) {
			if (strcmp(token, "login") == 0) {
				is_user = (strcmp(par, username) == 0);
				continue;
				}

			if (is_user != 0) {
				if (strcmp(token, "password") == 0) {
					copy_string(password, par, size);
					break;
					}
				}
			}
		}

	fclose (fp);
	return (password);
}


int add_fd(fd_set *set, int fd, int max)
{
	FD_SET(fd, set);
	if (fd > max)
		max = fd;

	return (max);
}

int spool(int sfd, int efd)
{
	int	max, rc, bytes;
	char	buffer[4096];
	struct timeval tov;
	fd_set	connection, available;


	FD_ZERO(&connection);
	max = add_fd(&connection, 0, 0);
	max = add_fd(&connection, sfd, max);
	max = add_fd(&connection, efd, max);

	while (1) {
		memmove(&available, &connection, sizeof(fd_set));
		tov.tv_sec  = timeout;
		tov.tv_usec = 0;

		rc = select(max + 1, &available, (fd_set *) NULL, (fd_set *) NULL,
				timeout > 0? &tov: NULL);
		if (rc < 0) {
			fprintf (stderr, "%s: select() error\n", program);
			exit (1);
			}
		else if (rc == 0) {
			fprintf (stderr, "%s: connection timed out\n", program);
			exit (1);
			}

		if (FD_ISSET(0, &available)) {
			if ((bytes = read(0, buffer, sizeof(buffer) - 2)) <= 0)
				shutdown(sfd, 1);
			else if (write(sfd, buffer, bytes) != bytes)
				break;
			}
			
		if (FD_ISSET(sfd, &available)) {
			if ((bytes = read(sfd, buffer, sizeof(buffer) - 2)) <= 0)
				break;
			else if (write(1, buffer, bytes) != bytes)
				break;
			}

		if (FD_ISSET(efd, &available)) {
			if ((bytes = read(efd, buffer, sizeof(buffer) - 2)) <= 0)
				break;
			else if (write(2, buffer, bytes) != bytes)
				break;
			}
		}

	return (0);
}


void missing_arg(int c, char *string)
{
	fprintf (stderr, "%s: missing arg: -%c, %s\n", program, c, string);
	exit (-1);
}

int main(int argc, char *argv[])
{
	int	c, i, k, cmdlen;
	char	*p, option[80];


	program = argv[0];

	k = 1;
	while (k < argc  &&  argv[k][0] == '-'  &&  argv[k][1] != 0) {
		copy_string(option, argv[k++], sizeof(option));
		for (i=1; (c = option[i]) != 0; i++) {
			if (c == 'a')
				askpw = 1;
			else if (c == 'l') {
				if (k >= argc)
					missing_arg(c, "username");

				copy_string(username, argv[k++], sizeof(username));
				}
			else if (c == 'p') {
				if (k >= argc)
					missing_arg(c, "password");

				copy_string(password, argv[k++], sizeof(password));
				}
			else if (c == 't') {
				if (k >= argc)
					missing_arg(c, "timeout");

				timeout = atoi(argv[k++]);
				}
			else {
				fprintf (stderr, "%s: unknown option: -%c\n", program, c);
				exit (-1);
				}
			}
		}


	if (k + 1 >= argc) {
		fprintf (stderr, "usage: %s [<options>] <host> <command> ...\n", program);
		exit (1);
		}

	server = argv[k++];
	cmdlen = 0;
	for (i=k; i<argc; i++) {
		cmdlen = cmdlen + 1 + strlen(argv[i]);
		}

	p = command = allocate(cmdlen + 10);
	for (i=k; i<argc; i++) {
		if (i > k)
			*p++ = ' ';

		strcpy(p, argv[i]);
		p += strlen(p);
		}

	*p = 0;
	noctrl(command);
	if (*command == 0) {
		fprintf (stderr, "%s: no command\n", program);
		exit (1);
		}


	get_userhome(home, sizeof(home));
	if (*username == 0)
		get_username(username, sizeof(username));

	if (askpw != 0) {
		if ((p = getpass("password: ")) != NULL)
			copy_string(password, p, sizeof(password));
		}
	else if (*password == 0) {
		char	netrc[200];

		snprintf (netrc, sizeof(netrc) - 2, "%s/.netrc", home);
		get_password(netrc, server, username, password, sizeof(password));
		}

	if (askpw != 0)
		/* nichts */ ;
	else if (strcmp(password, "-") == 0)
		*password = 0;
	else if (*password == 0) {
		if ((p = getpass("password: ")) != NULL)
			copy_string(password, p, sizeof(password));
		}


	sfd = efd = -1;
	sfd = rexec(&server, htons(512), username, password, command, &efd);
	if (sfd < 0) {
/*		fprintf (stderr, "%s: can't connect to server: %s\n", program, server); */
		exit(1);
		}
	else if (efd < 0) {
		fprintf (stderr, "%s: no stderr from server: %s\n", program, server);
		exit(1);
		}

	setuid(getuid());


	spool(sfd, efd);
	exit(0);
}

