/*
 *  This include file defines types and constants that are needed for
 *  the RARP client to work.  This is a prototype program that will be
 *  (hopefully) integrated into the ifconfig source to allow the 
 *  auto-revarp option similar to the SUN workstations.  This will allow
 *  Linux boxes to automatically get an IP address from a RARP host and
 *  assign it to the specified network device.
 *
 *  The types and contastants defined in this document have been taken
 *  directly from RFC 903.
 *
 *  History:
 *
 *  $Log$
 *
 */

#include <linux/if.h>
#include <linux/if_ether.h>

#define TIMEOUT_DFLT		10000000
#define RETRY_DFLT		10
#define MSE_TPN			0		/* Change if using on TPN */
#define RARP_HRD		0x0001
#define RARP_HLN		ETH_ALEN	/* 48 bit ethernet address length */
#define RARP_PLN		0x4		/* 32 bit internet address length */
#define RARP_PRO		0x0800		/* 2048: Ethertype of IP packets  */
#define	RARP_REQUEST_OPCODE	ARPOP_RREQUEST
#define RARP_RESPONSE_OPCODE	ARPOP_RREPLY
#define RARP_HEADER_SIZE	(2*RARP_HLN + 2*RARP_PLN + 8 + ETH_HLEN)


struct rarp_type {
	u_short    hardware_address_space; 		/* hrd */
	u_short    protocol_address_space; 		/* pro */
	u_char     hardware_address_length; 		/* hln */
	u_char	   protocol_address_length; 		/* pln */
	u_short	   opcode;				/* op */
	u_char	   source_hardware_address[RARP_HLN];	/* sha */
	u_char	   source_protocol_address[RARP_PLN];	/* spa */
	u_char	   target_hardware_address[RARP_HLN];	/* tha */
	u_char	   target_protocol_address[RARP_PLN];	/* tpa */
};



