sub register_service {
	my $service_type = shift;
	my $subtype = shift;
	my $function = shift;

	$service_tab{$service_type . '|' . $subtype} = $function;
}

sub call_service {
	my $service_type = shift;
	my $subtype = shift;
	my $func = $service_tab{$service_type . '|' . $subtype};

	if ($func) {
		&$func();
	} else {
		warn "unknown service type: $service_type/$subtype";
	}
}

sub register_acct {
	my $start_stop = shift;
	my $service_type = shift;
	my $subtype = shift;
	my $function = shift;

	$acct_tab{$start_stop . '|' . $service_type . '|' . $subtype} = $function;
}

sub call_acct {
	my $start_stop = shift;
	my $service_type = shift;
	my $subtype = shift;
	my $func = $acct_tab{$start_stop . '|' . $service_type . '|' . $subtype};

	if ($func) {
		&$func();
	} else {
		warn "unknown service type: $service_type/$subtype";
	}
}

1;
