#! /bin/sh

TCP_SERVER=./tcp_server
TCP_CLIENT=./tcp_client
UDP_TOOL=./udp_pipe
TCP_ADDR="localhost"
UDP_ADDR="localhost"
UDP_ADDR2="localhost"
TCP_PORT=2002
UDP_PORT=2002
UDP_PORT2=2003

TMP_FILE=/tmp/tmp1.$$

exec 2> /dev/null

TEST_1=true
TEST_2=true
TEST_3=true
TEST_4=true
TEST_5=true

if $TEST_1 ; then
	echo -n "Test #1: sending data from tcp_client to tcp_server... "
	$TCP_SERVER -a $TCP_ADDR -p $TCP_PORT -o > $TMP_FILE 2> /dev/tty &
	PID=$!
	sleep 1
	$TCP_CLIENT -i -a $TCP_ADDR -p $TCP_PORT < /etc/services 2> /dev/tty
	sleep 1
	kill -TERM $PID
	wait
	if diff /etc/services $TMP_FILE > /dev/null 2>&1 ; then
		echo "ok"
	else
		echo "error"
	fi
	rm -f $TMP_FILE
	sleep 2
fi

if $TEST_2 ; then
	echo -n "Test #2: sending data from tcp_server to tcp_client... "
	(sleep 3 ; cat /etc/services; sleep 1) | $TCP_SERVER -i -a $TCP_ADDR -p $TCP_PORT 2> /dev/tty &
	PID=$!
	sleep 1
	$TCP_CLIENT -o -a $TCP_ADDR -p $TCP_PORT > $TMP_FILE 2> /dev/tty
	sleep 1
	kill -TERM $PID
	wait
	if diff /etc/services $TMP_FILE > /dev/null 2>&1 ; then
		echo "ok"
	else
		echo "error"
	fi
#	rm -f $TMP_FILE
	sleep 2
fi

if $TEST_3 ; then
	echo -n "Test #3: execution of commands by server and client... "
	$TCP_SERVER -i -a $TCP_ADDR -p $TCP_PORT -e "cat /etc/services" 2> /dev/tty &
	PID=$!
	sleep 1
	$TCP_CLIENT -o -a $TCP_ADDR -p $TCP_PORT -e "cat > $TMP_FILE" 2> /dev/tty
	sleep 1
	kill -TERM $PID
	if diff /etc/services $TMP_FILE > /dev/null 2>&1 ; then
		echo "ok"
	else
		echo "error"
	fi
	rm -f $TMP_FILE
	sleep 2
fi

if $TEST_4 ; then
	echo -n "Test #4: execution of commands by server and client (reversed)... "
	$TCP_SERVER -o -a $TCP_ADDR -p $TCP_PORT -e "cat > $TMP_FILE" 2> /dev/tty &
	PID=$!
	sleep 1
	$TCP_CLIENT -i -a $TCP_ADDR -p $TCP_PORT -e "cat /etc/services" 2> /dev/tty
	sleep 1
	kill -TERM $PID
	if diff /etc/services $TMP_FILE > /dev/null 2>&1 ; then
		echo "ok"
	else
		echo "error"
	fi
	rm -f $TMP_FILE
	sleep 2
fi

if $TEST_5 ; then
	echo -n "Test #5: sending data from udp_tool to udp_tool... "
	$UDP_TOOL -o -A $UDP_ADDR -P $UDP_PORT  2> /dev/tty > $TMP_FILE &
	PID=$!
	sleep 1
	$UDP_TOOL -i -a $UDP_ADDR -p $UDP_PORT  2> /dev/tty < /etc/services
	sleep 1
	kill -TERM $PID
	if diff /etc/services $TMP_FILE > /dev/null 2>&1 ; then
		echo "ok"
	else
		echo "error"
	fi
	rm -f $TMP_FILE
	sleep 2
fi

echo "end of tests"
