/************************************************************************\
**  netpipe.c                                                           **
**                                                                      **
**  Copyright (c) 2001 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	#include "config.h"

	#include <netdb.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <arpa/inet.h>
	#include <sys/socket.h>

	#include "netpipe.h"

	int
give_ip_address	(char * hostname, struct in_addr * result)
{
	struct hostent *	host;
	if (hostname == NULL) {
		result -> s_addr = htonl (INADDR_ANY);
		return (0);
	} else {
#ifdef HAVE_INET_ATON
		if (inet_aton (hostname, result) == 0) {
#else
		if ((result -> s_addr = inet_addr (hostname)) == -1) {
#endif
			if ((host = gethostbyname (hostname)) == NULL)
				return (-1);
			result -> s_addr = ((struct in_addr *) (* host -> h_addr_list)) -> s_addr;
		}
	}
	return (0);
}


	int
give_port_number (char * portname, char * protocol)
{
	struct servent * serv;	
	if ((serv = getservbyname (portname, protocol)) != NULL)
		return (serv -> s_port);
	return (htons (atoi (portname)));
}	
