#include <sys/types.h>
#include "system.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include <netinet/in.h>

float oldtmppercent = 0;

void status (int e, int sp, int ep, time_t t1, int tp, int randorder);

void
portscan (char h[], int sp, int ep, int showstatus, int known, int randorder)
{

  int e = sp, q, s, max, Err;
  int x;
  int tp = (ep - sp + 1);
  int Len = sizeof (Err);
  int maxsockets = 25;
  int sock[maxsockets];
  int busy[maxsockets];
  int port[maxsockets];
  int tries[maxsockets];
  int busysockets = 0;
  int *randports;

  struct servent *tec;
  struct sockaddr_in addr;
  struct timeval tv;
  time_t t1;
  fd_set cfds;

  randports = (int *) malloc (tp * sizeof (int));
  srand (time (NULL));
  for (q = 0; q < maxsockets; q++)
    {
      tries[q] = 0;
      busy[q] = 0;
    }
  if (randorder == 1)
    for (x = 0; x < tp; x++)
      randports[x] = (sp + x);
  (void) time (&t1);
  while (busysockets || e <= ep)
    {
      for (q = 0; q < maxsockets; q++)
	{
	  if (known == 1)
	    {
	      for (; e <= ep; e++)
		if (getservbyport (htons (e), "tcp") != NULL)
		  break;
	    }
	  if (busy[q] == 0 && e <= ep)
	    {
	      sock[q] = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
	      busysockets++;
	      if (sock[q] < 0)
		{
		  printf ("ERROR: socket() failed\n");
		  exit (0);
		}
	      addr.sin_family = AF_INET;
	      if (randorder == 1)
		{
		  int i;
		  while (1)
		    {
		      x = rand () % tp;
		      addr.sin_port = htons (randports[x]);
		      port[q] = randports[x];
		      for (i = x; i < tp; i++)
			randports[i] = randports[i + 1];
		      tp--;
		      if (tp)
			randports =
			  (int *) realloc (randports, (tp * sizeof (int)));

		      if (known == 1)
			{
			  if (getservbyport (htons (port[q]), "tcp") != NULL)
			    break;
			}
		      else
			break;
		    }
		}
	      else
		addr.sin_port = htons (e);
	      addr.sin_addr.s_addr = inet_addr (h);
	      fcntl (sock[q], F_SETFL, O_NONBLOCK);
	      if (showstatus == 1)
		status (e, sp, ep, t1, tp, randorder);
	      s = connect (sock[q], (struct sockaddr *) &addr, sizeof (addr));
	      if (errno != EINPROGRESS)
		{
		  close (sock[q]);
		  busysockets--;
		}
	      else
		{
		  busy[q] = 1;
		  if (randorder != 1)
		    port[q] = e;
		}
	      e++;

	    }
	}
      if (showstatus == 1)
	status (e, sp, ep, t1, tp, randorder);
      FD_ZERO (&cfds);
      max = 0;
      for (q = 0; q < maxsockets; q++)
	{
	  if (busy[q] == 1)
	    {
	      FD_SET (sock[q], &cfds);
	      if (max < sock[q])
		max = sock[q];
	    }
	}
      tv.tv_sec = 5;
      tv.tv_usec = 0;
      s = select (max + 1, NULL, &cfds, NULL, &tv);
      for (q = 0; q < maxsockets; q++)
	{
	  if (busy[q] == 1)
	    {
	      if (FD_ISSET (sock[q], &cfds))
		{
		  getsockopt (sock[q], SOL_SOCKET, SO_ERROR, &Err, &Len);
		  if (Err == 0)
		    {
		      tec = getservbyport (htons (port[q]), "tcp");
		      printf
			("%s:%d (%s) is open                                         \n",
			 h, port[q], (tec == NULL) ? "UNKNOWN" : tec->s_name);

		    }
		  busy[q] = 0;
		  tries[q] = 0;
		  close (sock[q]);
		  busysockets--;
		}
	      else
		{
		  if (tries[q] == 40)
		    {
		      busy[q] = 0;
		      tries[q] = 0;
		      close (sock[q]);
		      busysockets--;
		    }
		  else
		    tries[q]++;
		}
	      if (showstatus == 1)
		status (e, sp, ep, t1, tp, randorder);
	    }
	}
    }
}

void
status (int e, int sp, int ep, time_t t1, int tp, int randorder)
{
  time_t t2;
  float tmppercent, tmpe, tmpep;
  int percent, timeleft = 0;
  if (randorder == 1)
    tmpe = (ep - sp + 1 - tp);
  else
    tmpe = (e - sp);
  tmpep = (ep - sp + 1);
  tmppercent = tmpe / tmpep;
  percent = tmppercent * 100;

  if (oldtmppercent < tmppercent)
    {
      (void) time (&t2);
      if (percent != 0)
	timeleft =
	  ((float) ((float) t2 - t1) / percent) * (100 - percent) + 0.99;
      printf
	("%d percent done, estimated time left: %d sec\r", percent, timeleft);
      oldtmppercent = tmppercent;
    }
}
