/*
   multiscan - A tcp port scanner for console

   Copyright (C) 2000 Karl Sderstrm

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include "system.h"
#include <syscall.h>
#include <netdb.h>
#include <netinet/in.h>

#define EXIT_FAILURE 1
#define PORT_LIMIT 1024

char *xmalloc ();
char *xrealloc ();
char *xstrdup ();

int x;
int showstatus = 0;
int known = 0;
int randorder, startp = 1, endp = 1024;
char *target;
struct sockaddr_in addr;
char rhost[100];
int optind;
char *optarg;

static void usage (int status);
void portscan (char h[], int sp, int ep, int showstatus, int known,
	       int randorder);


/* The name the program was run with, stripped of any leading path. */
char *program_name;

/* getopt_long return codes */
enum
{ DUMMY_CODE = 129
};

/* Option flags and variables */


static struct option const long_options[] = {
  {"help", no_argument, 0, 'h'},
  {"version", no_argument, 0, 'V'},
  {"status", no_argument, 0, 'S'},
  {"known", no_argument, 0, 'k'},
  {"random", no_argument, 0, 'r'},
  {"target", 1, 0, 't'},
  {"start", 1, 0, 's'},
  {"end", 1, 0, 'e'},
  {NULL, 0, NULL, 0}
};

static int decode_switches (int argc, char **argv);

int
main (int argc, char **argv)
{
  int i;
  int a, b, c, d, q, aa, ch;
  struct hostent *nuk;
  char commandLine[256];
  program_name = argv[0];

  i = decode_switches (argc, argv);

  if (sscanf (target, "%d.%d.%d.%d", &a, &b, &c, &d) != 4)
    {
      nuk = gethostbyname (target);
      if (nuk == NULL)
	{
	  printf ("ERROR: cannot resolve host %s\n", target);
	  exit (2);
	}
      sprintf (rhost, "%d.%d.%d.%d", (unsigned char) nuk->h_addr_list[0][0],
	       (unsigned char) nuk->h_addr_list[0][1],
	       (unsigned char) nuk->h_addr_list[0][2],
	       (unsigned char) nuk->h_addr_list[0][3]);
    }
  else if (sscanf (target, "%d.%d.%d.%d-%d", &a, &b, &c, &d, &aa) == 5)
    {
      for (q = d; q <= aa; q++)
	{
	  sprintf (rhost, "%d.%d.%d.%d", a, b, c, q);
	  sprintf (commandLine, "ping -c1 %s &>/dev/null", rhost);
	  if (system (commandLine))
	    {
	      printf ("\nDestination host unreachable (%s)\n", rhost);
	    }
	  else
	    {
	      if (known == 1)
		printf
		  ("\nScanning %s - Ports %d through %d (known ports)\n",
		   rhost, startp, endp);
	      else
		printf ("\nScanning %s - Ports %d through %d\n", rhost,
			startp, endp);

	      portscan (rhost, startp, endp, showstatus, known, randorder);
	      printf ("\n");
	    }
	}
      exit (0);
    }
  else
    {
      strncpy (rhost, target, 99);
    }
  sprintf (commandLine, "ping -c1 %s &>/dev/null", rhost);
  if (system (commandLine))
    {
      printf ("\nDestination host unreachable (%s)\n", rhost);
    }
  else
    {
      if (known == 1)
	printf ("\nScanning %s - Ports %d through %d (known ports)\n",
		rhost, startp, endp);
      else
	printf ("\nScanning %s - Ports %d through %d\n", rhost, startp, endp);

      portscan (rhost, startp, endp, showstatus, known, randorder);
      printf ("\n");
    }
  exit (0);
}

/* Set all the option flags according to the switches specified.
   Return the index of the first non-option argument.  */

static int
decode_switches (int argc, char **argv)
{
  int c;
  if (argc < 2)
    usage (0);
  while ((c = getopt_long (argc, argv,
			   "hVSkrt:s:e:", long_options, (int *) 0)) != EOF)
    {
      switch (c)
	{
	default:
	  usage (0);
	case 'V':
	  printf ("multiscan %s\n", VERSION);
	  exit (0);

	case 'h':
	  usage (0);

	case 'e':
	  endp = atoi (optarg);
	  break;

	case 'k':
	  known = 1;
	  break;

	case 'r':
	  randorder = 1;
	  break;

	case 'S':
	  showstatus = 1;
	  break;

	case 's':
	  startp = atoi (optarg);
	  break;

	case 't':
	  target = optarg;
	  break;
	}
    }
  return optind;
}


static void
usage (int status)
{
  printf (_("%s - \
A tcp port scanner for console\n"), program_name);
  printf (_("Usage: %s [OPTION]...\n"), program_name);
  printf (_("\
Options:\n\
  -h, --help                 display this help and exit\n\
  -V, --version              output version information and exit\n\
  -t, --target               Target host/range\n\
  -s, --start                Start port (Default: 1)\n\
  -e, --end                  End port (Default: 1024)\n\
  -k, --known                Only scan known ports (from /etc/services)\n\
  -r, --random               Scan ports in random order\n\
  -S, --status               Show statusline\n\
"));
  exit (status);
}
