#include <ncurses/curses.h>
#include <masq.h>

void drawscreen(sendmasq *m1)
{
   WINDOW *popwin;

   halfdelay(10);
   noecho();
   keypad(m1->winhandle,TRUE);

   wborder(m1->winhandle,0,0,0,0,0,0,0,0);
   mvwprintw(m1->winhandle,1,2,"F1 = Insert Record");
   mvwprintw(m1->winhandle,2,2,"F2 = Delete Record");
   mvwprintw(m1->winhandle,1,m1->COLUMNS-20,"F4 = Exit");
   mvwprintw(m1->winhandle,2,m1->COLUMNS-20,"Select = Arrow Keys");
   mvwprintw(m1->winhandle,1,(m1->COLUMNS/2)-9,"F3 = Insert DataBase");
   mvwprintw(m1->winhandle,2,(m1->COLUMNS/2)-9," C = Change DataBase");
   wmove(m1->winhandle,3,1);
   whline(m1->winhandle,0,m1->COLUMNS-2);
   wmove(m1->winhandle,3,(m1->COLUMNS/2)-2);
   wvline(m1->winhandle,ACS_TTEE,1);
   mvwprintw(m1->winhandle,4,2,"Prtcl");
   mvwprintw(m1->winhandle,4,10,"Source Address");
   mvwprintw(m1->winhandle,4,31,"Port");
   mvwprintw(m1->winhandle,4,m1->COLUMNS/2,"Destination Address");
   mvwprintw(m1->winhandle,4,m1->COLUMNS/2+25,"Port");
   wmove(m1->winhandle,5,1);
   whline(m1->winhandle,0,m1->COLUMNS-2);
   wmove(m1->winhandle,4,(m1->COLUMNS/2)-2);
   wvline(m1->winhandle,0,m1->LINES-5);
   wmove(m1->winhandle,5,(m1->COLUMNS/2)-2);
   wvline(m1->winhandle,ACS_PLUS,1);
   wmove(m1->winhandle,m1->LINES-1,(m1->COLUMNS/2)-2);
   wvline(m1->winhandle,ACS_BTEE,1);
   return;
}

int choice(char *strng,int LINES, int COLUMNS, int validkeys, WINDOW *winhandle)
{
   WINDOW *popwin;
   int leave=0;
   int key;


   popwin=subwin(winhandle,3,strlen(strng)+4,(LINES/2)-1,(COLUMNS/2)-((strlen(strng)+4)/2));
   syncok(popwin,TRUE);
   wclear(popwin);
   wborder(popwin,0,0,0,0,0,0,0,0);
   mvwprintw(popwin,1,2,strng);
   while (!leave)
   {
      key=getch();
      // Keys H and N
      if (validkeys == 1)
      {
         if (key == 72)
            leave=1;
         if (key == 78)
            leave=2;
         if (key == 104)
            leave=1;
         if (key == 110)
            leave=2;
      }
      // Keys Y and N
      if (validkeys == 2)
      {
         if (key == 89)
            leave=1;
         if (key == 78)
            leave=2;
         if (key == 121)
            leave=1;
         if (key == 110)
            leave=2;
      }
      // Keys A and U
      if (validkeys == 3)
      {
         if (key == 65)
            leave=1;
         if (key == 85)
            leave=2;
         if (key == 97)
            leave=1;
         if (key == 117)
            leave=2;
      }
      // Keys A T, and U
      if (validkeys == 4)
      {
         if (key == 65)
            leave=1;
         if (key == 84)
            leave=2;
         if (key == 85)
            leave=3;
         if (key == 97)
            leave=1;
         if (key == 116)
            leave=2;
         if (key == 117)
            leave=3;
      }
   }
   wclear(popwin);
   delwin(popwin);
   return leave;
}
