#include <stdio.h>
#include <stdlib.h>
#include <ncurses/curses.h>
#include <msql.h>
#include <masq.h>


int trunkreaddata( sendmasq *m1)
{
   int      Counter;
   int      msqlSocket;
   int      record_num=0;
   char     msqlHOST[128];
   char     DBname[128];
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return -1;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   sprintf(sqlCommand,"select distinct protocol,source,source_mask,source_port from %s order by source, source_mask, source_port",m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   result=msqlStoreResult();
   m1->totalhosts=msqlNumRows(result);

   if ((m1->f1current>-(m1->LINES-8)) > 0 && m1->totalhosts-(m1->f1current-(m1->LINES-8)) > 0)
      for (Counter=1;Counter <= (m1->f1current-(m1->LINES-8));Counter++)
      {
         msqlRow=msqlFetchRow(result);
         record_num++;
      }
   for (Counter=0;Counter <= (m1->LINES-8);Counter++)
   {
      mvwprintw(m1->winhandle,Counter+6,2,"%s","   ");
      mvwprintw(m1->winhandle,Counter+6,9,"                  ");
      mvwprintw(m1->winhandle,Counter+6,30,"     ");
   }

   Counter=0;
   while ( Counter <= (m1->LINES-8) && (msqlRow=msqlFetchRow(result)) )
   {

      if (m1->f1current == (Counter+record_num))
      {
         strcpy(m1->currentsrcprot,msqlRow[0]);
         strcpy(m1->currentsrcaddr,msqlRow[1]);
         strcpy(m1->currentsrcmask,msqlRow[2]);
         m1->currentsrcport=atoi(msqlRow[3]);
         wattron(m1->winhandle,A_REVERSE);
      }
      else
         wattroff(m1->winhandle,A_REVERSE);


      mvwprintw(m1->winhandle,Counter+6,2,"%s",msqlRow[0]);

      if ( (strcmp("0.0.0.0",msqlRow[1])==0) && (strcmp("0.0.0.0",msqlRow[2])==0) )
         mvwprintw(m1->winhandle,Counter+6,9,"Anywhere");
      else
      {
         mvwprintw(m1->winhandle,Counter+6,9,"%s",msqlRow[1]);
         if ( strcmp(msqlRow[2],"(null)") !=0 )
            mvwprintw(m1->winhandle,Counter+6,9+strlen(msqlRow[1]),"/%i",masking(msqlRow[2]));
      }
      
      if ( atoi(msqlRow[3]) == -1 )
         mvwprintw(m1->winhandle,Counter+6,30,"all");
      else
         mvwprintw(m1->winhandle,Counter+6,30,"%s",msqlRow[3]);

      Counter++;
   }
   msqlFreeResult(result);
   msqlClose(msqlSocket);
   wattroff(m1->winhandle,A_REVERSE);
   return 0;
}
int branchread(sendmasq *m1)
{
   int      Counter;
   int      msqlSocket;
   int      record_num=0;
   char     msqlHOST[128];
   char     DBname[128];
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return -1;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   sprintf(sqlCommand,"select dest,dest_mask,dest_port from %s where protocol='%s' and source='%s' and source_mask='%s' and source_port=%i order by dest,dest_mask,dest_port",m1->DBname,m1->currentsrcprot,m1->currentsrcaddr,m1->currentsrcmask,m1->currentsrcport);

   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   result=msqlStoreResult();
   m1->desthosts=msqlNumRows(result);

   if ((m1->f2current>-(m1->LINES-8)) > 0 && m1->desthosts-(m1->f2current-(m1->LINES-8)) > 0)
      for (Counter=1;Counter <= (m1->f2current-(m1->LINES-8));Counter++)
      {
         msqlRow=msqlFetchRow(result);
         record_num++;
      }
   for (Counter=0; Counter <= (m1->LINES-8) ; Counter++)
   {
      mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+25,"     ");
      mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+1,"                  ");
   }
 
   Counter=0;  
   while ( Counter <= (m1->LINES-8) && (msqlRow=msqlFetchRow(result)) )
   {
      if (m1->frame == 2)
      {
         if (m1->f2current == (Counter+record_num))
         {
            strcpy(m1->dest,msqlRow[0]);
            strcpy(m1->dest_mask,msqlRow[1]);
            m1->dest_port=atoi(msqlRow[2]);
            wattron(m1->winhandle,A_REVERSE);
         }
         else
            wattroff(m1->winhandle,A_REVERSE);
      }
      else
         wattroff(m1->winhandle,A_REVERSE);


      if ( (strcmp("0.0.0.0",msqlRow[0])==0) && (strcmp("0.0.0.0",msqlRow[1])==0) )
         mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+1,"Anywhere");
      else
      {
         mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+1,"%s",msqlRow[0]);
         if ( strcmp(msqlRow[1],"(null)") !=0 )
            mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+1+strlen(msqlRow[0]),"/%i",masking(msqlRow[1]));
      }
      if (atoi(msqlRow[2]) == -1)
         mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+25,"all");
      else
         mvwprintw(m1->winhandle,Counter+6,(m1->COLUMNS/2)+25,"%s",msqlRow[2]);
         
      Counter++;
   }
   msqlFreeResult(result);
   msqlClose(msqlSocket);
   wattroff(m1->winhandle,A_REVERSE);
   return 0;
}
