#include <msql.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef server
#include <masq.h>
#endif
#ifdef client
#include <ncurses/curses.h>
#include <masq.h>

int insertrec(sendmasq *m1)
{
   int      msqlSocket;
   int      record_num;
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return -1;


   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   sprintf(sqlCommand,"select * from %s order by record_num",m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   result=msqlStoreResult();
   record_num=msqlNumRows(result);
   if (record_num != 0)
   {
      msqlDataSeek(result,record_num-1);
      msqlRow=msqlFetchRow(result);
      record_num=atoi(msqlRow[0])+1;
   }

   sprintf(sqlCommand,"insert into %s ( record_num, protocol, source, source_mask, source_port, dest, dest_mask, dest_port) values( %i,'%s','%s','%s',%i,'%s','%s',%i)",m1->DBname,
                        record_num,
                        m1->currentsrcprot,
                        m1->currentsrcaddr,
                        m1->currentsrcmask,
                        m1->currentsrcport,
                        m1->dest,
                        m1->dest_mask,
                        m1->dest_port);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   msqlFreeResult(result);
   msqlClose(msqlSocket);
   return 1;
}

int deleterec(sendmasq *m1)
{
   int      msqlSocket;
   char     sqlCommand[256];
   m_result *result;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return -1;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   if (m1->frame == 1)
      sprintf(sqlCommand,"delete from %s where protocol='%s' and source='%s' and source_mask='%s' and source_port=%i ",m1->DBname,m1->currentsrcprot,m1->currentsrcaddr,m1->currentsrcmask,m1->currentsrcport);
   else
      sprintf(sqlCommand,"delete from %s where protocol='%s' and source='%s' and source_mask='%s' and source_port=%i and dest='%s' and dest_mask='%s' and dest_port=%i",m1->DBname,m1->currentsrcprot,m1->currentsrcaddr,m1->currentsrcmask,m1->currentsrcport,m1->dest,m1->dest_mask,m1->dest_port);
        
   if (msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }
   msqlClose(msqlSocket);
   return 1; 
}
void selecthost(sendmasq *m1)
{
   int      msqlSocket;
   int      record_num;
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return;


   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return;
   }

   result=msqlListTables(msqlSocket);

   if (msqlNumRows(result) == 0)
   {
      msqlQuery(msqlSocket,"create table hosts(name char(64) primary key,port int, dbname char(64))");
      msqlClose(msqlSocket);
      msqlFreeResult(result);
      createdb(m1);
      return;
   }
   hostmasqd(m1);
}

void createdb(sendmasq *m1)
{
   int      msqlSocket;
   int      record_num;
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return;
   }

   hostmasqd(m1);
   hostport(m1);
   sprintf(sqlCommand,"insert into hosts values( '%s',%i,'%s')",m1->hostmasqd
                                                               ,m1->hostport
                                                               ,m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return;
   }
   sprintf(sqlCommand,"create table %s ( record_num int primary key,protocol char(4),source char(15) not null,source_mask char(15),source_port int,dest char(15) not null,dest_mask char(15),dest_port int )",m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return;
   }
   msqlClose(msqlSocket);
}
#endif
void createfile(sendmasq *m1)
{
   int      msqlSocket;
   char     text[256];
   char     srcmsk[16];
   char     srcprt[16];
   char     dstmsk[16];
   char     dstprt[16];
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;
   FILE     *masq;


   masq=fopen(m1->masq_file,"w+");
   fprintf(masq,"ipfwadm -F -f\n");

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return;
   }

   sprintf(sqlCommand,"select * from %s order by source, source_mask, source_port, protocol",m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return;
   }

   result=msqlStoreResult();

   while ( (msqlRow=msqlFetchRow(result)) )
   {
      if (strcmp(msqlRow[3],"(null)") == 0)
         strcpy(srcmsk," ");
      else
         sprintf(srcmsk,"/%s ",msqlRow[3]);

      if (atoi(msqlRow[4]) == -1)
         strcpy(srcprt," ");
      else
         sprintf(srcprt,"%s ",msqlRow[4]);

      if (strcmp(msqlRow[6],"(null)") == 0)
         strcpy(dstmsk," ");
      else
         sprintf(dstmsk,"/%s ",msqlRow[6]);

      if (atoi(msqlRow[7]) == -1)
         strcpy(dstprt," ");
      else
         sprintf(dstprt,"%s ",msqlRow[7]);

      sprintf(text,"%s -S %s%s%s-D %s%s%s",msqlRow[1],msqlRow[2],srcmsk,srcprt,msqlRow[5],dstmsk,dstprt);
      fprintf(masq,"ipfwadm -F -a masq -P %s\n",text);
   }
   fclose(masq);
   msqlFreeResult(result);
   msqlClose(msqlSocket);
}
