#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <ncurses/curses.h>
#include <masq.h>
#include <unistd.h>

int main (int c,char **v)
{
   extern   char msqlErrMsg[];
   int      leave=1, key;
   sendmasq m1;

   bzero(&m1.msqlHOST,sizeof(m1.msqlHOST));
   bzero(&m1.DBname,sizeof(m1.DBname));

   if (c==2)
      strcpy(m1.msqlHOST,v[1]);

   if (c>2)
   {
      printf("Usage: masqtool [<msqlHOST>]\n");
      exit(1);
   }

   if ( ! getenv("LINES") || ! getenv("COLUMNS") )
   {
      system("export LINES");
      system("export COLUMNS");
      m1.LINES=24;
      m1.COLUMNS=80;
      printf("\n\nExport LINES and COLUMNS\n");
      printf("for larger screens.\n\n\n\n");

      printf("Press any key to start with\n");
      printf("Default 24 x 80 screen\n");
      while (!getc(stdin));
      
   }
   else
   {
      m1.LINES=atoi(getenv("LINES"));
      m1.COLUMNS=atoi(getenv("COLUMNS"));
   }

   m1.winhandle=initscr();
   drawscreen(&m1);
   m1.currentsrcaddr[0]=0;
   m1.f1current=0;


   if (c != 3)
   {
      selecthost(&m1);
      drawscreen(&m1);
   }


   trunkreaddata(&m1);
   if ( branchread(&m1) == -1)
      errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);

   while (leave)
   {
      key=getch();
      if ( key == KEY_UP )
      {
         if ( m1.f1current > 0 )
            m1.f1current--;
         wrefresh(m1.winhandle);
         m1.frame=1;
      }
      if ( key == KEY_DOWN )
      {
         if ( m1.f1current < m1.totalhosts-1 )
            m1.f1current++;
         wrefresh(m1.winhandle);
         m1.frame=1;
      }
      if ( key == KEY_RIGHT )
      {
         m1.frame=2;
         m1.f2current=0;
         while ( key != KEY_LEFT )
         {
            drawscreen(&m1);
            trunkreaddata(&m1);
            if ( branchread(&m1) == -1)
               errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);
            wrefresh(m1.winhandle);
            key=getch();
            if ( key == KEY_UP )
            {
               if ( m1.f2current > 0 )
               {
                  m1.f2current--;
                  m1.frame=2;
               }
            }
            if ( key == KEY_DOWN )
            {
               if ( m1.f2current < m1.desthosts-1 )
               {
                  m1.f2current++;
                  m1.frame=2;
               }
            }
            if ( key == KEY_F(1) || key == KEY_IC)
            {
               if (choice("Destination: Host or Network (H/N): ",m1.LINES, m1.COLUMNS,1,m1.winhandle) == 1)
               {
                  dest(&m1,1);
                  strcpy(m1.dest_mask,"(null)");
               }
               else
               {
                  dest(&m1,2);
                  dest_mask(&m1);
               }
               if (strcmp(m1.currentsrcprot,"all") == 0)
                  m1.dest_port=-1;
               else
                  dest_port(&m1);

               if (insertrec(&m1) == -1)
                     errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);

               m1.frame=2;
            }
            if ((key == KEY_F(2) || key == KEY_DC))
            {
               m1.frame=2;
               if (choice("Delete Record (Y/N): ",m1.LINES,m1.COLUMNS,2,m1.winhandle) == 1)
               {
                  if ( deleterec(&m1) == -1)
                     errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);
                  if (m1.desthosts > 0 && m1.f2current > 0)
                     m1.f2current--;
                  else if (m1.totalhosts > 0 && m1.f1current > 0)
                  {
                      m1.f1current--;
                      key=KEY_LEFT;
                  }
                  else
                      key=KEY_LEFT;
               }
            }
            if ( key == KEY_F(3) )
            {
               createdb(&m1);
               m1.f2current=0;
               m1.f1current=0;
               key=KEY_LEFT;
            }
            if ( key == 'C' || key == 'c')
            {
               hostmasqd(&m1);
               m1.f2current=0;
               m1.f1current=0;
               key=KEY_LEFT;
            }
            if ( key == KEY_F(4) || key == 81 || key == 113)
            {
               if (choice("Update Masquerade Tables (Y/N): ",m1.LINES,m1.COLUMNS,2,m1.winhandle) == 1)
               {
                  kickdaemon(&m1);
               }
               leave=0;
               key=KEY_LEFT;
            }
         }
      }
      if ( key == KEY_LEFT )
      {
         m1.frame=1;
         m1.f2current=0;
      }
      if ((key == KEY_F(1) || key == KEY_IC))
      {
         protocol(&m1);
         if (choice("Source: Host or Network (H/N): ",m1.LINES, m1.COLUMNS,1,m1.winhandle) == 1)
         {
            source(&m1,1);
            strcpy(m1.currentsrcmask,"(null)");
         }
         else
         {
            source(&m1,2);
            source_mask(&m1);
         }
         if (strcmp(m1.currentsrcprot,"all") == 0)
            m1.currentsrcport=-1;
         else
            source_port(&m1);
         if (choice("Destination: Host or Network (H/N): ",m1.LINES, m1.COLUMNS,1,m1.winhandle) == 1)
         {
            dest(&m1,1);
            strcpy(m1.dest_mask,"(null)");
         }
         else
         {
            dest(&m1,2);
            dest_mask(&m1);
         }
         if (strcmp(m1.currentsrcprot,"all") == 0)
            m1.dest_port=-1;
         else
            dest_port(&m1);

         if (insertrec(&m1) == -1)
               errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);

         drawscreen(&m1);
         m1.frame=1;
         wrefresh(m1.winhandle);
      }
      if ((key == KEY_F(2) || key == KEY_DC))
      {
         m1.frame=1;
         if (choice("Delete Entire Tree (Y/N): ",m1.LINES,m1.COLUMNS,2,m1.winhandle) == 1)
         {
            if ( deleterec(&m1) == -1)
               errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);
            m1.f1current--;
            if (m1.f1current < 0)
               m1.f1current=0;
         }
      }
      if ( key == KEY_F(3) )
      {
         createdb(&m1);
         m1.f2current=0;
         m1.f1current=0;
         key=KEY_LEFT;
      }
      if ( key == 'C' || key == 'c')
      {
         hostmasqd(&m1);
         m1.f2current=0;
         m1.f1current=0;
         key=KEY_LEFT;
      }
      if ( key == KEY_F(4) || key == 81 || key == 113)
      {
         if (choice("Update Masquerade Tables (Y/N): ",m1.LINES,m1.COLUMNS,2,m1.winhandle) == 1)
         {
            kickdaemon(&m1);
         }
         leave=0;
      }
      drawscreen(&m1);
      trunkreaddata(&m1);
      if ( branchread(&m1) == -1)
         errormsg(msqlErrMsg,m1.LINES,m1.COLUMNS,m1.winhandle);
      wrefresh(m1.winhandle);
   }

   wclear(m1.winhandle);
   wrefresh(m1.winhandle);
   delwin(m1.winhandle);
   echo();
   endwin;
}
errormsg(char *msg, int LINES, int COLUMNS, WINDOW *winhandle)
{
   WINDOW *popwin2;

   popwin2=subwin(winhandle,3,strlen(msg)+4,(LINES/2)-1,(COLUMNS/2)-(strlen(msg)/2));
   wclear(popwin2);

   wborder(popwin2,0,0,0,0,0,0,0,0);
   mvwprintw(popwin2,1,2,"%s",msg);
   touchwin(winhandle);
   wrefresh(popwin2);
   sleep(5);
   wclear(popwin2);
   delwin(popwin2);
}

void protocol(sendmasq *m1)
{
   int key;
   key=choice("Source Protocol TCP, UDP, ALL (T,U,A):",m1->LINES,m1->COLUMNS,4,m1->winhandle);
   if (key == 1)
      strcpy(m1->currentsrcprot,"all");
   if (key == 2)
      strcpy(m1->currentsrcprot,"tcp");
   if (key == 3)
      strcpy(m1->currentsrcprot,"udp");
}

void source(sendmasq *m1, int hn)
{
   char    test[16];
   char    text[30];
   int     leave=-1;
   WINDOW  *frame;

   if (hn == 1)
      strcpy(text,"Source Host Address: ");
   else
      strcpy(text,"Source NetWork Address: ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   syncok(frame,TRUE);
   wclear(frame);
   while (leave == -1)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      leave=inet_addr(test);
      if (leave == -1)
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Malformed Address Format");
         touchwin(frame);
         wrefresh(frame);
         sleep(2);
         wclear(frame);
      }
   }
   strcpy(test,inet_ntoa(*(struct in_addr*)&leave));
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   strcpy(m1->currentsrcaddr,test);
}

void source_mask(sendmasq *m1)
{
   char    test[16];
   char    text[30];
   int     leave=-1;
   WINDOW  *frame;

   strcpy(text,"Source NetMask: ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   syncok(frame,TRUE);
   wclear(frame);
   while (leave == -1)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      leave=inet_addr(test);
      if (leave == -1)
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Malformed Address Format");
         touchwin(frame);
         wrefresh(frame);
         sleep(2);
         wclear(frame);
      }
   }
   strcpy(test,inet_ntoa(*(struct in_addr*)&leave));
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   strcpy(m1->currentsrcmask,test);
}

void source_port(sendmasq *m1)
{
   char    test[16];
   char    text[38];
   int     leave=1;
   int     count;
   WINDOW  *frame;

   strcpy(text,"Source Port (Use -1 for all Ports): ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave!=0)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      if (atoi(test) == -1)
         leave=0;
      else
      {
         for (count=0;count<strlen(test);count++)
         {
            if (test[count] < '0' || test[count] > '9')
               leave=2;
         }
      }

      if (leave == 2)
      {
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,((strlen(text)+20)/2)-10,"Incorrect Port Number");
         touchwin(m1->winhandle);
         wrefresh(frame);
         sleep(2);
      }
      else
         leave=0;
      wclear(frame);
   }
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);

   m1->currentsrcport=atoi(test);
}

void dest(sendmasq *m1, int hn)
{
   char    test[16];
   char    text[30];
   int     leave=-1;
   int     key;
   WINDOW  *frame;

   if (hn == 1)
      strcpy(text,"Destination Host Address: ");
   else
      strcpy(text,"Destination NetWork Address: ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave == -1)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      leave=inet_addr(test);
      if (leave == -1)
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Malformed Address Format");
         touchwin(frame);
         wrefresh(frame);
         sleep(2);
         wclear(frame);
      }
   }
   strcpy(test,inet_ntoa(*(struct in_addr*)&leave));
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   strcpy(m1->dest,test);
}

void dest_mask(sendmasq *m1)
{
   char    test[16];
   char    text[30];
   int     leave=-1;
   WINDOW  *frame;

   strcpy(text,"Destination NetMask: ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave == -1)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      leave=inet_addr(test);
      if (leave == -1)
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Malformed Address Format");
         touchwin(frame);
         wrefresh(frame);
         sleep(2);
         wclear(frame);
      }
   }
   strcpy(test,inet_ntoa(*(struct in_addr*)&leave));
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   strcpy(m1->dest_mask,test);
}

void dest_port(sendmasq *m1)
{
   char    test[16];
   char    text[38];
   int     leave=1;
   int     count;
   WINDOW  *frame;

   strcpy(text,"Destination Port (Use -1 for all Ports): ");

   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave!=0)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      if (atoi(test) == -1)
         leave=0;
      else
      {
         for (count=0;count<strlen(test);count++)
         {
            if (test[count] < '0' || test[count] > '9')
               leave=2;
         }
      }

      if (leave == 2)
      {
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,((strlen(text)+20)/2)-10,"Incorrect Port Number");
         touchwin(m1->winhandle);
         wrefresh(frame);
         sleep(2);
      }
      else
         leave=0;
      wclear(frame);
   }
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);

   m1->dest_port=atoi(test);
}
void hostmasqd(sendmasq *m1)
{
   char    test[16];
   char    text[30];
   int     leave=1;
   int     key;
   WINDOW  *frame;

   strcpy(text,"Masquerade Server Name: ");
   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave!=0)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      if (gethostbyname(test))
         leave=0;
      else
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Host: %s Not Found",test);
         touchwin(frame);
         wrefresh(frame);
         sleep(3);
         wclear(frame);
      }
   }
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   strcpy(m1->hostmasqd,test);
   strcpy(m1->DBname,test);
}
void hostport(sendmasq *m1)
{
   char    test[16];
   char    text[30];
   int     leave=1;
   int     key;
   WINDOW  *frame;

   strcpy(text,"Port Masqd is Running on: ");
   frame=subwin(m1->winhandle,3,strlen(text)+20,(m1->LINES/2)-1,(m1->COLUMNS/2)-((strlen(text)+20)/2));
   wclear(frame);
   while (leave!=0)
   {
      wborder(frame,0,0,0,0,0,0,0,0);
      mvwprintw(frame,1,2,text);
      echo();
      wgetnstr(frame,test,15);
      if (atoi(test) > 0)
         leave=0;
      else
      {
         noecho();
         wclear(frame);
         wborder(frame,0,0,0,0,0,0,0,0);
         mvwprintw(frame,1,7,"Invalid Port Address");
         touchwin(frame);
         wrefresh(frame);
         sleep(3);
         wclear(frame);
      }
   }
   wclear(frame);
   touchwin(m1->winhandle);
   wrefresh(frame);
   delwin(frame);
   noecho();
   keypad(m1->winhandle,TRUE);
   m1->hostport=atoi(test);
}
