#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <pwd.h>
#include <msql.h>
#include <ncurses/curses.h>
#include <masq.h>


int kickdaemon(sendmasq *m1)
{
   struct   passwd *pswd;
   struct   sockaddr_in server;
   struct   hostent *hp;
   int      s;
   char     buffer[128];
   int      msqlSocket;
   int      record_num;
   char     sqlCommand[256];
   m_result *result;
   m_row    msqlRow;


   if (m1->msqlHOST[0]==0)
      gethostname(m1->msqlHOST,128);

   msqlSocket=msqlConnect(m1->msqlHOST);
   if (msqlSocket == -1)
      return -1;

   if ( msqlSelectDB(msqlSocket,"firewall") == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   sprintf(sqlCommand,"select name,port from hosts where dbname='%s'",m1->DBname);
   if ( msqlQuery(msqlSocket,sqlCommand) == -1)
   {
      msqlClose(msqlSocket);
      return -1;
   }

   result=msqlStoreResult();
   msqlRow=msqlFetchRow(result);

   strcpy(m1->hostmasqd,msqlRow[0]);
   m1->hostport=atoi(msqlRow[1]);

   msqlFreeResult(result);



   if ((hp=gethostbyname(m1->hostmasqd))==NULL)
   {
      errormsg("Unknown Host! Check DNS!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }

   bzero((char *)&server, sizeof(server));
   bcopy(hp->h_addr, (char *)&server.sin_addr, hp->h_length);
   server.sin_family = hp->h_addrtype;
   server.sin_port = htons(m1->hostport);


   s = socket(AF_INET,SOCK_STREAM,0);
   if (s < 0)
   {
      errormsg("Error Binding Socket!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }

   if (connect(s, (struct sockaddr *)&server, sizeof (server)) < 0)
   {
      errormsg("Error Connecting to Host!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }

   pswd=getpwuid(getuid());

   bzero((char *)&buffer,sizeof(buffer));
   read(s,buffer,sizeof(buffer));
   //printf("Greeting: %s\n",buffer);
   if (strcmp(buffer,"Masquerade Router") != 0)
   {
      close(s);
      errormsg("Error Negotiating with Host!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }

   write (s,"user",strlen("user"));

   bzero((char *)&buffer,sizeof(buffer));
   read(s,buffer,sizeof(buffer));
   //printf("Prompt: %s\n",buffer);
   if (strcmp(buffer,"Login") != 0)
   {
      close(s);
      errormsg("Error Negotiating with Host!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }


   strcpy(buffer,pswd->pw_name);
   //printf("Name: %s\n",buffer);

   write (s,buffer,strlen(buffer));

   bzero((char *)&buffer,sizeof(buffer));
   read(s,buffer,sizeof(buffer));
   //printf("Accept: %s\n",buffer);
   if (strcmp(buffer,"Accepted") != 0)
   {
      close(s);
      errormsg("Error Negotiating with Host!",m1->LINES,m1->COLUMNS,m1->winhandle);
      return -1;
   }

   write (s,m1->msqlHOST,strlen(m1->msqlHOST));
   sleep(1);
   write (s,m1->DBname,strlen(m1->DBname));
   close(s);
}
