#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <signal.h>
#include <msql.h>
#include <masq.h>



void reaper();
void createfile(sendmasq*);
char* readdata(int);

int main(int c, char **v)
{
   int    port=9100;
   struct hostent *hp;
   struct sockaddr_in sin;
   struct sockaddr_in from;
   int    s;
   int    fromlen;
   int    newsock;

   if(c>2)
   {
      printf ("Usage: masqd [port]\n");
      exit (2);
   }

   if (c==2)
     port=atoi(v[3]);

   sin.sin_family = AF_INET;
   sin.sin_addr.s_addr = htonl(INADDR_ANY);
   sin.sin_port = htons(port);;


   s = socket(AF_INET,SOCK_STREAM,0);
   while (bind(s,(struct sockaddr *) &sin, sizeof (sin))<0)
   {
      syslog(LOG_ERR, "masqd: socket bind error");
      syslog(LOG_ERR, "Trying again in 15 seconds");
      sleep(15);
   }

   signal(SIGCHLD,reaper);
   listen(s,5);
   for (;;)
   {
      signal(SIGCHLD,reaper);
      fromlen=sizeof(from);
      newsock = accept(s, (struct sockaddr *)&from, &fromlen);
      if (newsock<0)
      {
         if (errno != EINTR)
            syslog(LOG_ERR,"masqd: accept: %m");
         continue;
      }
      if (fork() == 0)
      {
         signal(SIGCHLD,reaper);
         close(s);      
         doit(newsock, &from);
      }
      close(newsock);      
   }
}
   
doit(int newsock, struct sockaddr_in *from)
{
   char *buffer;
   char *buffer1;
   char hosts[132];
   uint addr;
   FILE *hostlist;
   int  grant=0;
   sendmasq m1;


   addr=from->sin_addr.s_addr;
   hostlist=fopen("/etc/masqdhosts","a+");
   rewind(hostlist);

   while ( fgets(hosts,sizeof(hosts),hostlist))
   {
      if (hosts[0] != '#')
      {
         strtok(hosts," ");
         if (strcmp(hosts,inet_ntoa(*(struct in_addr*)&addr)) == 0)
         {
            grant=1;
            break;
         }
     }
   }

   fclose(hostlist);

   if (grant == 0)
   {
      syslog(LOG_ERR,"masqd: illegal connection from %s",inet_ntoa(*(struct in_addr*)&addr));
      write(newsock,"Connection Closed",strlen("Connection Closed"));
      exit(0);
   }

   grant=0;

   write(newsock,"Masquerade Router",strlen("Masquerade Router"));
   buffer=readdata(newsock);

   if (strcmp(buffer,"user")!=0)
   {
      syslog(LOG_ERR,"masqd: Incorrect Negotiation : %s",buffer);
      write(newsock,"Connection Closed",strlen("Connection Closed"));
      exit(0);
   }

   write(newsock,"Login",strlen("Login"));
   buffer=readdata(newsock);

   hostlist=fopen("/etc/masqdhosts","a+");
   rewind(hostlist);

   while ( fgets(hosts,sizeof(hosts),hostlist))
   {
      
      (int)buffer1=strtok(hosts," ");
      while (((int)buffer1=strtok(NULL,":")))
      {
         if (strcmp(buffer1,buffer) == 0)
            if (strcmp(hosts,inet_ntoa(*(struct in_addr*)&addr)) == 0)
               grant=1;
      }
   }

   fclose(hostlist);

   if (grant == 0)
   {
      syslog(LOG_ERR,"masqd: illegal access by : %s@%s",buffer,inet_ntoa(*(struct in_addr*)&addr));
      write(newsock,buffer,strlen(buffer));
      exit(0);
   }

   write(newsock,"Accepted",strlen("Accepted"));

   buffer=readdata(newsock);
   strcpy(m1.msqlHOST,buffer);
   buffer=readdata(newsock);
   strcpy(m1.DBname,buffer);

   strcpy(m1.masq_file,"/sbin/masq-route");
   createfile(&m1);
   system("/sbin/masq-route");

   exit(0);
}
void reaper()
{
   union wait status;

   while (wait3(&status,WNOHANG,0) >0);
}

char* readdata(int newsock)
{
   static char buffer[128];

   bzero( (char *)&buffer, sizeof(buffer));
   read(newsock,buffer,sizeof(buffer));

   return buffer;
}
