/*
 * libinetd - test program
 */
#include <stdio.h>
#include "inetd.h"

int main(void) {
  inetd_h handle;
  inetd_Service s;

  handle = inetd_ReadConf();
  if(inetd_Find(handle, "daytime", SOCKTYPE_STREAM)) {
    printf("daytime stream found!\n");
  }

  if(inetd_Find(handle, "chargen", SOCKTYPE_DGRAM)) {
    printf("chargen dgram found!\n");
  }

  s = serv_Create();
  serv_AddArg(s, "logsrv");
  serv_AddArg(s, "--host");
  serv_AddArg(s, "localhost");
  serv_SetName(s, "logsrvd");
  serv_SetPath(s, "/usr/sbin/tcpd");
  serv_SetUser(s, "root");
  serv_SetSockType(s, SOCKTYPE_STREAM);
  serv_SetProto(s, PROTO_TCP);
  serv_SetFlags(s, FLAG_NOWAIT);

  inetd_AddService(handle, s);
  s = serv_Create();
  serv_AddArg(s, "logsrv");
  serv_AddArg(s, "--host");
  serv_AddArg(s, "localhost");
  serv_SetName(s, "logsrvd");
  serv_SetPath(s, "/usr/sbin/tcpd");
  serv_SetUser(s, "nobody");
  serv_SetSockType(s, SOCKTYPE_STREAM);
  serv_SetProto(s, PROTO_TCP);
  serv_SetFlags(s, FLAG_NOWAIT);
  inetd_AddService(handle, s);

  inetd_Flush(handle, "/tmp/tst-inetd.conf");

  for(inetd_BeginIter(handle);
      inetd_CurrentService(handle);
      inetd_Iterate(handle)) {
    s = inetd_CurrentService(handle);
    printf("%s - %d\n",
	   serv_GetName(s),
	   serv_GetSockType(s));
  }
  
  inetd_Free(handle);
  return 0;
}
