/* -*- C -*-
 * This source file is part of the libinetd package.
 * 
 * Copyright (C) 1988 Jrgen Sigvardsson / jorgen@linux.nu
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 * $Id: inetd_private.h,v 1.6 1998/05/28 18:39:46 jorgen Exp $
 * $Log: inetd_private.h,v $
 * Revision 1.6  1998/05/28 18:39:46  jorgen
 * inetd_AddService semantics changed. inetd_Find, inetd_RemoveService semantics
 * also changed. Added support for comment-meta information in inetd.conf.
 *
 * Revision 1.5  1998/05/23 18:18:58  jorgen
 * Renamed structs xxx to xxx_ in order to keep g++ happy. (G++ did not like
 * the forward references)
 *
 * Revision 1.4  1998/05/23 13:50:24  jorgen
 * More bugfixes - inetd_CurrentService() fixed.
 *
 * Revision 1.3  1998/05/23 10:55:51  jorgen
 * Beta-ready
 *
 * Revision 1.2  1998/05/22 18:53:55  jorgen
 * inetd_ReadConf() now reads in /etc/inetd.conf and inetd_Flush() now flushes
 * the inetd information correctly.
 *
 * Revision 1.1.1.1  1998/05/22 17:46:22  jorgen
 * Initial version
 *
 */

#ifndef __INETD_PRIVATE_H__
#define __INETD_PRIVATE_H__

#define MAX_ARGS  32

struct inetd_Service_ {
  char* service_name;
  int sock_type;
  int proto;
  int flags;
  char* user;
  char* server_path;
  int num_args;
  char* args[MAX_ARGS];
  int off;
};

typedef struct inetd_ListEl_ {
  inetd_Service service;
  struct inetd_ListEl_* prev;
  struct inetd_ListEl_* next;
} inetd_ListEl;

typedef struct inetd_List_ {
  inetd_ListEl* head;
  inetd_ListEl* tail;
  int num_elements;
} inetd_List;

struct inetd_h_ {
  inetd_List* list;
  inetd_ListEl* iter;
};


#endif /* __INETD_PRIVATE_H__ */
