#include <qpushbt.h>
#include <qlined.h>
#include "KRequestDlg.h"

#include "KRequestDlg.moc"

KRequestDlg::KRequestDlg(const char* title, QWidget* p) :
  QDialog(0, "requestdlg", TRUE) 
{
  QSize parent_size;
  QPoint where_parent;
  QPushButton* btnOk,* btnCancel;

  m_pEdit = new QLineEdit(this);
  connect(m_pEdit, SIGNAL(returnPressed()), SLOT(accept()));
  m_pEdit->setGeometry(5, 15, 170, 20);

  btnOk = new QPushButton("Ok", this);
  btnOk->setDefault(TRUE);
  connect(btnOk, SIGNAL(clicked()), SLOT(accept()));
  btnOk->setGeometry(5, 55, 70, 20);
  

  btnCancel = new QPushButton("Cancel", this);
  connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));
  btnCancel->setGeometry(105, 55, 70, 20);
  

  where_parent = p->pos();
  parent_size = p->size();
  int x = (parent_size.width() - 150) / 2 + where_parent.x();
  int y = (parent_size.height() - 80) / 2 + where_parent.y();
  
  setCaption(title);
  setGeometry(x, y, 180, 80);
  m_pEdit->setFocus();
}

QString KRequestDlg::getInput(void) {
  return QString(m_pEdit->text());
}
