#include "forms.h"
#include "ic-file.h"
#include "ic-view.h"
#include "ic-about.h"

FD_ic_view *fd_ic_view;	/* Form definition */

struct data_t {
  char filename[129];
  struct st_rec *dlist;
  struct st_rec *wlist;
  struct st_rec *mlist;
  char accntname[129];
  long totcount;
} data;

void update_graph(int gtype, int dtype) /* 0 - daily ... 2 - monthly */
{
  char s[129];
  struct st_rec *tmplist;
  int tmp, tmp2;
  st_rec_p list, bday, bweek, bmonth;

  struct tm t;
  time_t tod;
  
				/* Set BEST times */
  bday = data.dlist;
  bweek = data.wlist;
  bmonth = data.mlist;	/* Set the best day/wee/month */

  if(data.dlist !=NULL) {	/* Get Best Day */
    list = data.dlist->next;
    while(list!=NULL) {
      if(list->count > bday->count)
	bday=list;
      list=list->next;
    }
  }

  if(data.wlist !=NULL) {	/* Get Best Week */
    list = data.wlist->next;
    while(list!=NULL) {
      if(list->count > bweek->count)
	bweek=list;
      list=list->next;
    }
  }

  if(data.mlist !=NULL) {	/* Get Best Month */
    list = data.mlist->next;
    while(list!=NULL) {
      if(list->count > bmonth->count)
	bmonth=list;
      list=list->next;
    }
  }

  if(bday!=NULL)
    strftime(s,30,"%A, %m/%d/%y", &(bday->dt));
  else
    s[0]='\0';
  fl_set_object_label(fd_ic_view->BestDay,s);

  if(bweek!=NULL)
    strftime(s,30,"%m/%d/%y", &(bweek->dt));
  else
    s[0]='\0';
  fl_set_object_label(fd_ic_view->BestWeek,s);

  if(bmonth!=NULL)
    strftime(s,30,"%B %y", &(bmonth->dt));
  else
    s[0]='\0';
  fl_set_object_label(fd_ic_view->BestMonth,s);

  /* Process curent selection only */
  
  switch (gtype) {
  case 0:
    list = data.dlist;
    break;
  case 1:
    list = data.wlist;
    break;
  case 2:
    list = data.mlist;
    break;
  default:
    return;
    break;
  }

  switch (dtype) {
  case 0:
    fl_hide_object(fd_ic_view->Browser);
    fl_show_object(fd_ic_view->Chart);
    break;
  case 1:
    fl_show_object(fd_ic_view->Browser);
    fl_hide_object(fd_ic_view->Chart);
    break;
  }

  if(list==NULL)
    return;

  tmplist = list;

  fl_freeze_form(fd_ic_view->ic_view); 
  fl_clear_chart(fd_ic_view->Chart);
  fl_clear_browser(fd_ic_view->Browser);
  fl_set_chart_autosize(fd_ic_view->Chart,1);

  strftime(s,3,"%w", &(list->dt));

				/* Updating Chart/Browser */
  while(tmplist!=NULL) {
    switch (dtype) {
    case 0:
      fl_insert_chart_value(fd_ic_view->Chart,\
			    1,tmplist->count,"",tmplist->dt.tm_wday%7+1);
      break;
    case 1:
      if(gtype==0)		/* This string only for days */
	strftime(s,30,"%A, %m/%d/%y", &(tmplist->dt));
      else if(gtype==1)		/* This string only for weeks */
	strftime(s,30,"%m/%d/%y", &(tmplist->dt));
      else if(gtype==2)		/* This string only for months */
	strftime(s,30,"%B %y", &(tmplist->dt));
	
      strcat(s,"                                 ");
      *(s+30)='\0';
      sprintf(s+30,"%d",tmplist->count);
      strcat(s," Hits");
      fl_add_browser_line(fd_ic_view->Browser,s);
      break;
    }
    tmplist=tmplist->next;
  }

				/* Updating fields outisde of the chart */
  fl_set_object_label(fd_ic_view->SiteName,data.accntname);
  fl_set_object_lsize(fd_ic_view->SiteName,FL_MEDIUM_SIZE);
  fl_set_object_lalign(fd_ic_view->SiteName,FL_ALIGN_CENTER);
  
  strftime(s,30,"%A, %m/%d/%y", &(list->dt));
  fl_set_object_label(fd_ic_view->Date,s);

  sprintf(s,"%d",list->count);
  fl_set_object_label(fd_ic_view->HitCount,s);

  sprintf(s,"%2.2f %%",(float)(list->count)*100/(float)(data.totcount));
  fl_set_object_label(fd_ic_view->TotPercent,s);
  
  sprintf(s,"%d",data.totcount);
  fl_set_object_label(fd_ic_view->TotalCount,s);
  
  tmplist=list;
  while(tmplist->next!=NULL) {
    tmplist=tmplist->next;
  }
  strftime(s,30,"%A, %m/%d/%y", &(tmplist->dt));
  fl_set_object_label(fd_ic_view->StartDate,s);

  fl_unfreeze_form(fd_ic_view->ic_view); 
}

void main_menu_callback(FL_OBJECT *obj, long arg)
{
  int choice = fl_get_menu(obj);
  const char *fname;
  char error[129];
  FILE *fp;
  int again=1, ok=0;
  int tmp;

  if(choice==-1)		/* make sure that item was selected */
    return;

  switch (choice) {
  case 1: 
    while(again) {		
      if((fname = fl_show_file_selector("Load Data File","","*.iab",""))==NULL)
	return;			/* Return if CANCEL was pressed */
      strncpy(data.filename,fname,strlen(fname)+1);
      /*      printf("Load Data : %s\n",data.filename); */
      ok=!check_file(&fp,data.filename); /* '!' because returned 0 == OK*/
      if(!ok){
	again=fl_show_question("Invalid data file!","","Select another?");
      }
      else
	again=0;	       
      if(!ok) return;		/* return if couldn't open file */
				/* erasing old data */

      empty_list(&data.dlist);
      empty_list(&data.wlist);
      empty_list(&data.mlist);
      strcpy(data.accntname,"");
      data.totcount = 0;

				/* now read the data */

      if(get_accnt_name(fp,data.accntname))
	again=fl_show_question("Invalid data file!","","Select another?");
      else {
	tmp = create_slist(fp,&(data.dlist),error); 
	/*	printf("Load Data : %d, %s\n",tmp, data.accntname); */
	tmp = create_slist(fp,&(data.wlist),error); 
	/*	printf("Load Data : %d, %s\n",tmp, data.accntname); */
	tmp = create_slist(fp,&(data.mlist),error); 
	/*	printf("Load Data : %d, %s\n",tmp, data.accntname); */
      }
    }
    data.totcount = tmp;
    update_graph(0,fl_get_button(fd_ic_view->dText));
    break;
  case 2:
    if((fname = fl_show_file_selector("Save Data File","","*.iab",""))==NULL)
      return;			/* Return if CANCEL was pressed */
    write_file(fname, data.accntname, data.dlist,  data.wlist,  data.mlist);
    break;
  case 3:
    exit(0);
    break;
  case 4:
    fl_deactivate_form(fd_ic_view->ic_view); /* deactivate main form */
				/* while about is in use!! */
    start_ic_about();
    fl_activate_form(fd_ic_view->ic_view); /* Start the form again */
    break;
  }
}

void GType_callback(FL_OBJECT *obj, long arg)
{
  update_graph(arg,fl_get_button(fd_ic_view->dText));
}

void DType_callback(FL_OBJECT *obj, long arg)
{
  if(fl_get_button(fd_ic_view->Daily))
    update_graph(0,arg);
  else   if(fl_get_button(fd_ic_view->Weekly))
    update_graph(1,arg);
  else
    update_graph(2,arg);
}

void empty_callback(FL_OBJECT *obj, long arg)
{
}

void show_all_forms()
{
  fd_ic_view = create_form_ic_view();
  
  fl_set_menu(fd_ic_view->Main,"Load Data|Save Data|Exit|About");

  fl_set_button(fd_ic_view->dChart,1);
  fl_set_button(fd_ic_view->dText,0);

  fl_set_button(fd_ic_view->Daily,1);
  fl_set_button(fd_ic_view->Weekly,0);
  fl_set_button(fd_ic_view->Monthly,0);

  fl_set_browser_fontsize(fd_ic_view->Browser,FL_NORMAL_SIZE);
  fl_hide_object(fd_ic_view->Browser);
  fl_show_object(fd_ic_view->Chart);
     
  fl_show_form(fd_ic_view->ic_view, FL_PLACE_SIZE, FL_FULLBORDER, "IC View v.1.0");
  update_graph(0,0);
  fl_do_forms();
}

void get_data(char *filename)
{
  FILE *f;
  int error;
  
  if(error=check_file(&f, filename)) {	/* 0 if correct */
    fl_show_alert("Can not open file!!",filename,"",1);
  }
}

void main(int argc, char *argv[])
{
  FILE *f;
  int tmp;
  char error[129];
  
  fl_initialize(argv[0],"IC View v.1.0", 0, 0, &argc, argv);

				/* Init datastructure */
  empty_list(&data.dlist);
  empty_list(&data.wlist);
  empty_list(&data.mlist);
  strcpy(data.accntname,"");
  data.totcount = 0;
				/* Check parameters */
  if(argc>1){
    if(!strcmp(argv[1],"-"))
      error[0]='\0';
    else
      strncpy(error,argv[1],128);
  }

  if(!check_file(&f,error)) {	/* if we can open stdin OK */
    empty_list(&data.dlist);
    empty_list(&data.wlist);
    empty_list(&data.mlist);
    strcpy(data.accntname,"");
    data.totcount = 0;

    if(!get_accnt_name(f,data.accntname)) {
      tmp = create_slist(f,&(data.dlist),error); 
      /*      printf("Load Data : %d, %s\n",tmp, data.accntname); */
      tmp = create_slist(f,&(data.wlist),error); 
      /*      printf("Load Data : %d, %s\n",tmp, data.accntname); */
      tmp = create_slist(f,&(data.mlist),error); 
      /*      printf("Load Data : %d, %s\n",tmp, data.accntname); */
    }
    data.totcount = tmp;
  }
  
  show_all_forms();
}



