#include <stdio.h>
#include "ic-file.h"

int check_file(FILE **f, char *fname)
{
  char s[80];
  if (fname[0]!='\0') {		/* file name exists */
    if((*f = fopen(fname,"r"))==NULL) {
      return(ic_error_cantopen);			/* Can't open a file */
    }
  }
  else {
    *f = stdin;
  }
  if(fgets(s, 79, *f)==NULL)
    return(ic_error_wrongheader);
  if(!strcmp(s,"IAB Statistics\n")) { /* Constant text */
    return(0);
  }
  return(ic_error_wrongheader);			/* wrong header */
}

int get_accnt_name(FILE *f, char *accntname)
{
  char s[129];
  if(fgets(s, 128, f)==NULL)
    return(ic_error_wrongheader);
  if(strncmp(s,"Account: ",strlen("Account:")))
    return(ic_error_wrongheader);
  strcpy(accntname,s+strlen("Account: "));
  if(fgets(s, 128, f)==NULL)
    return(ic_error_wrongheader);
  return(0);
}

int write_file(const char *filename, const char *accntname,\
	       st_rec_p dlist, st_rec_p wlist, st_rec_p mlist)
{
  st_rec_p tlist;
  FILE *fp;
  char s[80];

  if((fp=fopen(filename,"w"))==NULL)
    return(ic_error_wrongheader); /* return if error */
  
  fprintf(fp, "IAB Statistics\n");
  fprintf(fp, "Account: %s", accntname);
  fprintf(fp, "-\n");

				/* Now write dayly */
  fprintf(fp, "Daily\n");
  tlist=dlist;
  while(tlist) {
    strftime(s,30,"%m/%d/%y", &(tlist->dt));
    fprintf(fp,"%s %i\n", s, tlist->count);
    tlist=tlist->next;
  }
  fprintf(fp,"-\n");

  				/* Now write weekly */
  fprintf(fp, "Weekly\n");
  tlist=wlist;
  while(tlist) {
    strftime(s,30,"%m/%d/%y", &(tlist->dt));
    fprintf(fp,"%s %i\n", s, tlist->count);
    tlist=tlist->next;
  }
  fprintf(fp,"-\n");

    				/* Now write monthly */
  fprintf(fp, "Monthly\n");
  tlist=mlist;
  while(tlist) {
    strftime(s,30,"%m/%y", &(tlist->dt));
    fprintf(fp,"%s %i\n", s, tlist->count);
    tlist=tlist->next;
  }
  fprintf(fp,"-\n");
  fprintf(fp,"EOF\n");

  fclose(fp);
}
int create_slist(FILE *f, st_rec_p *stlist, char *error)
{
  char s[80];
  char s2[80];
  int cnt=0;
  int m,d,y,c;
  st_rec_p newl;
  st_rec_p head=*stlist;
  time_t t;
  struct tm *l;
  
  if(fgets(s, 79, f)==NULL)
    return(0);			/* got EOF */
  
  if(!strncmp("Error: ",s,strlen("Error: "))) {
    strcpy(error,s+strlen("Error: "));
    return(-1);
  }

  while (s!=NULL) {
    if(fgets(s, 79, f)!=NULL) {
      if(!strcmp(s,"-\n")) {	/* Check if end of section */
	*stlist = head;
	return(cnt);
      }

      newl = (struct st_rec *) malloc(sizeof(*newl));
      if(newl==NULL) {
	error = "Can not allocate memory!!";
	return(-1);
      }
      newl->next = NULL;

      strcpy(s2,(char *)strtok(s," "));
      newl->count = atoi(strtok('\0'," "));
      cnt+=newl->count;
      
      if(strlen(s2)==8) {		/* sscanf didn't work - wonder why? */
	newl->dt.tm_mon = atoi(strtok(s2,"/"))-1;
	newl->dt.tm_mday = atoi(strtok('\0',"/"));
	newl->dt.tm_year = atoi(strtok('\0',"/"));
      }
      else if(strlen(s2)==5) {
	newl->dt.tm_mday = 1;
	newl->dt.tm_mon = atoi(strtok(s2,"/"))-1;
	newl->dt.tm_year = atoi(strtok('\0',"/"));

      }
      else
	return(-1);
      
      newl->dt.tm_sec = 1;
      newl->dt.tm_min = 0;
      newl->dt.tm_hour = 0;
      t = mktime(&(newl->dt));
      l = gmtime(&t);
      newl->dt.tm_sec = 1;
      newl->dt.tm_min = 0;
      newl->dt.tm_hour = 0;
      newl->dt.tm_mon = l->tm_mon;
      newl->dt.tm_mday = l->tm_mday;
      newl->dt.tm_year = l->tm_year;
      newl->dt.tm_wday = l->tm_wday;
      newl->dt.tm_yday = l->tm_yday;

      if(*stlist==NULL) {
	*stlist=newl;
	head = *stlist;
      }
      else {
	(*stlist)->next = newl; 
	*stlist=(*stlist)->next;
      }
    }
  }
}

int empty_list(st_rec_p *slist)
{
  st_rec_p al, bl;

  al = *slist;
  while(al!=NULL){
    bl = al->next;
    free(al);
    al=bl;
  }
  *slist = NULL;
}
