/*
 *
 *	viewpanel.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

typedef		struct viewpanel {
		Widget		shell;
		Widget		shellform;
		Widget		viewform;
		Widget		titleframe;
		Widget		titleform;
		Widget		titletext;
		Widget		titlelabel;
		Widget		optionbutton;
		Widget		optionmenu;
		Widget		menubar;
		Widget		closebutton;
		Widget		helpbutton;
		Widget		extrapanel;
		Widget		extraform;
		Widget		button;
		int		x, y, w, h;
		int		open_me, show;
		char		*name;
		char		*title;
		char		geometry[32];
		caddr_t		wa;
		int		*help;
		void		(*close)();
		} VIEWPANEL;


void		CloseViewPanel();
void		NotifyViewPanel();
VIEWPANEL*	CreateViewPanel();
void		HideShowViewPanels();
void		DestroyViewPanel();
void		OpenViewPanel();
void		ShowExtraPanel();
void		AddRemoveButton();
void		SetViewPanelButton();
void		SetViewPanelTitle();
int		ConfigureViewPanel();
void		SaveViewPanel();
