/*
 *
 *	mainpanel.c
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	<time.h>

#include	<X11/StringDefs.h>
#include	<X11/Intrinsic.h>
#include	<X11/Shell.h>
#include	<X11/Core.h>
#include	<Xm/Xm.h>
#include	<Xm/Label.h>
#include	<Xm/Text.h>
#include	<Xm/RowColumn.h>
#include	<Xm/Form.h>
#include	<Xm/Frame.h>
#include	<Xm/FileSB.h>
#include	<Xm/PushB.h>
#include	<Xm/CascadeB.h>
#include	<Xm/Separator.h>

#include	"defines.h"
#include	"externs.h"
#include	"viewpanel.h"
#include	"mainpanel.h"
#include	"xsupport.h"
#include	"view.h"
#include	"config.h"

static Widget		clock_face, update_face;
static Widget		viewmenu;
static VIEWPANEL	mainpanel, *msglogpanel;
static Widget		name_text, class_text, viewsbutton;
static Widget		defaults, state, ping, telnet, traceroute;
static Widget		editdef, wan, custom, site, data;
static caddr_t		message_log;
static int		sound_on=1;

/*
 *	Add a view button to the view list.
 */
void
AddViewButton(vp, name)
VIEWPANEL	*vp;
char		*name;
	{
	vp->button = pbutton("pb", viewmenu, name);
	XtAddCallback(vp->button, XmNactivateCallback, OpenViewPanel, vp);
	if (!XtIsSensitive(viewsbutton)) XtSetSensitive(viewsbutton, 1);
	}


/*
 *	Update clock face and check for messages from the server.
 */
void
CheckForMessages()
	{
	XmTextSetString(clock_face, get_time(time(0)));
	ServerEvent();
	}


/*
 *	Set configuration of mainpanel.
 */
void
ConfigureMainPanel(variable, value)
char	*variable;
char	*value;
	{
	if (strcmp(variable, "bell") == 0) {
		if (strcmp(value, "off") == 0)
			SetBellSound(NULL, NULL, NULL);
		}
	else
		ConfigureViewPanel(&mainpanel, variable, value);
	}


/*
 *	Create current object section.
 */
void
CreateCurrentObjectPanel(oform)
Widget	oform;
	{
	Widget		f, w, b;
	XmString	xs;

	w = XtVaCreateManagedWidget("mainpanel",
		xmRowColumnWidgetClass,
		oform,
		XmNtopAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_NONE,
		XmNrightAttachment, XmATTACH_FORM,
		XmNorientation, XmHORIZONTAL,
		XmNpacking, XmPACK_COLUMN,
		XmNentryAlignment, XmALIGNMENT_CENTER,
		NULL);
	defaults = pbutton("pb", w, "Default");
	XtAddCallback(defaults, XmNactivateCallback, ObjectFunction, 0);
	XtSetSensitive(defaults, 0);
	state = pbutton("pb", w, "Dump");
	XtAddCallback(state, XmNactivateCallback, ObjectFunction, 1);
	XtSetSensitive(state, 0);
	ping = pbutton("pb", w, "Ping");
	XtAddCallback(ping, XmNactivateCallback, ObjectFunction, 2);
	XtSetSensitive(ping, 0);
	telnet = pbutton("pb", w, "Telnet");
	XtAddCallback(telnet, XmNactivateCallback, ObjectFunction, 3);
	XtSetSensitive(telnet, 0);
	traceroute = pbutton("pb", w, "Traceroute");
	XtAddCallback(traceroute, XmNactivateCallback, ObjectFunction, 4);
	XtSetSensitive(traceroute, 0);

	w = XtVaCreateManagedWidget("form",
		xmFormWidgetClass,
		oform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, w,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
	f = XtVaCreateManagedWidget("form",
		xmFormWidgetClass,
		w,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_NONE,
		NULL);
	class_text = labeled_text("text", f, 16, "Class:");
	XtVaSetValues(class_text,
		XmNsensitive, False,
		NULL);

	f = XtVaCreateManagedWidget("form",
		xmFormWidgetClass,
		w,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, f,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 2,
		NULL);
	name_text = labeled_text("text", f, 32, "Object:");
	XtVaSetValues(name_text,
		XmNsensitive, False,
		NULL);
	}


/*
 *	Create menu bar and menus.
 */
void
CreateMainMenuBar()
	{
	Widget	w, b, m, bb, new, menubar, sn, ct, frame, form;
	int	i;
	XmString	xs;

	/* 
	 *	Create main option menu.
	 */

	frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass,
		mainpanel.titleform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNshadowType, XmSHADOW_OUT,
		NULL);
	form = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		frame,
		NULL);

	menubar = XmCreateMenuBar(form, "hnms", NULL, 0);
	XtVaSetValues(menubar,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		NULL);
	XtManageChild(menubar);
	w = XmCreatePulldownMenu(menubar, "hnms", NULL, 0);
	b = cbutton("mainpanel", menubar, " H N M S ", w);
	m = XmCreatePulldownMenu(w, "hnms", NULL, 0);
	b = cbutton("mainpanel", w, "About", m);
	b = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		m,
		XmNlabelString,
		(xs=X_STR("Hierarchical Network Management System")),
		NULL);
	XmStringFree(xs);
	b = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		m,
		XmNlabelString,
		(xs=X_STR("Version 2.0")),
		NULL);
	XmStringFree(xs);
	b = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		m,
		XmNlabelString,
		(xs=X_STR("Numerical Aerodynamic Simulation Systems Division")),
		NULL);
	XmStringFree(xs);
	b = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		m,
		XmNlabelString,
		(xs=X_STR("NASA Ames Research Center")),
		NULL);
	XmStringFree(xs);
	b = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		m,
		XmNlabelString,
		(xs=X_STR("February 1994")),
		NULL);
	XmStringFree(xs);
	
	m = XmCreatePulldownMenu(w, "hnms", NULL, 0);
	b = cbutton("cb", w, "New", m);
	wan = pbutton("cb", m, "WAN Status View");
	XtAddCallback(wan, XmNactivateCallback, NewView, WANSTATUS);
	custom = pbutton("pb", m, "Custom Status View");
	XtAddCallback(custom, XmNactivateCallback, NewView, CUSTOMSTATUS);
	site = pbutton("pb", m, "Site Status View");
	XtAddCallback(site, XmNactivateCallback, NewView, SITESTATUS);
	data = pbutton("pb", m, "Object Data View");
	XtAddCallback(data, XmNactivateCallback, NewView, OBJECTDATA);

	editdef = pbutton("pb", w, "Edit Defaults");
	SetDefaultButton(editdef);

	b = pbutton("pb", w, "Hide");
	XtAddCallback(b, XmNactivateCallback, HideHNMS, NULL);

	b = pbutton("pb", w, "Bell Off");
	XtAddCallback(b, XmNactivateCallback, SetBellSound, 0);

	b = pbutton("mainpanel", w, "Save");
	CreateConfigurationPanel(mainpanel.viewform, b);

	b = pbutton("mainpanel", w, "Exit");
	XtAddCallback(b, XmNactivateCallback, QuitHNMS, mainpanel.shell);

	clock_face = XtVaCreateManagedWidget("mainpanel",
		xmTextWidgetClass,
		form,
		XmNeditable, False,
		XmNcolumns, 16,
		XmNsensitive, False,
		XmNcursorPositionVisible, False,
		XmNtopAttachment, XmATTACH_NONE,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, menubar,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 3,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 3,
		/*
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		*/
		NULL);

	/*
	 *	Server Menu
	 */

	frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass,
		mainpanel.titleform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, frame,
		XmNrightAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNshadowType, XmSHADOW_OUT,
		NULL);
	form = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		frame,
		NULL);
	menubar = XmCreateMenuBar(form, "hnms", NULL, 0);
	XtVaSetValues(menubar,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		NULL);
	w = XmCreatePulldownMenu(menubar, "hnms", NULL, 0);
	b = XtVaCreateManagedWidget("cb",
		xmCascadeButtonWidgetClass,
		menubar,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(SERVBLK_PIXMAP),
		XmNsubMenuId, w,
		XmNhighlightThickness, 0,
		NULL);
	sn = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		w,
		XmNlabelString,
		(xs=X_STR("No Server")),
		XmNalignment, XmALIGNMENT_BEGINNING,
		NULL);
	XmStringFree(xs);
	ct = XtVaCreateManagedWidget("mainpanel",
		xmLabelWidgetClass,
		w,
		XmNlabelString,
		(xs=X_STR("Disconnected")),
		XmNalignment, XmALIGNMENT_BEGINNING,
		NULL);
	XmStringFree(xs);
	m = XtVaCreateManagedWidget("mainpanel",
		xmSeparatorWidgetClass,
		w,
		XmNorientation, XmHORIZONTAL,
		NULL);
	bb = pbutton("pb", w, "Open");
	XtManageChild(menubar);

	/* Update Clock */
	update_face = XtVaCreateManagedWidget("mainpanel",
		xmTextWidgetClass,
		form,
		XmNeditable, False,
		XmNcolumns, 16,
		XmNsensitive, False,
		XmNcursorPositionVisible, False,
		XmNtopAttachment, XmATTACH_NONE,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, menubar,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 3,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 3,
		/*
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		*/
		NULL);
	CreateServerPanel(b, bb, update_face, sn, ct);

	/*
	 *	Other buttons
	 */
	w = frame = XtVaCreateManagedWidget("frame",
		xmFormWidgetClass,
		mainpanel.titleform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, frame,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	w = XtVaCreateManagedWidget("form",
		xmFormWidgetClass,
		frame,
		NULL);

	/*
	 *	Close button.
	 */

	b = XtVaCreateManagedWidget("closebutton",
		xmPushButtonWidgetClass,
		w,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(CLOSE_PIXMAP),
		XmNleftAttachment, XmATTACH_NONE,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNwidth, 40,
		XmNhighlightThickness, 0,
		NULL);
	mainpanel.close = IconifyMainPanel;
	XtAddCallback(b, XmNactivateCallback, CloseViewPanel, &mainpanel);
	mainpanel.closebutton = b;

	/*
	 *	Help button.
	 */

	b = XtVaCreateManagedWidget("helpbutton",
		xmPushButtonWidgetClass,
		w,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(HELP_PIXMAP),
		XmNleftAttachment, XmATTACH_NONE,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, b,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNwidth, 40,
		XmNhighlightThickness, 0,
		NULL);
	mainpanel.helpbutton = b;
	CreateHelpPanel();

	/*
	 *	Object Log.
	 */

	b = XtVaCreateManagedWidget("pb",
		xmPushButtonWidgetClass,
		w,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(STATBLK_PIXMAP),
		XmNleftAttachment, XmATTACH_NONE,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, b,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNhighlightThickness, 0,
		NULL);
	SetStatusLogButton(b);

	/*
	 *	Object List.
	 */

	b = XtVaCreateManagedWidget("pb",
		xmPushButtonWidgetClass,
		w,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(OBJECT_PIXMAP),
		XmNleftAttachment, XmATTACH_NONE,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, b,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNhighlightThickness, 0,
		NULL);
	CreateObjectListPanel(b);

	/*
	 *	View Menu
	 */
	menubar = XmCreateMenuBar(w, "hnms", NULL, 0);
	XtVaSetValues(menubar,
		XmNleftAttachment, XmATTACH_NONE,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, b,
		XmNbottomAttachment, XmATTACH_FORM,
		/*
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		*/
		NULL);
	viewmenu = XmCreatePulldownMenu(menubar, "hnms", NULL, 0);
	viewsbutton = XtVaCreateManagedWidget("cb",
		xmCascadeButtonWidgetClass,
		menubar,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, GetPixmap(VIEWS_PIXMAP),
		XmNlabelInsensitivePixmap, GetPixmap(VIEWS_PIXMAP),
		XmNsubMenuId, viewmenu,
		XmNhighlightThickness, 0,
		NULL);
	XtSetSensitive(viewsbutton, 0);
	XtManageChild(menubar);
	}


/*
 *	Make the main panel.
 */
int
CreateMainPanel(argc, argv)
int	argc;
char	*argv[];
	{
	Display		*dpy;

	char		*fallbacks[] = {
			"*fontList: -*-courier-*-r-*-*-14-*",
			"*mwmDecorations: 6",
			"*background: gray",
			"*foreground: black",
			NULL,
			};

	XmString	xs;
	Widget		w, f, b, m, pw;
	register	i;
	int		config=False;
	char		*cfname;
	Pixel		fgcolor, bgcolor;

	/*
	 *	Initialize the UI main panel.
	 */

	if (!InitializeX(argc, argv, fallbacks, &dpy)) return(0);

	/*
	 *	Configuration file.
	 */

	if (get_arg("-c", &cfname, argc, argv)) config = True;

	/*
	 *	Create the main panel.
	 */

	mainpanel.shell = XtVaAppCreateShell("mainpanel",
		"Hnms",
		applicationShellWidgetClass,
		dpy,
		XmNdeleteResponse, XmDO_NOTHING,
		XmNiconName, "HNMS",
		NULL);
	if (!mainpanel.shell) return(0);
	XtAddEventHandler(mainpanel.shell, StructureNotifyMask, FALSE,
		FindShell, NULL);

	if (!ColorScreen(dpy)) return(0);
	if (!AllocateStatusColors(dpy)) return(0);

	mainpanel.shellform = XtVaCreateWidget("mainpanel",
		xmFormWidgetClass,
		mainpanel.shell,
		NULL);
	mainpanel.titleform = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		mainpanel.shellform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	mainpanel.viewform = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		mainpanel.shellform,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, mainpanel.titleform,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	mainpanel.name = newstr("hnms");
	mainpanel.title = newstr("HNMS Main Panel");
	mainpanel.open_me = 1;

	XtVaGetValues(mainpanel.titleform,
		XmNforeground, &fgcolor,
		XmNbackground, &bgcolor,
		NULL);
	InitializePixmaps(dpy, fgcolor, bgcolor);
	CreateMainMenuBar();
	CreateMibLists();

	/*
	 *	Create Current Object Section
	 */
	f = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		mainpanel.viewform,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 5,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_NONE,
		NULL);
	CreateCurrentObjectPanel(f);

	/*
	 *	Message Log.
	 */
	f = XtVaCreateManagedWidget("sep",
		xmSeparatorWidgetClass,
		mainpanel.viewform,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, f,
		XmNtopOffset, 5,
		XmNbottomAttachment, XmATTACH_NONE,
		XmNorientation, XmHORIZONTAL,
		NULL);
	f = XtVaCreateManagedWidget("mainpanel",
		xmFormWidgetClass,
		mainpanel.viewform,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 5,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 5,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, f,
		XmNtopOffset, 5,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 5,
		NULL);
	message_log = CreateLog(f, "MessageLog");
	CreateNewViewPanel();
	GetHelp(&mainpanel, 0, 1);

	InitializeWANStatus();
	InitializeObjectDump();
	InitializeCustomStatus();
	InitializeSiteStatus();

	if (config)
		LoadConfiguration(cfname);
	else {
		CreateNewView(DEFAULT);
		CreateNewView(STATUSLOG);
		}
	XtManageChild(mainpanel.shellform);
	TimerProc(CheckForMessages, 1000);
	ClockTick(mainpanel.shell, NULL);
	XtRealizeWidget(mainpanel.shell);
	if (config) {
		HideShowViewPanels(0);
		SelectConnect(NULL, 1, NULL);
		}
	XmUpdateDisplay(mainpanel.shell);
	return(1);
	}


/*
 *	Disable the edit default, new view buttons.
 */
void
DisableEdit()
	{
	XtSetSensitive(wan, 0);
	XtSetSensitive(site, 0);
	XtSetSensitive(custom, 0);
	XtSetSensitive(data, 0);
	XtSetSensitive(editdef, 0);
	}


/*
 *	Enable the edit default, new view buttons.
 */
void
EnableEdit()
	{
	XtSetSensitive(wan, 1);
	XtSetSensitive(site, 1);
	XtSetSensitive(custom, 1);
	XtSetSensitive(data, 1);
	XtSetSensitive(editdef, 1);
	}


/*
 *	Hide all the views.
 */
void
HideHNMS(w, a1, a2)
Widget	w;
caddr_t	a1, a2;
	{
	static int	hidden=0;
	XmString	xs;

	if (hidden) {
		hidden = 0;
		XtVaSetValues(w,
			XmNlabelString, (xs=X_STR("Hide")),
			NULL);
		XmStringFree(xs);
		}
	else {
		hidden = 1;
		XtVaSetValues(w,
			XmNlabelString, (xs=X_STR("Show")),
			NULL);
		XmStringFree(xs);
		}
	HideShowViewPanels(hidden);
	}


/*
 *	Iconify the main panel.
 */
void
IconifyMainPanel()
	{
	GetShellDimensions(mainpanel.shell, &(mainpanel.x), &(mainpanel.y),
		&(mainpanel.w), &(mainpanel.h));
	XtVaSetValues(mainpanel.shell,
		XmNiconic, True,
		NULL);
	HideShowViewPanels(1);
	SetShellLocation(mainpanel.shell, mainpanel.x, mainpanel.y,
		mainpanel.geometry);
	XtRealizeWidget(mainpanel.shell);
	}


/*
 *	Write to message log.
 */
void
LogMessage(buf)
char	*buf;
	{
	PrintToLog(message_log, buf);
	}


/*
 *	Create a new view.
 */
void
NewView(widg, viewclass, a)
Widget	widg;
int	viewclass;
caddr_t	a;
	{
	CreateNewView(viewclass, NULL);
	}


/*
 *	Invoke a default view, object dump, or network function.
 */
void
ObjectFunction(widg, i, a2)
Widget	widg;
int	i;
caddr_t	 a2;
	{
	switch (i) {
	case 0:
		ShowCurrentObjectDefault();
		break;
	case 1:
		ShowCurrentObjectDump();
		break;
	case 2:
		ShowCurrentObjectPing();
		break;
	case 3:
		ShowCurrentObjectTelnet();
		break;
	case 4:
		ShowCurrentObjectTraceroute();
		break;
		}
	}


/*
 *	Close down HNMS.
 */
void
QuitHNMS(w, a1, a2)
Widget	w;
caddr_t	a1, a2;
	{
	DestroyX();
	exit(0);
	}


/*
 *	Save the mainpanel configuration.
 */
void
SaveMainPanel(variable, value)
char	*variable;
char	*value;
	{
	SaveViewPanel(&mainpanel, 0);
	PutConfiguration(mainpanel.name, "bell", sound_on, 1);
	}


/*
 *	Set the bell sound on or off.
 */
void
SetBellSound(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
	{
	XmString	xs;

	if (sound_on) {
		sound_on = 0;
		XtVaSetValues(w,
			XmNlabelString, (xs=X_STR("Bell On")),
			NULL);
		}
	else {
		sound_on = 1;
		XtVaSetValues(w,
			XmNlabelString, (xs=X_STR("Bell Off")),
			NULL);
		}
	XmStringFree(xs);
	SetBeep(sound_on);
	}


/*
 *	Update the current object state variables.
 */
void
UpdateCurrentObject(name, class, objclass)
char	*name;
char	*class;
int	objclass;
	{
	XmTextSetString(name_text, name);
	XmTextSetString(class_text, class);
	XtSetSensitive(defaults, 1);
	XtSetSensitive(state, 1);
	if ((objclass == OBJ_ipaddr) || (objclass == OBJ_processor)) {
		XtSetSensitive(ping, 1);
		XtSetSensitive(telnet, 1);
		XtSetSensitive(traceroute, 1);
		}
	else {
		XtSetSensitive(ping, 0);
		XtSetSensitive(telnet, 0);
		XtSetSensitive(traceroute, 0);
		}
	}
