/*\
 *	Grab an HNMS object entry from the hnmsd.cf file and print
 *	it to stdout.
\*/

#define STRBUFLEN	128

#include <stdlib.h>
#include <stdio.h>

int main(argc, argv)
    int			argc;
    char		*argv[];
{
    FILE		*fp;
    char		*cp;
    int			found = 0;
    int			len;
    char		buf[STRBUFLEN], name[STRBUFLEN], path[STRBUFLEN];

    if (argc != 2) {
	printf("usage: %s <hnms-object>\n", argv[0]);
	exit(1);
    }

    cp = getenv("HNMS_HOME");
    cp ? sprintf(path, "%s/hnmsd.cf", cp) : strcpy(path, "hnmsd.cf");
    fp = fopen(path, "r");

    if (!fp) {
	printf("could not open file %s\n", path);
	exit(1);
    }

    bzero(name, STRBUFLEN);
    sprintf(name, "Object %s", argv[1]);
    len = strlen(name);

    for (;;) {
	bzero(buf, STRBUFLEN);
	cp = fgets(buf, STRBUFLEN - 1, fp);
	if (!cp)
	    break;
	if (cp[0] == 0)
	    break;
	if (!found) {
	    if (!strncmp(name, buf, len)) {
		found = 1;
		if (buf[strlen(buf)] == '\n')
		    buf[strlen(buf)] = 0;
		fputs(buf, stdin);
	    }
	}
	else {
	    if (buf[0] != '\t')
		exit(0);
	    else
		fputs(buf, stdout);
	}
    }
    fclose(fp);
}
