HNMP DEFINITIONS ::= BEGIN

--	Title: Hierarchical Network Management Protocol
--	Created: July 25, 1991
--	Updated: November 18, 1993
--	By: Jude George
--
--	The Hierarchical Network Management Protocol (HNMP) is used for
--	information exchange between software modules in the Hierarchical
--	Network Management System (HNMS).


-- IMPORTS
-- 	ObjectName, ObjectSyntax, IpAddress, TimeTicks
-- 	FROM RFC1155-SMI;

Message ::=
	SEQUENCE {
		version INTEGER {	-- The version of HNMP.
			version-1(1),
			version-2(2)
	 	},
		community OCTET STRING, -- The HNMS community.
		from-module-type INTEGER,
		from-module-id INTEGER,
		to-module-id INTEGER,
		msg-id INTEGER,
		msg-timestamp TimeTicks,
		data PDU
	}

PDU ::=
	CHOICE {
		-- CONNECTION MANAGEMENT
		ack Ack-PDU,
		-- MODULE MANAGEMENT
		hello Hello-PDU,
		welcome Welcome-PDU,
		goodbye Goodbye-PDU,
		redirect Redirect-PDU,
		get-key GetKey-PDU,
		send-key SendKey-PDU,
		-- NETWORK OBJECT MANAGEMENT
		announce-object Announce-PDU,
		delete-object Delete-PDU,
		activate-object Activate-PDU,
		deactivate-object Deactivate-PDU,
		-- NETWORK OBJECT TOPOLOGY MANAGEMENT
		subscribe-relations SubRelations-PDU,
		unsubscribe-relations UnsubRelations-PDU,
		send-relations SendRelations-PDU,
		-- NETWORK OBJECT DATA MANAGEMENT
		subscribe-data SubData-PDU,
		unsubscribe-data UnsubData-PDU,
		send-data SendData-PDU,
		set-data SetData-PDU,
		get-data GetData-PDU,
		get-next-data GetNextData-PDU,
		get-walk-data GetWalkData-PDU
	 }

-- HNMP requires that messages be transmitted reliably but not necessarily
-- in sequence.  A retransmission scheme must be used if HNMP PDUs are sent
-- via an unreliable protocol such as UDP.  The Ack message may be used to
-- acknowledge receipt of each message and also to verify that connections
-- between modules are still active when no other messages have been
-- transmitted for some time.
Ack-PDU ::= [0]
--	IMPLICIT SEQUENCE OF INTEGER
	IMPLICIT INTEGER

-- This is sent from an unconnected module to a server module, to request
-- to be included in its HNMS community.  Since an unconnected module
-- does not have a module-id, the module-id field in a Hello message
-- will be ignored.
Hello-PDU ::= [1]
	IMPLICIT NULL

-- This is the server's response to a Hello message.  The to-module-id
-- in the header is the module ID assigned to the new module.
Welcome-PDU ::= [2]
	IMPLICIT NULL

-- Used when any non-server module wants to disconnect from the server.
Goodbye-PDU ::= [3]
	IMPLICIT NULL

-- Used when one module wants to inform another of the server's location.
Redirect-PDU ::= [4]
	IMPLICIT IpAddress

-- Used by UI modules to check out the key from the server module.
-- Only one UI module may have the key at one time.
GetKey-PDU ::= [5]
	IMPLICIT NULL

-- Send the command key to the target module.  This may either be
-- the server sending it to a UI that has requested it, or the UI sending
-- it back to the server when it is finished with it.
SendKey-PDU ::= [6]
	IMPLICIT NULL

-- Announce a new HNMS object.
Announce-PDU ::= [7]
	IMPLICIT ObjectBlock

-- Request that the specified HNMS object be destroyed.
Delete-PDU ::= [8]
	IMPLICIT ObjectId

-- Start monitoring the specified HNMS object.
Activate-PDU ::= [9]
	IMPLICIT ObjectId

-- Stop monitoring the specified HNMS object.
Deactivate-PDU ::= [10]
	IMPLICIT ObjectId

-- Subscribe to the relation variables of this object.  The variables are
-- expected back in SendRelations messages..
SubRelations-PDU ::= [11]
	IMPLICIT ObjectBlock

-- Stop the subscription to relations of the specified HNMS object.
UnsubRelations-PDU ::= [12]
	IMPLICIT ObjectId

-- Send relations of the specified HNMS object.
SendRelations-PDU ::= [13]
	IMPLICIT ObjectBlock

-- Set the specified variables to be the subscription for an HNMS object.
-- Whenever a subscribed variable changes, a SendData containing the
-- changed variables is expected in return.
SubData-PDU ::= [14]
	IMPLICIT ObjectBlock

-- Stop the subscription of all object data of the specified HNMS object.
UnsubData-PDU ::= [15]
	IMPLICIT ObjectId

-- Send a list of variable name/value pairs about the specified HNMS object.
SendData-PDU ::= [16]
	IMPLICIT ObjectBlock

-- Set the value of HNMS and/or SNMP variables associated with a given
-- HNMS object.
SetData-PDU ::= [17]
	IMPLICIT ObjectBlock

-- Request HNMS or SNMP variables concerning the given HNMS object.
-- A SendData containing the requested variables is expected in return.
GetData-PDU ::= [18]
	IMPLICIT ObjectBlock

-- Request the next SNMP variables in the SNMP tree of a given HNMS
-- object.  A SendData containing the variables is expected in return.
GetNextData-PDU ::= [19]
	IMPLICIT ObjectBlock

-- Request a walk of an entire SNMP tree starting at the indicated
-- root points, for a given HNMS object.  A SendData containing the
-- variables is expected in return.
GetWalkData-PDU ::= [20]
	IMPLICIT ObjectBlock

ObjectId ::=
	INTEGER

ObjectBlock ::=
	SEQUENCE {
		object-id INTEGER,
		variables VarBindList
	}

VarBindList ::=
	SEQUENCE OF VarBind

VarBind ::=
	SEQUENCE {
		name ObjectName,
		value ObjectSyntax,
		interval INTEGER,
		timestamp TimeTicks
	 }

ObjectName ::=
	OBJECT IDENTIFIER

ObjectSyntax ::=
    	ANY

IpAddress ::= [APPLICATION 0]
	IMPLICIT OCTET STRING (SIZE (4))
    
TimeTicks ::= [APPLICATION 3]
	IMPLICIT INTEGER

END
