/*
 * main.c
 * main and startup of the capplet and the gtk alone version
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<glib.h>
#include<gtk/gtk.h>
#include"libinetd.h"

#define VERSION "0.99.2"

#ifdef CAPPLET
  #include<capplet-widget.h>

  GtkWidget *capplet;
#endif

gboolean inetd_conf_change;

#ifdef CAPPLET
  void capplet_changed( void )
  {
    capplet_widget_state_changed( CAPPLET_WIDGET( capplet ), TRUE );
  }
#endif

void button_clicked_write( void )
{
  inetd_config_save();
  inetd_conf_change = TRUE;
}

void button_clicked_revert( void )
{
  if( inetd_conf_change == TRUE )
    inetd_config_revert();
}

#ifdef GTKONLY
  void button_clicked_quit( void )
  {
    gtk_main_quit();
  }
#endif

int main( int argc, char *argv[] )
{
#ifdef GTKONLY
    GtkWidget *window, *vbox, *hbox, *button;
#endif

  inetd_conf_change = FALSE;

#ifdef CAPPLET
    gnome_capplet_init( "inetd-properties", VERSION, argc, argv, NULL, 0, NULL );

    capplet = capplet_widget_new();
    gtk_signal_connect( GTK_OBJECT( capplet ), "try",
                        GTK_SIGNAL_FUNC( button_clicked_write ), NULL );
    gtk_signal_connect( GTK_OBJECT( capplet ), "ok",
                        GTK_SIGNAL_FUNC( button_clicked_write ), NULL);
    gtk_signal_connect( GTK_OBJECT( capplet ), "revert",
                        GTK_SIGNAL_FUNC( button_clicked_revert ), NULL );
    gtk_signal_connect( GTK_OBJECT( capplet ), "cancel",
                        GTK_SIGNAL_FUNC( button_clicked_revert ), NULL );

    gtk_container_add( GTK_CONTAINER( capplet ), inetd_config_gui() );

    gtk_widget_show( capplet );

    capplet_gtk_main();
#else
    gtk_init( &argc, &argv );

    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                        GTK_SIGNAL_FUNC( gtk_main_quit ), NULL );
    gtk_window_set_title( GTK_WINDOW( window ), "Inetd Config");

      vbox = gtk_vbox_new( FALSE, 0 );
      gtk_container_add( GTK_CONTAINER( window ), vbox );
      gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );

        hbox = gtk_hbox_new( FALSE, 5 );
        gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );

          button = gtk_button_new_with_label( "Save" );
	  gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                      button_clicked_write, NULL );
          gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
          gtk_widget_show( button );

          button = gtk_button_new_with_label( "Revert" );
	  gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                      button_clicked_revert, NULL );
          gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
          gtk_widget_show( button );

          button = gtk_button_new_with_label( "Quit" );
	  gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                      button_clicked_quit, NULL );
          gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
          gtk_widget_show( button );

        gtk_widget_show( hbox );

        gtk_box_pack_start( GTK_BOX( vbox ), inetd_config_gui(), TRUE, TRUE, 0 );

      gtk_widget_show( vbox );

    gtk_widget_show( window );

    gtk_main();
#endif

  return 0;
}