/*
 * lib/util.c
 * various non-gui related function like parsing and i/o
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<stdio.h>
#include<glib.h>
#include"util.h"

GString *clean_local( GString *in, gboolean rem )
{
  guint i;
  GString *out = g_string_new( "" );
  gchar current, old = ' ';

  if( !in -> len )
    return out;

  for( i = 0; i <= in -> len - 1; i++ )
  {
    if( ( current = in -> str[i] ) == '#' )
    {
      if( rem == TRUE )
	g_string_append( out, "# " );
      else
      {
        if( old == ' ' && out -> len >= 2)
          out = g_string_erase( out, out -> len - 1, 1 );
        return out;
      }
    }

    if( ( rem == FALSE && current == '/' ) ||
        ( current == '\t' || current == '\n' || current == ':' ||
	  current == '#' || current == '*' ) )
      current = ' ';

    if( ( current == ' ' && old != ' ' ) || ( current != ' ' ) )
      g_string_append_c( out, current );

    old = current;
  }

  if( old == ' ' && out -> len >= 2)
    out = g_string_erase( out, out -> len - 1, 1 );

  return out;
}

GString *clean( GString *in, gboolean rem )
{
  GString *line = clean_local( in, rem ), *word = NULL;

  if( rem == TRUE )
    if( line -> str[0] == '#' )
    {
      word = get_word( line, 3 );
      if( !strcmp( word -> str, "stream" ) || !strcmp(word -> str, "dgram" ) ||
    	  !strcmp( word -> str, "raw" ) || !strcmp( word -> str, "rdm" ) ||
	  !strcmp( word -> str, "seqpacket" ) )
        g_string_free( word, 0 );
      else
      {
        g_string_free( line, 0 );
        line = g_string_new( "" );
      }
    }

  return line;
}

GString *get_word( GString *in, guint number )
{
  guint i, j = 1;
  GString *out = g_string_new( "" );

  for( i = 0; i <= in -> len - 1; i++ )
    if( j == number )
      if( in -> str[i] != ' ' )
        g_string_append_c( out, in -> str[i] );
      else
        return out;
    else
      if( in -> str[i] == ' ' )
        j++;

  return out;
}

GString *find_complement( GString *in, GList *list )
{
  guint i, pos = 1, ret = 2, length = g_list_length( list );
  GString *line;

  if( if_numeric( in ) == TRUE )
  {
    pos = 2;
    ret = 1;
  }

  for( i = 1; i <= length; i++ )
  {
    line = g_list_item( list, i );
    if( !strcmp( get_word( line, pos )-> str, in -> str ) )
      return get_word( line, ret );
  }

  return g_string_new( "" );
}

GString *find_services_port( GString *in )
{
  static GList *services, *rpc;
  GString *out = NULL;

  if( services == NULL || rpc == NULL )
  {
    services = load_raw_file( "/etc/services", FALSE );
    rpc = load_raw_file( "/etc/rpc", FALSE );
  }

  if( !( out = find_complement( in, rpc ) ) -> len )
    out = find_complement( in, services );

  return out;
}

gboolean if_numeric( GString *in )
{
  gboolean out = TRUE;
  guint i;

  for( i = 0; i <= in -> len - 1; i++ )
    if( in -> str[i] < 48 || in -> str[i] > 57 )
      out = FALSE;

  return out;
}

/* coz glibc's getline( char **, size t *, FILE * ) seg */
GString *get_line( FILE *file )
{
  gchar c = '\0';
  GString *out = g_string_new( "" );

  do
  {
    if( ( c = fgetc( file ) ) != -1 )
      g_string_append_c( out, c );

  } while( c != -1 && c != '\n' );

  return out;
}

GList *load_raw_file( gchar *filename, gboolean rem )
{
  FILE *file = fopen( filename, "r" );
  GList *out = NULL;
  GString *line;

  do
  {
    if( ( line = clean( get_line( file ), rem ) ) -> len )
      out = g_list_append( out, line -> str );
  } while( !feof( file ) );

  fclose( file );
  return out;
}

GList *load_file( gchar *filename )
{
  GList *out = NULL, *in = load_raw_file( filename, FALSE );
  GString *current, *old = g_string_new( "" );
  guint i, length = g_list_length( in );

  for( i = 1; i <= length; i++ )
  {
    current = get_word( g_list_item( in, i ), 1 );

    if( strcmp( current -> str, old -> str ) )
      out = g_list_append( out, current -> str );

    old = g_string_new( current -> str );
  }

  return out;
}

GString *g_list_item( GList *list, guint item )
{
  guint i = 0, length = g_list_length( list );

  g_list_position( list, g_list_first( list ) );
  do
  {
    if( ++i == item )
      return g_string_new( list -> data );

    list = g_list_next( list );
  } while( i != length );

  return g_string_new( "Overflow\n" );
}