/*
 * lib/startup.c
 * various checkup and operation performed during startup
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<sys/stat.h>
#include<glib.h>
#include<stdio.h>
#include<pwd.h>
#include<unistd.h>
#include<stdlib.h>
#include"startup.h"

gchar *FileNameOriginal, *FileNameBackup;

void cp( gchar *src, gchar *dest )
{
  FILE *in, *out;
  guint i;
  struct stat buf;

  if( ( in = fopen( src, "r" ) ) != NULL )
  {
    out = fopen( dest, "w" );
    stat( src, &buf );

    for( i = 1; i <= buf.st_size; i++ )
      fputc( getc( in ), out );

    fclose( in );
    fclose( out );
  }
}

GString *startup_check( void )
{
  GString *error = g_string_new( "" ), *str;
  FILE *file;
  guint i = getuid();
  gchar *filename[] = { "/etc/inetd.conf", "/etc/services", "/etc/protocols",
                        "/etc/passwd", "/etc/group", "/etc/rpc" };

  if( i )
  {
    str = g_string_new( getpwuid( i ) -> pw_dir );
    g_string_append( str, "/inetd.conf" );
    FileNameOriginal = g_string_new( str -> str ) -> str;

    g_string_append( str, ".bak" );
    FileNameBackup = str -> str;
  }
  else
  {
    FileNameOriginal = g_string_new( "/etc/inetd.conf" ) -> str;
    FileNameBackup = g_string_new( "/etc/inetd.conf.bak" ) -> str;
  }

  for( i = 0; i <= 5; i++ )
  {
    file = fopen( filename[i], "r" );
    if( file == NULL )
      g_string_sprintf( error, "%scan't open %s.\n",
                        error -> str, filename[i] );
    else
      fclose( file );
  }

  if( !error -> len )
    cp( FileNameOriginal, FileNameBackup );

  return error;
}