/*
 * lib/inetd_conf.c
 * input, parsing and output of the inetd.conf file
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<stdio.h>
#include<gtk/gtk.h>
#include<glib.h>
#include"util.h"
#include"gui.h"

#define BEFORE TRUE
#define AFTER  FALSE

guint word_count( GString *in )
{
  guint i, out = 1;

  for( i = 0; i <= in -> len - 1; i++ )
    if( in -> str[i] == ' ' )
      out++;

  return out;
}

guint separate( GString *str, gchar chr )
{
  guint i;

  for( i = 0; i <= str -> len - 1; i++ )
    if( str -> str[i] == chr )
      return i;

  return 0;
}

GString *scan_s( GString *str, gchar chr, gboolean flag )
{
  guint i, start = 0, end = str -> len - 1;
  GString *out = g_string_new( "" );

  if( flag == BEFORE )
    end = separate( str, chr ) - 1;
  else
    start = separate( str, chr ) + 1;

  for( i = start; i <= end; i++ )
    g_string_append_c( out, str -> str[i] );

  return out;
}

void parse_inetd_conf( GtkWidget *list )
{
  GList *conf = load_raw_file( "/etc/inetd.conf", TRUE );
  guint i, j, k, length = g_list_length( conf ), count;
  GString *line, *word;
  gchar *row[13];

  for( i = 1; i <= length; i++ )
  {
    j = 0;
    row[4] = g_string_new( "*" ) -> str;

    line = g_list_item( conf, i );
    if( ( word = get_word( line, ++j ) ) -> str[0] == '#' )
    {
      g_free( row[4] );
      row[4] = g_string_new( " " ) -> str;

      g_string_free( word, 0 );
      word = get_word( line, ++j );
    }

    if( if_numeric( word ) )
    {
      row[0] = find_services_port( word ) -> str;
      row[3] = word -> str;
    }
    else
    {
      if( separate( word, '/' ) )
      {
        row[0] = scan_s( word, '/', BEFORE ) -> str;
	row[2] = scan_s( word, '/', AFTER ) -> str;
      }
      else
      {
        row[0] = word -> str;
        row[2] = g_string_new( "" ) -> str;
      }
      row[3] = find_services_port( word ) -> str;
    }

    row[5] = get_word( line, ++j ) -> str;

    if( separate( ( word = get_word( line, ++j ) ), '/' ) )
    {
      row[1] = g_string_new( "*" ) -> str;
      row[6] = scan_s( word, '/', AFTER ) -> str;
    }
    else
    {
      row[6] = word -> str;
      row[1] = g_string_new( "" ) -> str;
    }

    if( separate( ( word = get_word( line, ++j ) ), '.' ) )
    {
      row[7] = scan_s( word, '.', BEFORE ) -> str;
      row[8] = scan_s( word, '.', AFTER ) -> str;
    }
    else
    {
      row[7] = word -> str;
      if( row[7][0] == 'w' )
         row[8] = g_string_new( "40" ) -> str;
      else
         row[8] = g_string_new( "" ) -> str;
    }

    if( separate( ( word = get_word( line, ++j ) ), '.' ) )
    {
      row[9] = scan_s( word, '.', BEFORE ) -> str;
      row[10] = scan_s( word, '.', AFTER ) -> str;
    }
    else
    {
      row[9] = word -> str;
      row[10] = g_string_new( "" ) -> str;
    }

    row[11] = get_word( line, ++j ) -> str;

    count = word_count( line );
    if( j++ == count )
      row[12] = g_string_new( "" ) -> str;
    else
    {
      word = g_string_new( "" );

      for( k = j; k <= count; k++ )
      {
        g_string_append( word, get_word( line, k ) -> str );
	g_string_append( word, " " );
      }
      word = g_string_erase( word, word -> len - 1, 1 );
      row[12] = word -> str;
    }

    gtk_clist_append( GTK_CLIST( list ), row );
  }
}

void save_inetd_conf( gchar *filename )
{
  FILE *file;
  gchar *str, *str2;
  GString *out = g_string_new( "" );
  guint i, j;

  file = fopen( filename, "w" );

  for( i = 0; i <= GTK_CLIST( CListServices ) -> rows - 1; i++ )
  {
    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 4, &str );
    if( str[0] != '*' )
      g_string_append( out, "# " );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 0, &str );
    if( str[0] == '\0' )
      gtk_clist_get_text( GTK_CLIST( CListServices ), i, 3, &str );
    g_string_append( out, str );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 2, &str );
    if( str[0] != '\0' )
    {
      g_string_append( out, "/" );
      g_string_append( out, str );
    }
    g_string_append( out, " " );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 5, &str );
    g_string_append( out, str );
    g_string_append( out, " " );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 1, &str );
    if( str[0] == '*' )
      g_string_append( out, "rpc/" );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 6, &str );
    g_string_append( out, str );
    g_string_append( out, " " );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 7, &str );
    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 8, &str2 );

    g_string_append( out, str );
    if( str2[0] != '\0'  && strcmp( str2, "40" ) )
    {
      g_string_append( out, "." );
      g_string_append( out, str2 );
    }
    g_string_append( out, " " );

    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 9, &str );
    gtk_clist_get_text( GTK_CLIST( CListServices ), i, 10, &str2 );
    g_string_append( out, str );
    if( str2[0] != '\0' )
    {
      g_string_append( out, "." );
      g_string_append( out, str2 );
    }
    g_string_append( out, " " );

    for( j = 11; j <= 12; j++ )
    {
      gtk_clist_get_text( GTK_CLIST( CListServices ), i, j, &str );
      g_string_append( out, str );
      g_string_append( out, " " );
    }
    out = g_string_erase( out, out -> len - 1, 1 );
    g_string_append( out, "\n" );
  }

  fputs( out -> str, file );
  fclose( file );

  g_string_free( out, 0 );
}