/*
 * lib/gui_event.c
 * all manipulation of the widget and event
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<stdlib.h>
#include<gtk/gtk.h>
#include"util.h"
#include"gui.h"
#ifdef CAPPLET
  void capplet_changed( void );
#endif

guint Row;
GtkWidget *file_selection;

void button_clicked_edit( void )
{
  gtk_widget_set_sensitive( FrameEditService, TRUE );
}

void button_clicked_new( void )
{
  gchar *str[13];
  guint i;

  for( i = 0; i <= 12; i++ )
    str[i] = g_string_new( "" ) -> str;

  str[3] = g_string_new( "0" ) -> str;
  gtk_clist_insert( GTK_CLIST( CListServices ), Row, str );

#ifdef CAPPLET
  capplet_changed();
#endif
}

void button_clicked_remove( void )
{
  gtk_clist_remove( GTK_CLIST( CListServices ), Row );

#ifdef CAPPLET
  capplet_changed();
#endif
}

void button_toggle_wait( void )
{
  if( GTK_TOGGLE_BUTTON( CheckButtonWait ) -> active )
    gtk_widget_set_sensitive( HBoxWait, TRUE );
  else
    gtk_widget_set_sensitive( HBoxWait, FALSE );
}

void button_toggle_rpc( void )
{
  GString *str;
  gpointer *ptr;

  if( GTK_TOGGLE_BUTTON( CheckButtonRPC ) -> active )
  {
    ptr = ( gpointer * ) GTK_COMBO( ComboRPC ) -> entry;
    gtk_widget_set_sensitive( ComboRPC, TRUE );
    gtk_widget_set_sensitive( HBoxVersion, TRUE );
    gtk_widget_set_sensitive( ComboServicesName, FALSE );
  }
  else
  {
    ptr = ( gpointer * ) GTK_COMBO( ComboServicesName ) -> entry;
    gtk_widget_set_sensitive( ComboRPC, FALSE );
    gtk_widget_set_sensitive( HBoxVersion, FALSE );
    gtk_widget_set_sensitive( ComboServicesName, TRUE );
  }

  str = g_string_new( gtk_entry_get_text( GTK_ENTRY( ptr ) ) );
  if( !str -> len  )
    gtk_entry_set_text( GTK_ENTRY( ptr ), "0" );

  g_string_free( str, 0 );
}

void unselect( void )
{
  gtk_entry_set_text(GTK_ENTRY( GTK_COMBO( ComboServicesName ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboRPC ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboSocketsType ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboProtocols ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboUsers ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboGroups ) -> entry ), "" );
  gtk_entry_set_text( GTK_ENTRY( EntryServer ), "" );
  gtk_entry_set_text( GTK_ENTRY( EntryVersion ), "" );
  gtk_entry_set_text( GTK_ENTRY( EntryArgument ), "" );
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( SpinButtonWait ), 1 );

  gtk_widget_set_sensitive( FrameEditService, FALSE );
  gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonEnable ), FALSE );
  gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonWait ), FALSE );
}

void clist_selection_set_entry( gint row, gint column, GtkWidget *widget )
{
  gchar *str;

  gtk_clist_get_text( GTK_CLIST( CListServices ), row, column, &str );
  gtk_entry_set_text( GTK_ENTRY( widget ), str );
}

void clist_selection( GtkWidget *clist, gint row, gint column,
                      GdkEventButton *event, gpointer data )
{
  gchar *str;
  GString *service;

  Row = row;
  gtk_widget_set_sensitive( HBoxButtons, TRUE );

  gtk_clist_get_text( GTK_CLIST( clist ), Row, 0, &str );
  if( str[0] == '\0' )
     gtk_clist_get_text( GTK_CLIST( clist ), Row, 3,  &str );
  service = g_string_new( str );

  gtk_clist_get_text( GTK_CLIST( clist ), Row, 1, &str );
  if( str[0] == '*' )
  {
    gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboRPC ) -> entry ),
                        service -> str );
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonRPC ), TRUE );
  }
  else
  {
    gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( ComboServicesName ) -> entry ),
                        service -> str );
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonRPC ), FALSE );
  }

  gtk_clist_get_text( GTK_CLIST( clist ), Row, 4, &str );
  if( str[0] == '*' )
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonEnable ), TRUE );
  else
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonEnable ), FALSE);

  gtk_clist_get_text( GTK_CLIST( clist ), Row, 7, &str );
  if( str[0] == 'w' )
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonWait ), TRUE );
  else
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( CheckButtonWait ), FALSE );

  gtk_clist_get_text( GTK_CLIST( clist ), Row, 8, &str );
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( SpinButtonWait ), atoi( str ) );

  clist_selection_set_entry( Row, 2, GTK_WIDGET( EntryVersion ) );
  clist_selection_set_entry( Row, 5, GTK_WIDGET( GTK_COMBO( ComboSocketsType )
                                                 -> entry ) );
  clist_selection_set_entry( Row, 6, GTK_WIDGET( GTK_COMBO( ComboProtocols )
                                                 -> entry ) );
  clist_selection_set_entry( Row, 9, GTK_WIDGET( GTK_COMBO( ComboUsers )
                                                 -> entry ) );
  clist_selection_set_entry( Row, 10, GTK_WIDGET( GTK_COMBO( ComboGroups )
                                                  -> entry ) );
  clist_selection_set_entry( Row, 11, GTK_WIDGET( EntryServer ) );
  clist_selection_set_entry( Row, 12, GTK_WIDGET( EntryArgument ) );

  button_toggle_rpc();
}

void clist_unselection( GtkWidget *clist, gint row, gint column,
                        GdkEventButton *event, gpointer data )
{
  unselect();
  gtk_widget_set_sensitive( HBoxButtons, FALSE );
}

void button_clicked_server_file_selection( void )
{
  gtk_entry_set_text( GTK_ENTRY( EntryServer ),
                      gtk_file_selection_get_filename(
		        GTK_FILE_SELECTION( file_selection ) ) );
  gtk_widget_destroy( file_selection );
}

void button_clicked_server( void )
{
  file_selection = gtk_file_selection_new( "Server selection" );
  gtk_widget_show( file_selection );

  gtk_signal_connect( GTK_OBJECT(
                        GTK_FILE_SELECTION( file_selection ) -> ok_button ),
		      "clicked",
		      ( GtkSignalFunc ) button_clicked_server_file_selection,
		      file_selection );
  gtk_signal_connect_object( GTK_OBJECT(
                        GTK_FILE_SELECTION( file_selection ) -> cancel_button ),
		      "clicked", ( GtkSignalFunc ) gtk_widget_destroy,
		      GTK_OBJECT( file_selection ) );
}

void button_clicked_argument_file_selection( void )
{
  gtk_entry_set_text( GTK_ENTRY( EntryArgument ),
                      gtk_file_selection_get_filename(
		        GTK_FILE_SELECTION( file_selection ) ) );
  gtk_widget_destroy( file_selection );
}

void button_clicked_argument( void )
{
  file_selection = gtk_file_selection_new( "Argument selection" );
  gtk_widget_show( file_selection );

  gtk_signal_connect( GTK_OBJECT(
                        GTK_FILE_SELECTION( file_selection ) -> ok_button ),
		      "clicked",
		      ( GtkSignalFunc ) button_clicked_argument_file_selection,
		      file_selection );
  gtk_signal_connect_object( GTK_OBJECT(
                               GTK_FILE_SELECTION( file_selection )
			       -> cancel_button ),
			     "clicked", ( GtkSignalFunc ) gtk_widget_destroy,
			     GTK_OBJECT( file_selection ) );
}

void button_clicked_save( void )
{
  GString *str, *str2;
  guint i = 0, j = 3;

  if( GTK_TOGGLE_BUTTON( CheckButtonRPC ) -> active )
  {
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 1, "*" );
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 2,
                        gtk_entry_get_text( GTK_ENTRY( EntryVersion ) ) );
    str = g_string_new( gtk_entry_get_text(
                        GTK_ENTRY( GTK_COMBO( ComboRPC ) -> entry ) ) );
  }
  else
  {
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 1, " " );
    str = g_string_new( gtk_entry_get_text(
                        GTK_ENTRY(GTK_COMBO( ComboServicesName ) -> entry ) ) );  
  }

  str2 = find_services_port( str );
  if( if_numeric( str ) )
  {
    i = 3;
    j = 0;
  }
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, i, str -> str );
  if( str2 -> len )
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, j, str2 -> str );
  else
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, j, "" );

  if( GTK_TOGGLE_BUTTON( CheckButtonEnable ) -> active )
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 4, "*" );
  else
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 4, " " );

  i = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( SpinButtonWait ) );
  if( GTK_TOGGLE_BUTTON( CheckButtonWait ) -> active && i )
  {
    g_string_sprintf( str, "%d", i );
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 8, str -> str );
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 7, "wait" );
  }
  else
  {
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 7, "nowait" );
    gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 8, "" );
  }

  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 5,
    gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( ComboSocketsType ) -> entry ) ) );
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 6,
    gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( ComboProtocols ) -> entry ) ) );
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 9,
    gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( ComboUsers ) -> entry ) ) );
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 10,
    gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( ComboGroups ) -> entry ) ) );
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 11,
    gtk_entry_get_text( GTK_ENTRY( EntryServer ) ) );
  gtk_clist_set_text( GTK_CLIST( CListServices ), Row, 12,
    gtk_entry_get_text( GTK_ENTRY( EntryArgument ) ) );

  gtk_widget_set_sensitive( FrameEditService, FALSE );
#ifdef CAPPLET
  capplet_changed();
#endif
}