/*
 * lib/gui.c
 * all gtk call generate the ui
 * Copyright (c) 1999, Bruno Clermont <kain@linuxbox.com>.
 */
#include<gtk/gtk.h>
#include"gui_event.h"
#include"startup.h"
#include"inetd_conf.h"
#include"util.h"
#include"gui.h"

GtkWidget *CheckButtonEnable, *SpinButtonWait, *EntryArgument, *ComboRPC,
	  *ComboServicesName, *CheckButtonRPC, *EntryVersion, *ComboUsers,
	  *FrameEditService, *CheckButtonWait, *EntryServer, *ComboGroups,
	  *ComboSocketsType, *ComboProtocols,  *CListServices, *HBoxWait,
          *HBoxVersion, *HBoxButtons;

GList *load_sockets( void )
{
  gchar *SocketTypesLabel[] = { "stream", "dgram", "raw", "rdm", "seqpacket" };
  guint i;
  GList *out = NULL;

  for( i = 0; i <= 4; i++ )
    out = g_list_append( out, SocketTypesLabel[i] );

  return out;
}

GtkWidget *gui_checkbutton_new( gchar *text, GtkWidget *parent, gpointer func )
{
  GtkWidget *checkbutton = gtk_check_button_new_with_label( text );

  gtk_box_pack_start( GTK_BOX( parent ), checkbutton, TRUE, TRUE, 0 );
  gtk_widget_show( checkbutton );

  if( func != NULL )
    gtk_signal_connect( GTK_OBJECT( checkbutton ), "clicked",
                        ( gpointer ) func, NULL );

  return checkbutton;
}

GtkWidget *gui_entry_new( GtkWidget *parent )
{
  GtkWidget *entry = gtk_entry_new();

  gtk_box_pack_start( GTK_BOX( parent ), entry, TRUE, TRUE, 0 );
  gtk_widget_show( entry );

  return entry;
}

void gui_label_new( gchar *str, GtkWidget *parent )
{
  GtkWidget *label = gtk_label_new( str );

  gtk_box_pack_start( GTK_BOX( parent ), label, TRUE, TRUE, 0 );
  gtk_widget_show( label );
}

GtkWidget *gui_combo_new( GList *list, GtkWidget *parent )
{
  GtkWidget *combo = gtk_combo_new();

  gtk_box_pack_start( GTK_BOX( parent ), combo, TRUE, TRUE, 0 );
  gtk_combo_set_popdown_strings( GTK_COMBO( combo ), list );
  gtk_widget_show( combo );

  return combo;
}

void gui_button_new( gchar *label, gpointer func, GtkWidget *parent )
{
  GtkWidget *button = gtk_button_new_with_label( label );

  gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                      ( gpointer ) func, NULL );
  gtk_box_pack_start( GTK_BOX( parent ), button, TRUE, TRUE, 0 );
  gtk_widget_show( button );
}

GtkWidget *inetd_config_gui( void )
{
  GString *error = startup_check();
  GtkWidget *vbox_main, *frame, *vbox, *hbox,
            *hbox2, *scrolled, *separator;
  guint CListWidth[] = { 60, 35, 45, 45, 40, 50, 60, 40, 35, 60, 60, 130, 190 }, i;
  gchar *CListLabels[] = { "Service", "RPC", "Version", "Port", "Enable",
                           "Type", "Protocols", "Wait", "Max", "User",
			   "Group", "Server", "Argument" },
	*ComboLabels[] = { "Service Name", "RPC", "Socket Type",
	                   "Protocols", "User", "Group" };

  if( error -> len )
  {
    vbox_main = gtk_label_new( error -> str );
    gtk_widget_show( vbox_main );

    return vbox_main;
  }

  vbox_main = gtk_vbox_new( FALSE, 5 );

    frame = gtk_frame_new( "Service List" );
    gtk_box_pack_start( GTK_BOX( vbox_main ), frame, TRUE, TRUE, 0 );

      vbox = gtk_vbox_new( FALSE, 0 );
      gtk_container_add( GTK_CONTAINER( frame ), vbox );

        scrolled = gtk_scrolled_window_new( NULL, NULL );
        gtk_box_pack_start( GTK_BOX( vbox ), scrolled, TRUE, TRUE, 0 );
        gtk_container_border_width( GTK_CONTAINER( scrolled ), 5 );
	gtk_widget_set_usize( scrolled, 400, 170 );
        gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrolled ),
	                                GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC );

          CListServices = gtk_clist_new_with_titles( 13, CListLabels );
          gtk_container_add( GTK_CONTAINER( scrolled ), CListServices );

            parse_inetd_conf( CListServices );
            gtk_signal_connect( GTK_OBJECT( CListServices ), "select_row",
	                        GTK_SIGNAL_FUNC( clist_selection ), NULL );
            gtk_signal_connect( GTK_OBJECT( CListServices ), "unselect_row",
	                        GTK_SIGNAL_FUNC( clist_unselection ), NULL );

            for( i = 0; i <= 12; i++ )
              gtk_clist_set_column_width( GTK_CLIST( CListServices ),
	                                  i, CListWidth[i] );

          gtk_widget_show( CListServices );

        gtk_widget_show( scrolled );

        HBoxButtons = gtk_hbox_new( FALSE, 10 );
	gtk_container_border_width( GTK_CONTAINER( HBoxButtons ), 5 );
        gtk_widget_set_sensitive( HBoxButtons, FALSE );
        gtk_box_pack_start( GTK_BOX( vbox ), HBoxButtons, FALSE, TRUE, 0 );

          gui_button_new( "New", button_clicked_new, HBoxButtons );
          gui_button_new( "Edit", button_clicked_edit, HBoxButtons );
          gui_button_new( "Remove", button_clicked_remove, HBoxButtons );

        gtk_widget_show( HBoxButtons );

      gtk_widget_show( vbox );

    gtk_widget_show( frame );

    FrameEditService = gtk_frame_new( "Edit Service" );
    gtk_box_pack_start( GTK_BOX( vbox_main ),
                        FrameEditService, FALSE, FALSE, 0 );

      hbox = gtk_hbox_new( FALSE, 5 );
      gtk_container_add( GTK_CONTAINER( FrameEditService ), hbox );
      gtk_container_border_width( GTK_CONTAINER( hbox ), 5 );

        vbox = gtk_vbox_new( FALSE, 5 );
        gtk_box_pack_start( GTK_BOX( hbox ), vbox, FALSE, FALSE, 0 );
          for( i = 0; i <= 5; i++ )
	    gui_label_new( ComboLabels[i], vbox );
        gtk_widget_show( vbox );

        vbox = gtk_vbox_new( FALSE, 5 );
        gtk_box_pack_start( GTK_BOX( hbox ), vbox, TRUE, TRUE, 0 );

          ComboServicesName = gui_combo_new(load_file( "/etc/services" ),vbox );
          ComboRPC = gui_combo_new( load_file( "/etc/rpc" ), vbox );
          ComboSocketsType = gui_combo_new( load_sockets(), vbox );
          ComboProtocols = gui_combo_new( load_file( "/etc/protocols" ), vbox );
          ComboUsers = gui_combo_new( load_file( "/etc/passwd" ), vbox );
          ComboGroups = gui_combo_new( load_file( "/etc/group" ), vbox );

        gtk_widget_show( vbox );

        separator = gtk_vseparator_new();
        gtk_box_pack_start( GTK_BOX( hbox ), separator, FALSE, FALSE, 0 );
        gtk_widget_show( separator );

        vbox = gtk_vbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( hbox ), vbox, FALSE, FALSE, 0 );

          hbox2 = gtk_hbox_new( FALSE, 0 );
   	  gtk_box_pack_start( GTK_BOX( vbox ), hbox2, FALSE, FALSE, 0 );

            CheckButtonEnable = gui_checkbutton_new( "Enable", hbox2, NULL );
            CheckButtonRPC = gui_checkbutton_new("RPC",hbox2,button_toggle_rpc);

          gtk_widget_show( hbox2 );

          HBoxVersion = gtk_hbox_new( FALSE, 0 );
   	  gtk_box_pack_start( GTK_BOX( vbox ), HBoxVersion, FALSE, FALSE, 0 );

            gui_label_new( "Version", HBoxVersion );
	    EntryVersion = gui_entry_new( HBoxVersion );

          gtk_widget_show( HBoxVersion );

          hbox2 = gtk_hbox_new( FALSE, 0 );
   	  gtk_box_pack_start( GTK_BOX( vbox ), hbox2, FALSE, FALSE, 0 );

            CheckButtonWait = gui_checkbutton_new( "Wait", hbox2,
	                                           button_toggle_wait );

            HBoxWait = gtk_hbox_new( FALSE, 0 );
      	    gtk_box_pack_start( GTK_BOX( hbox2 ), HBoxWait, TRUE, TRUE, 0 );

              gui_label_new( "Wait max", HBoxWait );

              SpinButtonWait = gtk_spin_button_new( GTK_ADJUSTMENT(
                    gtk_adjustment_new( 0, 1, 32767, 1, 10, 10 ) ), 1, 0 );
              gtk_box_pack_start( GTK_BOX( HBoxWait ),
	                          SpinButtonWait, TRUE, TRUE, 0 );
              gtk_widget_show( SpinButtonWait );

            gtk_widget_set_sensitive( HBoxWait, FALSE );
	    gtk_widget_show( HBoxWait );

	  gtk_widget_show( hbox2 );

          hbox2 = gtk_hbox_new( FALSE, 5 );
   	  gtk_box_pack_start( GTK_BOX( vbox ), hbox2, FALSE, FALSE, 0 );

            gui_button_new( "Server", button_clicked_server, hbox2 );
            EntryServer = gui_entry_new( hbox2 );

	  gtk_widget_show( hbox2 );

          hbox2 = gtk_hbox_new( FALSE, 5 );
   	  gtk_box_pack_start( GTK_BOX( vbox ), hbox2, FALSE, FALSE, 0 );

            gui_button_new( "Argument", button_clicked_argument, hbox2 );
            EntryArgument = gui_entry_new( hbox2 );

	  gtk_widget_show( hbox2 );

          gui_button_new( "Save", button_clicked_save, vbox );

	gtk_widget_show( vbox );

      gtk_widget_show( hbox );

    gtk_widget_show( FrameEditService );

  gtk_widget_show( vbox_main );

  unselect();
  return vbox_main;
}