#!/bin/sh
# $Id: ipfwadm.sh,v 1.1.5.1 2000/07/16 11:59:59 root Exp root $
# $Date: 2000/07/16 11:59:59 $
#
# File: ipfwadm.sh
# Desc: definition of the syntax for ipfwadm
#
# Author : Jens Friedrich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 Jens Friedrich
#
# $Log: ipfwadm.sh,v $
# Revision 1.1.5.1  2000/07/16 11:59:59  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:23  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:52  jens
# .
#
# Revision 1.1  1999/08/01 21:44:52  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:27  jens
# .
#
# Revision 1.1  1998/11/02 09:35:47  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:26  jens
# Initial revision
#
# Revision 1.1  1998/10/20 21:59:54  jens
# entered into RCS
#
# Revision 1.0.9.1  1998/06/01 19:35:04  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:43  jens
# initial ci -r 1.0
#
#

if [ -z "$IPF_IPFWADM" ]; then
IPF_IPFWADM=defined

#
# the ip screening command with verbose/test mode
# and logging
#
# function (
#            direction,        # in, out, forward
#            modus,            # add, insert, delete
#            policy,           # accept, deny, reject
#            flags,            # syn ...
#            source,           # source
#            sourceport,
#            destination,      # destination
#            destport,
#            proto,            # tcp, udp icmp
#            dev               # eth0, ppp0, ... (-b for forwarding)
#            [log]
#          )

f_ipfwadm ()
{
  #echo $1 - $2 - $3 - $4 -S $5 $6 -D $7 $8 -P $9 -W ${10} ${11}
  skip="false"
  pol=""

  # $4: flags (-y -k ...)
  IPflags="$4"

  # $11: log
  logIP="  "
  case "${11}" in
      log)  logIP="-o"
            [ "$9" = tcp ] && IPflags="-y"
            ;;
  esac

  # policy has no log-option
  case "$2" in
    -p)     l='  ';;
    -*)     l='-o';;
    *)      l='  ';;
  esac

  # $3: policy 
  case "$3" in
    accept) pol="accept $logIP";;
    reject) pol="reject $l";;
    deny)   pol="deny   $l";;
    *)  if [ "$2" != "-f" ]; then
	    echo "ERROR / FixMe: policy '$3' isn't implemented yet."
            skip=true
	fi
	;;
  esac

 if [ $skip != true ]; then
  # $5 - $8: source port dest port
  src=''; dst=''
  [ -n "$5" ] && src="-S $5 $6"
  [ -n "$7" ] && dst="-D $7 $8"

  # $9: protocoll
  pro="" 
  [ -n "$9" -a "$9" != " " ] && pro="-P $9"

  # $10: interface
  ipdev=""
  [ -n "${10}" -a "${10}" != "-b" ] && ipdev="-W ${10}"
  [ "${10}" = "-b" ] && ipdev="-b"

  ### logging / verbose mode ###

  echo "$IPFWCMD $1 $2 $pol $IPflags $src $dst $pro $ipdev" >> $FWDIR/log/$ip_cmd.log
  if [ "x$verbose" = xtrue ]; then
    if [ `uname` != Linux ]; then
        echo $IPFWCMD "$1 $2 $pol $IPflags $src $dst $pro $ipdev"
    else
        ports="n/a"
	psrc=""; pdst=""
        [ -n "$5" ] && psrc="-S $5"
        [ -n "$7" ] && pdst="-D $7"
        [ -n "$6" ] && ports="$6"
        [ -n "$8" ] && ports="$ports -> $8"
        printf "%s %5s %-9s %-7s %-4s %-9s %-30s %-30s %s\n" \
               "$1" "$2" "$pol" "$pro" "$IPflags" "$ipdev" "$psrc" "$pdst" "$ports"
    fi
  fi

  ### write command in rules file ###

  if [ "x$testing" != xtrue ]; then
    $IPFWADM $1 $2 $pol $IPflags $src $dst $pro $ipdev
    [ "$setup_file" != not_defined ] && echo >> $FWDIR/setup/$setup_file "$IPFWCMD $1 $2 $pol $IPflags $src $dst $pro $ipdev"
  fi

  echo "" > /dev/null
 fi
}

fi

