#!/bin/sh
# $Id: ipchains.sh,v 1.1.5.1 2000/07/16 12:00:00 root Exp root $
# $Date: 2000/07/16 12:00:00 $
#
# File: ipchains.sh
# Desc: definition of the syntax for ipchains
#
# Author : Jens Friedrich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 Jens Friedrich
#
# $Log: ipchains.sh,v $
# Revision 1.1.5.1  2000/07/16 12:00:00  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:23  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:53  jens
# .
#
# Revision 1.1  1999/08/01 21:44:52  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:28  jens
# .
#
# Revision 1.1  1998/11/02 09:35:47  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:26  jens
# Initial revision
#
# Revision 1.1  1998/10/20 22:01:04  jens
# entered into RCS
#
# Revision 1.0.9.1  1998/06/01 19:35:04  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:43  jens
# initial ci -r 1.0
#
#

if [ -z "$IPF_IPCHAINS" ]; then
IPF_IPCHAINS=defined

#
# the ip screening command with verbose/test mode
# and logging
#
# function (
#            direction,        # in, out, forward
#            modus,            # add, insert, delete
#            policy,           # accept, deny, reject
#            flags,            # syn ...
#            source,           # source
#            sourceport,
#            destination,      # destination
#            destport,
#            proto,            # tcp, udp icmp
#            dev               # eth0, ppp0, ... (-b for forwarding)
#            [log]
#          )

f_ipchains ()
{
  # useful for debugging
  #echo $1 - $2 - $3 - $4 -s $5 $6 -d $7 $8 -p $9 -i ${10} ${11}
  skip="false"
  l="  "; j="  "

  # translate direction
  # -I: input
  # -O: output
  # -F: forward
  case "$1" in
    -I) dir="input  ";;
    -O) dir="output ";;
    -F) dir="forward";;
    *)  echo "ERROR / FixMe: dir '$1' isn't implemented yet."
        skip=true;;
  esac

  # $3: policy
  pol="      "
  case "$3" in
    accept) pol="ACCEPT";;
    reject) pol="REJECT";;
    deny)   pol="DENY  ";;
    *)  if [ "$2" != "-f" ]; then
	    echo "ERROR / FixMe: policy '$3' isn't implemented yet."
            skip=true
	fi
	;;
  esac

  # $11: log
  IPflags=""
  [ "${11}" = log ] && l="-l"
  [ "${11}" = log -a "$9" = tcp ] && IPflags="-y"

  # translate modus to rule
  # -a: -A $dir -j $pol
  # -i: -I $dir -j $pol
  # -d: -D $dir -j $pol
  # -p: -P $dir $pol
  # -f: -F $dir $pol
  # -m: -j MASQ

  [ -n "$pol" ]         && j="-j"
  [ "$pol" = "DENY  " ] && l="-l"

  [ `echo "$2" | grep -c -- '-m'` -gt 0 ] && pol="MASQ  "

  case "$2" in
    -m\ -a) rule="-A $dir   $j $pol $l";;
    -a)     rule="-A $dir   $j $pol $l";;
    -i)     rule="-I $dir 1 $j $pol $l";;
    -m\ -d) rule="-D $dir   $j $pol $l";;
    -d)     rule="-D $dir   $j $pol $l";;
    -p)     rule="-P $dir      $pol   ";;
    -f)     rule="-F $dir             ";;
    *)      echo "ERROR / FixMe: modus '$2' isn't implemented yet."
            skip=true;;
  esac

  # translate IP flags
  # -k: ! -y
  [ "$4" = "-k" ]   && IPflags="! -y"

 if [ $skip != true ]; then
  src=""; dst=""
  [ -n "$5" ] && src="-s $5 $6"
  [ -n "$7" ] && dst="-d $7 $8"
  pro=""
  if [ -n "$9" -a "$9" != " " ]; then
      case "$9" in
        tcp)  pro="-p tcp ";;
        udp)  pro="-p udp ";;
        icmp) pro="-p icmp";;
        *)  echo "ERROR / FixMe: protocol '$9' isn't implemented yet."
            skip=true;;
      esac
  fi
  ipdev="" 
  [ -n "${10}" ] && ipdev="-i ${10}"
  [ "${10}" = "-b" ] && ipdev="-b"

  ### logging / verbose mode ###

  echo "$IPFWCMD $rule $pro $ipdev $IPflags $src $dst" >> $FWDIR/log/$ip_cmd.log
  if [ "x$verbose" = xtrue ]; then
    if [ `uname` != Linux ]; then
        echo "$IPFWCMD $rule $pro $ipdev $IPflags $src $dst"
    else
        ports="n/a"
        psrc=""; pdst=""
        [ -n "$5" ] && psrc="-s $5"
        [ -n "$7" ] && pdst="-d $7"
        [ -n "$6" ] && ports="$6"
        [ -n "$8" ] && ports="$ports -> $8"
        printf "%-25s %-7s %+4s %-9s %-30s %-30s %s\n" \
               "$rule" "$pro" "$IPflags" "$ipdev" "$psrc" "$pdst" "$ports"
    fi
  fi

  ### write command in rules file ###

  if [ "x$testing" != xtrue ]; then
    $IPFWADM $rule $pro $ipdev $IPflags  $src $dst
    [ "$setup_file" != not_defined ] && echo >> $FWDIR/setup/$setup_file "$IPFWCMD $rule $pro $ipdev $IPflags $src $dst"
  fi

  echo "" > /dev/null
 fi
}

fi
