#!/bin/sh
# $Id: ipFilter.sh,v 1.1.5.1 2000/07/16 11:59:59 root Exp root $
# $Date: 2000/07/16 11:59:59 $
#
# File: ipFilter.sh
# Desc: definition of the syntax for IP-Filter
#
# Author : Jens Friedrich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 Jens Friedrich
#
# $Log: ipFilter.sh,v $
# Revision 1.1.5.1  2000/07/16 11:59:59  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:22  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:52  jens
# .
#
# Revision 1.1  1999/08/01 21:44:52  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:27  jens
# .
#
# Revision 1.1  1998/11/02 09:35:47  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:26  jens
# Initial revision
#
# Revision 1.1  1998/10/20 22:02:14  jens
# entered into RCS
#
# Revision 1.0.9.1  1998/06/01 19:35:03  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:43  jens
# initial ci -r 1.0
#
#

if [ -z "$IPF_IPFILTER" ]; then
IPF_IPFILTER=defined

# function (
#            direction,        # in, out, forward
#            modus,            # add, insert, delete
#            policy,           # accept, deny, reject
#            flags,            # syn ...
#            source,           # source
#            sourceport,
#            destination,      # destination
#            destport,
#            proto,            # tcp, udp icmp
#            dev               # eth0, ppp0, ... (-b for forwarding)
#            [log|-q]          # enable log or disable quick option
#          )

f_ipfilter ()
{
 # enable/disable "keep state" option - "true|false" (use 'flags A/A' instead)
 keep_state="true"

 # enable/disable logging (log="")
 log="log"

 # (un-)set quick flag (quick="")
 quick="quick"
 [ "${11}" = "-q" ] && quick=""

 #echo $1 - $2 - $3 - $4 -S $5 $6 -D $7 $8 -P $9 -W ${10}
 ipf_opt=""; ipopt=""; pol=""; dir=""; ipdev=""; prot=""; src=""; sport=""
 dst=""; dport=""; state=""; icmp=""; flag=""; state=""
 skip="false"

 case "$1" in
    -I) dir="in ";;
    -O) dir="out";;
    -F) #echo "    FixMe: forwarding ('$1') isn't implemented yet."
        skip=true;;
    *)  echo "ERROR / FixMe: dir '$1' isn't implemented yet."
        skip=true;;
 esac

 [ "$skip" = "false" ] && case "$2" in
    -a*) ipopt="@1";;
    -i) ipopt="";;
    -d) ipopt=""; ipf_opt="-r";;
    -p) src="all"; ipopt="@1"; quick="" ipdev="on $4";;
    -f) case "$dir" in
          in ) ipopt="-F i";;
          out) ipopt="-F o";;
          *)  ipopt="-F a";;
        esac
        echo "$IPFWCMD $ipopt" >> $FWDIR/log/$ip_cmd.log
        if [ "x$verbose" = xtrue ]; then
         echo "$IPFWADM $ipopt"
        fi
        if [ "x$testing" != xtrue ]; then
         echo >> $FWDIR/setup/$setup_file "$IPFWADM $ipopt"
         $IPFWADM "$ipopt"
        fi
        skip=true;;
    *)   echo "ERROR / FixMe: mod '$2' isn't implemented yet."
         skip=true;;
 esac

 [ "$skip" = "false" ] && case "$3" in
    accept) pol="pass ";;
    reject) pol="block";;
    deny)   pol="block";;
    *)      echo "ERROR / FixMe: pol '$3' isn't implemented yet."
            skip=true;;
 esac

 if [ "$src" != "all" -a "$skip" != "true" ]; then

  #------ source syntax ------------------------
  sportt=""; spset=false
  if [ -n "$5" ]; then
   srcl=`echo "$5" | sed -e 's/\/.*//'`
   if [ `grep -c "$srcl" /etc/networks` -gt 0 ]; then
     srcnm=`grep "$srcl" /etc/networks | head -1 | awk '{print $2}'`
   else
     srcnm="$srcl"
   fi
  else
   srcnm="any"
  fi
  srcnr=""
  case "$5" in
    */0)        srcnr=""; srcnm="any";;
    */*)        srcnr=`echo "$5" | sed -e 's/.*\//\//'`;;
    */*.*.*.*)  srcnr=`echo "$5" | sed -e 's/.*\// mask /'`;;
  esac
  src="from $srcnm$srcnr"
  if [ -n "$6" ]; then
  case $6 in
    ![a-zA-Z]*) sportt="port != $6"
                spset=true;;
    [a-zA-Z]*)  sportt="port = $6"
                spset=true;;
    !0:[0-9]*)
                spset=true
                tp=`echo "$6" | sed -e 's/.*://'`
                sportt="port > $tp";;
    0:[0-9]*)
                spset=true
                tp=`echo "$6" | sed -e 's/.*://'`
                sportt="port <= $tp";;
    ![0-9]*:65535)
                spset=true
                fp=`echo "$6" | sed -e 's/:.*//'`
                sportt="port < $fp ";;
    [0-9]*:65535)
                spset=true
                fp=`echo "$6" | sed -e 's/:.*//'`
                sportt="port >= $fp ";;
    [0-9]*:[0-9]*)
                spset=true
                fp=`echo "$6" | sed -e 's/:.*//'`
                tp=`echo "$6" | sed -e 's/.*://'`
                fp=`expr $fp - 1`
                tp=`expr $tp + 1`
                sportt="port $fp >< $tp";;
    ![0-9]*:[0-9]*)
                spset=true
                fp=`echo "$6" | sed -e 's/:.*//'`
                tp=`echo "$6" | sed -e 's/.*://'`
                sportt="port $fp <> $tp";;
    [0-9]*)     sportt="port = $6"
                spset=true;;
    *)          echo "ERROR / FixMe: port '$6' can't be handled yet."
                skip=true;;
  esac
  [ "$spset" = true ] || skip=true
  fi

  #------ destination syntax ------------------------
  dportt=""; dpset=false
  if [ -n "$7" ]; then
   dstl=`echo "$7" | sed -e 's/\/.*//'`
   if [ `grep -c "$dstl" /etc/networks` -gt 0 ]; then
     dstnm=`grep "$dstl" /etc/networks | head -1 | awk '{print $2}'`
   else
     dstnm="$dstl"
   fi
  else
   dstnm="any"
  fi
  dstnr=""
  case "$7" in
    */0)        dstnr=""; dstnm="any";;
    */*)        dstnr=`echo "$7" | sed -e 's/.*\//\//'`;;
    */*.*.*.*)  dstnr=`echo "$7" | sed -e 's/.*\// mask /'`;;
  esac
  if [ -n "$dstnr" ]; then
   dst="to $dstnm$dstnr"
  else
   dst="to $dstnm"
  fi
  if [ -n "$8" ]; then
  case $8 in
    ![a-zA-Z]*) dportt="port != $8"
                dpset=true;;
    [a-zA-Z]*)  dportt="port = $8"
                dpset=true;;
    !0:[0-9]*)
                dpset=true
                tp=`echo "$8" | sed -e 's/.*://'`
                dportt="port > $tp";;
    0:[0-9]*)
                dpset=true
                tp=`echo "$8" | sed -e 's/.*://'`
                dportt="port <= $tp";;
    ![0-9]*:65535)
                dpset=true
                fp=`echo "$8" | sed -e 's/:.*//'`
                dportt="port < $fp ";;
    [0-9]*:65535)
                dpset=true
                fp=`echo "$8" | sed -e 's/:.*//'`
                dportt="port >= $fp ";;
    [0-9]*:[0-9]*)
                dpset=true
                fp=`echo "$8" | sed -e 's/:.*//'`
                tp=`echo "$8" | sed -e 's/.*://'`
                fp=`expr $fp - 1`
                tp=`expr $tp + 1`
                dportt="port $fp >< $tp";;
    ![0-9]*:[0-9]*)
                dpset=true
                fp=`echo "$8" | sed -e 's/:.*//'`
                tp=`echo "$8" | sed -e 's/.*://'`
                dportt="port $fp <> $tp";;
    [0-9]*)     dportt="port = $8"
                dpset=true;;
    *)          echo "ERROR / FixMe: port '$8' can't be handled yet."
                skip=true;;
  esac
  [ "$dpset" = true ] || skip=true
  fi

  [ -n "$9" ] && prot="proto $9"
  if [ "$prot" = "proto icmp" ]; then
   sporti=`echo "$sportt" | sed -e 's/port = //'`
   icmp="icmp-type $sporti code"
   sport=""; dport=""
  else
   icmp=""
   sport="$sportt"; dport="$dportt"
  fi

  if [ -n "${10}" ]; then
    ipdev="on ${10}"
    [ "$ipdev" = "on lo" ] && log=""
  fi

  if [ `echo "$prot" | egrep -c "tcp|udp"` -gt 0 ]; then
    [ "$pol" = "pass " -a "$keep_state" = "true" ] && state="keep state"
  fi

  if [ "$4" = "-k" ]; then
    flag="flags A/A"
    [ "$state" = "keep state" ] && skip=true;
  fi
 fi

 if [ $skip != true ]; then
  [ -n "$ipf_opt" ] && echo >> $FWDIR/log/$ip_cmd.log -n "$ipf_opt# "
  echo "$ipopt $pol $dir $log $quick $ipdev $prot $src $sport $dst $dport $icmp $state $flag" >> $FWDIR/log/$ip_cmd.log
  if [ "x$verbose" = xtrue ]; then
    [ -n "$ipf_opt" ] && echo -n "$ipf_opt# "
    echo "$ipopt $pol $dir $log $quick $ipdev $prot $src $sport $dst $dport $icmp $state $flag"
  fi
  if [ "x$testing" != xtrue ]; then
    [ -n "$ipf_opt" ] && echo >> $FWDIR/setup/$setup_file -n "$ipf_opt# "
    [ "$setup_file" != not_defined ] && echo >> $FWDIR/setup/$setup_file "$ipopt $pol $dir $log $quick $ipdev $prot $src $sport $dst $dport $icmp $state $flag"
    echo "$ipopt $pol $dir $log $quick $ipdev $prot $src $sport $dst $dport $icmp $state $flag" | $IPFWADM "$ipf_opt" -f - 
  fi
 fi
}

fi
