#!/bin/sh
# $Id: gateway.sh,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: gateway.sh
# Desc: definition of the GATEWAY  filtering function (ipgw)
#       definition of the TRUSTED  filtering function (tipgw)
#       definition of the FIREWALL filtering function (ipfw)
#       definition of the EXTERNAL filtering function (eipgw)
#
# Author : Jens Friedrich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 Jens Friedrich
#
# $Log: gateway.sh,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:19  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:46  jens
# .
#
# Revision 1.1  1999/08/01 21:44:46  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.1  1998/10/30 14:22:51  jens
# entered into RCS
#
# 98/10/14 inserted IP Masquerading in ipgw()
#
# Revision 1.0.9.1  1998/06/01 19:34:40  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:24  jens
# initial ci -r 1.0
#
#

if [ -z "$GATEWAY" ]; then
GATEWAY=defined

# where is the firewall-package located ?
[ -z "$FWDIR" ] && FWDIR=`echo $0 | sed -e 's/[\/]etc[\/][A-Za-z0-9_\.-]*$//'`

# default
[ -z "$ip_cmd" ] && ip_cmd="ipfwadm"

case "$ip_cmd" in
	ipfwadm)
		IPFWADM=/sbin/ipfwadm
		IPFW="f_ipfwadm"
		IPFWCMD=`basename $IPFWADM`
                . $FWDIR/etc/ipfwadm.sh
		;;
	ipchains)
		IPFWADM=/sbin/ipchains
		IPFW="f_ipchains"
		IPFWCMD=`basename $IPFWADM`
                . $FWDIR/etc/ipchains.sh
		;;
	ipF)
		IPFWADM=/sbin/ipf
		IPFW="f_ipfilter"
		IPFWCMD=`basename $IPFWADM`
                . $FWDIR/etc/ipFilter.sh
		;;
esac

setup_file="not_defined"

# temporary masquerading Ports should be defined in aliases.cfg
[ -z "$msqPorts" ] && msqPorts="$client"

# calc the netmask value (-1 = 0xffffffff)
nmsk=0
if [ "`echo "$NETMASK" | sed s/[0-9]//g`" = "..." ] ; then   # e.g. NETMASK=255.255.255.0
  for i in `echo $NETMASK | sed 's/\./ /g'`; do
    nmsk=$((($nmsk<<8)+$i))
  done
elif [ "`echo ".$NETMASK." | sed s/[0-9]//g`" = ".." ]; then # e.g. NETMASK=24
  cnt=$((32-$NETMASK))   # IPv4 - use 48 with IPv6
  while [ $cnt -gt 0 ]; do
    cnt=$(($cnt-1))
    nmsk=$(($nmsk+(1<<$cnt)))
  done
  nmsk=$((-1-$nmsk))
else
  cat << EOF

  ERROR: unknown NETMASK format ($NETMASK)
         format: 255.255.255.0  or   24

EOF
  exit 5
fi

# calc the network value
nwrk=0
if [ `echo "$DOMAIN" | sed -e 's/[0-9]//g' -e 's/\/.*//g' | grep -q ...` ] ; then
  for i in `echo "$DOMAIN" | sed -e 's/\/.*//g' -e 's/\./ /g'`; do
    nwrk=$((($nwrk<<8)+$i))
  done
  nwrk=$(($nwrk&$nmsk))
else                      # e.g. DOMAIN=jhf.de
  if grep -q "\b$DOMAIN\b" /etc/networks; then
   for i in `grep "\b$DOMAIN\b" /etc/networks | awk '{print $2}' | sed 's/\./ /g'`; do
    nwrk=$((($nwrk<<8)+$i))
   done
   nwrk=$(($nwrk&$nmsk))
#--- i think we don't need to skip here---
#  else
#  cat << EOF
#
#  ERROR: missing entry in /etc/networks for DOMAIN ($DOMAIN)
#         e.g. entry:  jhf.de   192.168.2.0   255.255.255.0
#
#EOF
#  exit 5
  fi
fi

# ----------------
# GATEWAY Function
# ----------------
# implementation of filtering rules for a gateway
# the gateway has an incoming and an outgoing device
# IP Masquerading is possible for outgoing connections

# ipgw (
#       opt               add    | del
#       action            accept | deny
#       direction         in     | out
#       src               $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       dest              $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       src-prt           <port> | <from:to>
#       dest-prt          <port> | <from:to>
#       proto             tcp    | udp       | icmp
#       ack               ""     | ack
#       log               log
#       msq               imq    | pmq
#      )

ipgw ()
{
  # might be useful for debugging, JH
  # echo "ipgw()" $1 $2 $3 $4 $5 $6 $7 $8 $9 ${10} ${11} ${12}

  # interprete parameters
  
  opt="-a"
  [ "$1" = del ] && opt="-d"
  shift

  ack=""
  [ "-$8" = "-ack" ] && ack="-k"

  iplog=""
  [ "$8" = "log" ] && iplog="log"

  srcm="$3"
  destm="$4"

  srcprt="$5"
  [ "$5" = "any" ] && srcprt=""

  destprt="$6"
  [ "$6" = "any" ] && destprt=""

  proto="$7"
  [ "$7" = "any" ] && proto=""

  masq=""
  MFW=`echo "$FW" | awk '{print $1}'`

  # masquerading is not available for ipfilter
  if [ "$IPFW" = "f_ipfilter" ]; then
      masquerade_internal=""
      masquerade_perimeter=""
      imq=""
      pmq=""
      ipmq=""
  fi

  # there are 3 incoming and 3 outgoing routings:  $OUT_DEV  -> $IN_DEV
  # I: $ANY      -> $INTERNAL    $OUT_DEV0 -> $IN_DEV0
  # I: $ANY      -> $INSRV       $OUT_DEV0 -> $IN_DEV1
  # I: $INSRV    -> $INTERNAL    $IN_DEV1  -> $IN_DEV0
  # O: $INTERNAL -> $ANY         $IN_DEV0  -> $OUT_DEV0
  # O: $INTERNAL -> $INSRV       $IN_DEV0  -> $IN_DEV1
  # O: $INSRV    -> $ANY         $IN_DEV1  -> $OUT_DEV0

  if [ $# -gt 3 ]; then
    case $2 in
      -I) if [ `echo $PERIMETER | grep -c "$srcm"` -gt 0 ]; then
              OUT_DEV=$IN_DEV1
          else
              OUT_DEV=$OUT_DEV0
          fi
          if [ `echo $PERIMETER | grep -c "$destm"` -gt 0 ]; then
              IN_DEV=$IN_DEV1
          else
              IN_DEV=$IN_DEV0
          fi

          # activate masquerading ?
          if [ "$OUT_DEV" = "$OUT_DEV0" ]; then
            [ "$masquerade_internal"  = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$masquerade_perimeter" = true -a "$IN_DEV" = "$IN_DEV1" ] && masq="true"
            [ "$imq" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$pmq" = true -a "$IN_DEV" = "$IN_DEV1" ] && masq="true"
          elif [ "$OUT_DEV" = "$IN_DEV1" ]; then
            [ "$masquerade_int_peri" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$ipmq" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
          fi

          if [ "`uname -s -r | egrep -c 'Linux.*\b2\.0|Linux.*\b1\.'`" -gt 0 ]; then
            # Linux 1.x - 2.0 : masqerading doesnt support icmp, only accept is valid
            [ "$proto" = icmp -o "$1" != "accept" ] && masq=""
          else
            # Linux 2.1 and above: masqerading DOES support icmp, only accept is valid
            [ "$1" != "accept" ] && masq=""
            # TODO: I dont know what to use here!
            [ "$proto" = icmp ] && msqPorts="$client"
            # TODO: I dont know what to do, so cancel ICMP-Masqu. until i know
            #[ "$proto" = icmp ] && masq=""
          fi

          # masqerading uses temporary ports ($msqPorts)!
          if [ "$masq" = true ]; then
              destprtm="$msqPorts"
          else
              destprtm="$destprt"
          fi

          if [ -n "$OUT_DEV" -a -n "$IN_DEV" ]; then

            # masquerade incoming: remember dest a. opt, masq dest
            if [ "$masq" = true ]; then
                mdest="$destm"
                destm="$MFW"
                if [ "$opt" = -a ]; then
                    mopt="$opt"
                    opt="-i"
                fi
            fi

            for dev in $OUT_DEV; do
              for dpm in $destprtm; do
                $IPFW -I "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$dpm" "$proto" "$dev" "$iplog"
              done
              # dest-port empty (e.g. ICMP), so above loop wasnt entered
              [ `echo "$destprtm" | egrep -c '\w'` -eq 0 ] && \
                $IPFW -I "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "" "$proto" "$dev" "$iplog"
            done

            # masquerade incoming: restore dest, opt
            if [ -n "$masq" ]; then
                destm="$mdest"
                opt="$mopt"
            else
              if [ -z "$iplog" ]; then
                $IPFW -F "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" -b
              fi
            fi

            if [ "$proto" != tcp -o -z "$iplog" ]; then
              for dev in $IN_DEV; do
                $IPFW -O "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" "$dev"
              done
            fi
          else
            if [ "$destm" = "$MFW" -a -n "$OUT_DEV" ]; then
              for dev in $OUT_DEV; do
                  $IPFW -I "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" "$dev" "$iplog"
              done
            fi
          fi
          ;;

      -O) if [ `echo $PERIMETER | grep -c "$destm"` -gt 0 ]; then
              OUT_DEV=$IN_DEV1
          else
              OUT_DEV=$OUT_DEV0
          fi
          if [ `echo $PERIMETER | grep -c "$srcm"` -gt 0 ]; then
              IN_DEV=$IN_DEV1
          else
              IN_DEV=$IN_DEV0
          fi

          # activate masquerading ?
          if [ "$OUT_DEV" = "$OUT_DEV0" ]; then
            [ "$masquerade_internal"  = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$masquerade_perimeter" = true -a "$IN_DEV" = "$IN_DEV1" ] && masq="true"
            [ "$imq" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$pmq" = true -a "$IN_DEV" = "$IN_DEV1" ] && masq="true"
          elif [ "$OUT_DEV" = "$IN_DEV1" ]; then
            [ "$masquerade_int_peri" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
            [ "$ipmq" = true -a "$IN_DEV" = "$IN_DEV0" ] && masq="true"
          fi

          if [ "`uname -s -r | egrep -c 'Linux.*\b2\.0|Linux.*\b1\.'`" -gt 0 ]; then
            # Linux 1.x - 2.0 : masqerading doesnt support icmp, only accept is valid
            [ "$proto" = icmp -o "$1" != "accept" ] && masq=""
          else
            # Linux 2.1 and above: masqerading DOES support icmp, only accept is valid
            [ "$1" != "accept" ] && masq=""
            # TODO: I dont know what to use here!
            [ "$proto" = icmp ] && msqPorts="$client"
            # TODO: I dont know what to do, so cancel ICMP-Masqu. until i know
            #[ "$proto" = icmp ] && masq=""
          fi

          # masqerading uses temporary ports ($msqPorts)!
          if [ "$masq" = true ]; then
              optm="-m $opt"
              srcprtm="$msqPorts"
          else
              optm="$opt"
              srcprtm="$srcprt"
          fi

          if [ -n "$OUT_DEV" -a -n "$IN_DEV" ]; then
            for dev in $IN_DEV; do
                $IPFW -I "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" "$dev" "$iplog"
            done
            if [ "$proto" != tcp -o -z "$iplog" ]; then
              $IPFW -F "$optm" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" -b

              # masquerade outgoing: rewrite src
              if [ "$masq" = true ]; then
                  srcm="$MFW"
                  [ "$opt" = -a ] && opt="-i"
              fi

              for dev in $OUT_DEV; do
                for spm in $srcprtm; do
                  $IPFW -O "$opt" "$1" "$ack" "$srcm" "$spm" "$destm" "$destprt" "$proto" "$dev"
                done
                # source-port empty, so above loop wasnt entered
                [ `echo "$srcprtm" | egrep -c '\w'` -eq 0 ] && \
                  $IPFW -O "$opt" "$1" "$ack" "$srcm" "" "$destm" "$destprt" "$proto" "$dev"
              done
            fi
          else
            if [ "$srcm" = "$MFW" -a -n "$IN_DEV" ]; then
              for dev in $OUT_DEV; do
                  $IPFW -O "$opt" "$1" "$ack" "$srcm" "$srcprt" "$destm" "$destprt" "$proto" "$dev" "$iplog"
              done
            fi
          fi
          ;;
    esac
  fi
}


# -----------------
# FIREWALL Function
# -----------------
# implementation of filtering rules for the firewall itself
# the firewall has only an incommnig device
# (if we use an outgoing device too, it would be a gateway)

# ipfw (
#       opt               add    | del
#       action            accept | deny
#       direction         in     | out
#       src               $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       dest              $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       src-prt           <port> | <from:to>
#       dest-prt          <port> | <from:to>
#       proto             tcp    | udp       | icmp
#       ack               ""     | ack
#      )

ipfw ()
{
  # Might be usefull for debugging, JH - needs ksh
  # echo "ipfw()" $1 $2 $3 $4 $5 $6 $7 $8 $9 ${10}

  opt="-a"
  [ "$1" = del ] && opt="-d"
  [ "$1" = ins ] && opt="-i"
  shift

  ack=""
  [ "-$8" = "-ack" ] && ack="-k"

  iplog=""
  [ "$8" = "log" ] && iplog="log"

  src_here=$3
  dest_here=$4

  srcprt="$5"
  [ "$5" = "any" ] && srcprt=""

  destprt="$6"
  [ "$6" = "any" ] && destprt=""

  proto="$7"
  [ "$7" = "any" ] && proto=""

  if [ $# -gt 3 ]; then
    case $2 in
      -I) 
          for i in 1; do
          if [ `echo "$3" | grep -c ^$DOMAIN` -gt 0 ]; then
            if=$IN_DEV0
            dest_here=$FW_IN
            break;
          fi
          if [ `echo "$3" | grep -c ^$FW\$` -gt 0 ]; then
            if=
            #if=lo
            break;
          fi
          if [ `echo "$3" | grep -c ^$INSRV\$` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ `echo "$3" | grep -c ^$GW\$` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ `echo "$3" | grep -c $DOMAIN` -gt 0 ]; then
            if=$IN_DEV0
            dest_here=$FW_IN
            break;
          fi
          if [ `echo "$3" | grep -c ^$ANY\$` -gt 0 ]; then
            if=$OUT_DEV0
            break;
          fi
          if [ `echo " $PERIMETER" | grep -c "$3"` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ "`echo "$3" | sed s/[0-9]//g`" = "..." ] ; then
            addr=0
            for i in `echo $3 | sed 's/\./ /g'`; do
              addr=$((($addr<<8)+$i))
            done
            if [ $(($addr&$nmsk)) = $nwrk ]; then
              if=$IN_DEV0
              dest_here=$FW_IN
              break;
            fi
          else
            if=$OUT_DEV0
          fi
          done
          for dev in $if; do
            $IPFW -I "$opt" "$1" "$ack" "$3" "$srcprt" "$dest_here" "$destprt" "$proto" "$dev" "$iplog"
          done
          ;;

      -O) 
          for i in 1; do
          if [ `echo "$4" | grep -c ^$DOMAIN` -gt 0 ]; then
            if=$IN_DEV0
            src_here=$FW_IN
            break;
          fi
          if [ `echo "$4" | grep -c ^$FW\$` -gt 0 ]; then
            if=
            break;
          fi
          if [ `echo "$4" | grep -c ^$INSRV\$` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ `echo "$4" | grep -c ^$GW\$` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ `echo "$4" | grep -c $DOMAIN` -gt 0 ]; then
            if=$IN_DEV0
            src_here=$FW_IN
            break;
          fi
          if [ `echo "$4" | grep -c ^$ANY\$` -gt 0 ]; then
            if=$OUT_DEV0
            break;
          fi
          if [ `echo " $PERIMETER" | grep -c "$4"` -gt 0 ]; then
            if=$IN_DEV1
            break;
          fi
          if [ "`echo "$4" | sed s/[0-9]//g`" = "..." ] ; then
            addr=0
            for i in `echo $4 | sed 's/\./ /g'`; do
              addr=$((($addr<<8)+$i))
            done
            if [ $(($addr&$nmsk)) = $nwrk ]; then
              if=$IN_DEV0
              src_here=$FW_IN
              break;
            fi
          else
            if=$OUT_DEV0
          fi
          done
          for dev in $if; do
            $IPFW -O "$opt" "$1" "$ack" "$src_here" "$srcprt" "$4" "$destprt" "$proto" "$dev" "$iplog"
          done
          ;;
    esac
  fi
}

# ----------------------
# TRUSTED HOSTS Function 
# ----------------------
# implementation of filtering rules for "Trusted Hosts"
# we have an incoming device and an outgoing device
# -> use the firewall as a gateway
# be carefull using this form of the gateway, because
# every connection is allowed for "trusted hosts"

# tipgw (
#        opt            add | del | ins
#        host           <host>
#        device         <device>
#       )

tipgw ()
{
  opt="-a"
  [ "$1" = del ] && opt="-d"
  [ "$1" = ins ] && opt="-i"
  shift

  iplog=""
  [ "$3" = "log" ] && iplog="log"


  if [ $# -gt 1 ]; then
    if [ -n "$IN_DEV0" ]; then
      $IPFW -I "$opt" accept "" "$1"        "" "$INTERNAL" "" "" "$2"       "$iplog"
      $IPFW -O "$opt" accept "" "$1"        "" "$INTERNAL" "" "" "$IN_DEV0"
      $IPFW -F "$opt" accept "" "$1"        "" "$INTERNAL" "" "" -b
      $IPFW -I "$opt" accept "" "$INTERNAL" "" "$1"        "" "" "$IN_DEV0"
      $IPFW -O "$opt" accept "" "$INTERNAL" "" "$1"        "" "" "$2"       "$iplog"
      $IPFW -F "$opt" accept "" "$INTERNAL" "" "$1"        "" "" -b
    else
      $IPFW -I "$opt" accept "" "$1"        "" "$INTERNAL" "" "" "$2"
      $IPFW -O "$opt" accept "" "$INTERNAL" "" "$1"        "" "" "$2"
    fi
    if [ -n "$IN_DEV1" -a "$IN_DEV1" != "$IN_DEV0" ]; then
      $IPFW -I "$opt" accept "" "$1"     "" "$INSRV" "" "" "$2"       "$iplog"
      $IPFW -O "$opt" accept "" "$1"     "" "$INSRV" "" "" "$IN_DEV1"
      $IPFW -F "$opt" accept "" "$1"     "" "$INSRV" "" "" -b
      $IPFW -I "$opt" accept "" "$INSRV" "" "$1"     "" "" "$IN_DEV1"
      $IPFW -O "$opt" accept "" "$INSRV" "" "$1"     "" "" "$2"       "$iplog"
      $IPFW -F "$opt" accept "" "$INSRV" "" "$1"     "" "" -b
    fi
  fi
}


# -------------------------------------
# External Gateway with specific device
# -------------------------------------
# implementation of filtering rules for an "External Gateway Interface"
# the external device is specified, the internal device is $IN_DEV0

# eipgw (
#       opt               add    | del | ins
#       action            accept | deny
#       direction         in     | out
#       src               $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       dest              $ANY   | $INTERNAL | $INSRV | <ip-addr>
#       src-prt           <port> | <from:to>
#       dest-prt          <port> | <from:to>
#       proto             tcp    | udp       | icmp
#       ack               ""     | ack
#       dev               (e.g. ippp1)
#      )

eipgw ()
{
  opt="-a"
  [ "$1" = del ] && opt="-d"
  [ "$1" = ins ] && opt="-i"
  shift

  ack=""
  [ "-$8" = "-ack" ] && ack='-k'

  srcprt="$5"
  [ "$5" = "any" ] && srcprt=""

  destprt="$6"
  [ "$6" = "any" ] && destprt=""

  proto="$7"
  [ "$7" = "any" ] && proto=""

  OUT_DEV=$9
  IN_DEV=$IN_DEV0

  case $2 in
      -I)
          $IPFW -I "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" "$OUT_DEV"
          $IPFW -O "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" "$IN_DEV"
          $IPFW -F "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" -b
          ;;

      -O)
          $IPFW -I "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" "$IN_DEV"
          $IPFW -O "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" "$OUT_DEV"
          $IPFW -F "$opt" "$1" "$ack" "$3" "$srcprt" "$4" "$destprt" "$proto" -b
          ;;
  esac
}

fi

